/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.transform;

import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediastoredata.model.GetObjectResponse;
import software.amazon.awssdk.utils.DateUtils;

public class GetObjectResponseUnmarshaller
implements Unmarshaller<GetObjectResponse, JsonUnmarshallerContext> {
    private static final GetObjectResponseUnmarshaller INSTANCE = new GetObjectResponseUnmarshaller();

    public GetObjectResponse unmarshall(JsonUnmarshallerContext context) throws Exception {
        GetObjectResponse.Builder getObjectResponseBuilder = GetObjectResponse.builder();
        if (context.isStartOfDocument()) {
            if (context.getHeader("Cache-Control") != null) {
                context.setCurrentHeader("Cache-Control");
                getObjectResponseBuilder.cacheControl((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Content-Range") != null) {
                context.setCurrentHeader("Content-Range");
                getObjectResponseBuilder.contentRange((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Content-Length") != null) {
                context.setCurrentHeader("Content-Length");
                getObjectResponseBuilder.contentLength((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
            }
            if (context.getHeader("Content-Type") != null) {
                context.setCurrentHeader("Content-Type");
                getObjectResponseBuilder.contentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("ETag") != null) {
                context.setCurrentHeader("ETag");
                getObjectResponseBuilder.eTag((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
            }
            if (context.getHeader("Last-Modified") != null) {
                context.setCurrentHeader("Last-Modified");
                getObjectResponseBuilder.lastModified(DateUtils.parseRfc1123Date((String)context.readText()));
            }
        }
        getObjectResponseBuilder.statusCode(context.getHttpResponse().statusCode());
        return (GetObjectResponse)((Object)getObjectResponseBuilder.build());
    }

    public static GetObjectResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}

