/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.mediastoredata.model.Item;

public class ItemUnmarshaller
implements Unmarshaller<Item, JsonUnmarshallerContext> {
    private static final ItemUnmarshaller INSTANCE = new ItemUnmarshaller();

    public Item unmarshall(JsonUnmarshallerContext context) throws Exception {
        Item.Builder itemBuilder = Item.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    itemBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    itemBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ETag", targetDepth)) {
                    context.nextToken();
                    itemBuilder.eTag((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("LastModified", targetDepth)) {
                    context.nextToken();
                    itemBuilder.lastModified((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
                if (context.testExpression("ContentType", targetDepth)) {
                    context.nextToken();
                    itemBuilder.contentType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ContentLength", targetDepth)) {
                    context.nextToken();
                    itemBuilder.contentLength((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Item)itemBuilder.build();
    }

    public static ItemUnmarshaller getInstance() {
        return INSTANCE;
    }
}

