/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.mediastoredata.model.PutObjectRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class PutObjectRequestModelMarshaller {
    private static final MarshallingInfo<String> PATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.GREEDY_PATH).marshallLocationName("Path").isBinary(false).build();
    private static final MarshallingInfo<String> CONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Content-Type").isBinary(false).build();
    private static final MarshallingInfo<String> CACHECONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("Cache-Control").isBinary(false).build();
    private static final MarshallingInfo<String> STORAGECLASS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.HEADER).marshallLocationName("x-amz-storage-class").isBinary(false).build();
    private static final PutObjectRequestModelMarshaller INSTANCE = new PutObjectRequestModelMarshaller();

    private PutObjectRequestModelMarshaller() {
    }

    public static PutObjectRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(PutObjectRequest putObjectRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)putObjectRequest), (String)"putObjectRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)putObjectRequest.path(), PATH_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.contentType(), CONTENTTYPE_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.cacheControl(), CACHECONTROL_BINDING);
            protocolMarshaller.marshall((Object)putObjectRequest.storageClassAsString(), STORAGECLASS_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

