/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutObjectResponse extends MediaStoreDataResponse implements
        ToCopyableBuilder<PutObjectResponse.Builder, PutObjectResponse> {
    private static final SdkField<String> CONTENT_SHA256_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectResponse::contentSHA256)).setter(setter(Builder::contentSHA256))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSHA256").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectResponse::storageClassAsString)).setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_SHA256_FIELD,
            E_TAG_FIELD, STORAGE_CLASS_FIELD));

    private final String contentSHA256;

    private final String eTag;

    private final String storageClass;

    private PutObjectResponse(BuilderImpl builder) {
        super(builder);
        this.contentSHA256 = builder.contentSHA256;
        this.eTag = builder.eTag;
        this.storageClass = builder.storageClass;
    }

    /**
     * <p>
     * The SHA256 digest of the object that is persisted.
     * </p>
     * 
     * @return The SHA256 digest of the object that is persisted.
     */
    public String contentSHA256() {
        return contentSHA256;
    }

    /**
     * <p>
     * Unique identifier of the object in the container.
     * </p>
     * 
     * @return Unique identifier of the object in the container.
     */
    public String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The storage class where the object was persisted. Should be â€œTemporalâ€.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The storage class where the object was persisted. Should be â€œTemporalâ€.
     * @see StorageClass
     */
    public StorageClass storageClass() {
        return StorageClass.fromValue(storageClass);
    }

    /**
     * <p>
     * The storage class where the object was persisted. Should be â€œTemporalâ€.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return The storage class where the object was persisted. Should be â€œTemporalâ€.
     * @see StorageClass
     */
    public String storageClassAsString() {
        return storageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(contentSHA256());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectResponse)) {
            return false;
        }
        PutObjectResponse other = (PutObjectResponse) obj;
        return Objects.equals(contentSHA256(), other.contentSHA256()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(storageClassAsString(), other.storageClassAsString());
    }

    @Override
    public String toString() {
        return ToString.builder("PutObjectResponse").add("ContentSHA256", contentSHA256()).add("ETag", eTag())
                .add("StorageClass", storageClassAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContentSHA256":
            return Optional.ofNullable(clazz.cast(contentSHA256()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectResponse, T> g) {
        return obj -> g.apply((PutObjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutObjectResponse> {
        /**
         * <p>
         * The SHA256 digest of the object that is persisted.
         * </p>
         * 
         * @param contentSHA256
         *        The SHA256 digest of the object that is persisted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSHA256(String contentSHA256);

        /**
         * <p>
         * Unique identifier of the object in the container.
         * </p>
         * 
         * @param eTag
         *        Unique identifier of the object in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The storage class where the object was persisted. Should be â€œTemporalâ€.
         * </p>
         * 
         * @param storageClass
         *        The storage class where the object was persisted. Should be â€œTemporalâ€.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * <p>
         * The storage class where the object was persisted. Should be â€œTemporalâ€.
         * </p>
         * 
         * @param storageClass
         *        The storage class where the object was persisted. Should be â€œTemporalâ€.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);
    }

    static final class BuilderImpl extends MediaStoreDataResponse.BuilderImpl implements Builder {
        private String contentSHA256;

        private String eTag;

        private String storageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectResponse model) {
            super(model);
            contentSHA256(model.contentSHA256);
            eTag(model.eTag);
            storageClass(model.storageClass);
        }

        public final String getContentSHA256() {
            return contentSHA256;
        }

        @Override
        public final Builder contentSHA256(String contentSHA256) {
            this.contentSHA256 = contentSHA256;
            return this;
        }

        public final void setContentSHA256(String contentSHA256) {
            this.contentSHA256 = contentSHA256;
        }

        public final String getETag() {
            return eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public PutObjectResponse build() {
            return new PutObjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
