/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetObjectRequest extends MediaStoreDataRequest implements
        ToCopyableBuilder<GetObjectRequest.Builder, GetObjectRequest> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetObjectRequest::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("Path").build()).build();

    private static final SdkField<String> RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetObjectRequest::range)).setter(setter(Builder::range))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Range").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, RANGE_FIELD));

    private final String path;

    private final String range;

    private GetObjectRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.range = builder.range;
    }

    /**
     * <p>
     * The path (including the file name) where the object is stored in the container. Format: &lt;folder
     * name&gt;/&lt;folder name&gt;/&lt;file name&gt;
     * </p>
     * <p>
     * For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\canada</code> in the
     * container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.
     * </p>
     * <p>
     * Do not include the container name in this path.
     * </p>
     * <p>
     * If the path includes any folders that don't exist yet, the service creates them. For example, suppose you have an
     * existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>, the service creates a
     * <code>canada</code> subfolder in the <code>premium</code> folder. You then have two subfolders, <code>usa</code>
     * and <code>canada</code>, in the <code>premium</code> folder.
     * </p>
     * <p>
     * There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental
     * MediaStore.
     * </p>
     * <p>
     * For more information about folders and how they exist in a container, see the <a
     * href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.
     * </p>
     * <p>
     * The file name is the name that is assigned to the file that you upload. The file can have the same name inside
     * and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an
     * extension.
     * </p>
     * 
     * @return The path (including the file name) where the object is stored in the container. Format: &lt;folder
     *         name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p>
     *         <p>
     *         For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\canada</code> in
     *         the container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.
     *         </p>
     *         <p>
     *         Do not include the container name in this path.
     *         </p>
     *         <p>
     *         If the path includes any folders that don't exist yet, the service creates them. For example, suppose you
     *         have an existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>, the
     *         service creates a <code>canada</code> subfolder in the <code>premium</code> folder. You then have two
     *         subfolders, <code>usa</code> and <code>canada</code>, in the <code>premium</code> folder.
     *         </p>
     *         <p>
     *         There is no correlation between the path to the source and the path (folders) in the container in AWS
     *         Elemental MediaStore.
     *         </p>
     *         <p>
     *         For more information about folders and how they exist in a container, see the <a
     *         href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.
     *         </p>
     *         <p>
     *         The file name is the name that is assigned to the file that you upload. The file can have the same name
     *         inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include
     *         or omit an extension.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The range bytes of an object to retrieve. For more information about the <code>Range</code> header, see <a
     * href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35"
     * >http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this
     * header for partially uploaded objects that have streaming upload availability.
     * </p>
     * 
     * @return The range bytes of an object to retrieve. For more information about the <code>Range</code> header, see
     *         <a href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols/
     *         rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially
     *         uploaded objects that have streaming upload availability.
     */
    public String range() {
        return range;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectRequest)) {
            return false;
        }
        GetObjectRequest other = (GetObjectRequest) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(range(), other.range());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetObjectRequest").add("Path", path()).add("Range", range()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetObjectRequest, T> g) {
        return obj -> g.apply((GetObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetObjectRequest> {
        /**
         * <p>
         * The path (including the file name) where the object is stored in the container. Format: &lt;folder
         * name&gt;/&lt;folder name&gt;/&lt;file name&gt;
         * </p>
         * <p>
         * For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\canada</code> in the
         * container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.
         * </p>
         * <p>
         * Do not include the container name in this path.
         * </p>
         * <p>
         * If the path includes any folders that don't exist yet, the service creates them. For example, suppose you
         * have an existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>, the service
         * creates a <code>canada</code> subfolder in the <code>premium</code> folder. You then have two subfolders,
         * <code>usa</code> and <code>canada</code>, in the <code>premium</code> folder.
         * </p>
         * <p>
         * There is no correlation between the path to the source and the path (folders) in the container in AWS
         * Elemental MediaStore.
         * </p>
         * <p>
         * For more information about folders and how they exist in a container, see the <a
         * href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.
         * </p>
         * <p>
         * The file name is the name that is assigned to the file that you upload. The file can have the same name
         * inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or
         * omit an extension.
         * </p>
         * 
         * @param path
         *        The path (including the file name) where the object is stored in the container. Format: &lt;folder
         *        name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p>
         *        <p>
         *        For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\canada</code>
         *        in the container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.
         *        </p>
         *        <p>
         *        Do not include the container name in this path.
         *        </p>
         *        <p>
         *        If the path includes any folders that don't exist yet, the service creates them. For example, suppose
         *        you have an existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>,
         *        the service creates a <code>canada</code> subfolder in the <code>premium</code> folder. You then have
         *        two subfolders, <code>usa</code> and <code>canada</code>, in the <code>premium</code> folder.
         *        </p>
         *        <p>
         *        There is no correlation between the path to the source and the path (folders) in the container in AWS
         *        Elemental MediaStore.
         *        </p>
         *        <p>
         *        For more information about folders and how they exist in a container, see the <a
         *        href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.
         *        </p>
         *        <p>
         *        The file name is the name that is assigned to the file that you upload. The file can have the same
         *        name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can
         *        include or omit an extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The range bytes of an object to retrieve. For more information about the <code>Range</code> header, see <a
         * href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols/rfc2616/
         * rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially uploaded objects
         * that have streaming upload availability.
         * </p>
         * 
         * @param range
         *        The range bytes of an object to retrieve. For more information about the <code>Range</code> header,
         *        see <a
         *        href="http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35">http://www.w3.org/Protocols
         *        /rfc2616/rfc2616-sec14.html#sec14.35</a>. AWS Elemental MediaStore ignores this header for partially
         *        uploaded objects that have streaming upload availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(String range);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaStoreDataRequest.BuilderImpl implements Builder {
        private String path;

        private String range;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectRequest model) {
            super(model);
            path(model.path);
            range(model.range);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRange() {
            return range;
        }

        @Override
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetObjectRequest build() {
            return new GetObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
