/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListItemsResponse extends MediaStoreDataResponse implements
        ToCopyableBuilder<ListItemsResponse.Builder, ListItemsResponse> {
    private static final SdkField<List<Item>> ITEMS_FIELD = SdkField
            .<List<Item>> builder(MarshallingType.LIST)
            .getter(getter(ListItemsResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Item> builder(MarshallingType.SDK_POJO)
                                            .constructor(Item::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListItemsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Item> items;

    private final String nextToken;

    private ListItemsResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata entries for the folders and objects at the requested path.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata entries for the folders and objects at the requested path.
     */
    public List<Item> items() {
        return items;
    }

    /**
     * <p>
     * The token that can be used in a request to view the next set of results. For example, you submit a
     * <code>ListItems</code> request that matches 2,000 items with <code>MaxResults</code> set at 500. The service
     * returns the first batch of results (up to 500) and a <code>NextToken</code> value that can be used to fetch the
     * next batch of results.
     * </p>
     * 
     * @return The token that can be used in a request to view the next set of results. For example, you submit a
     *         <code>ListItems</code> request that matches 2,000 items with <code>MaxResults</code> set at 500. The
     *         service returns the first batch of results (up to 500) and a <code>NextToken</code> value that can be
     *         used to fetch the next batch of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(items());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListItemsResponse)) {
            return false;
        }
        ListItemsResponse other = (ListItemsResponse) obj;
        return Objects.equals(items(), other.items()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListItemsResponse").add("Items", items()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListItemsResponse, T> g) {
        return obj -> g.apply((ListItemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListItemsResponse> {
        /**
         * <p>
         * The metadata entries for the folders and objects at the requested path.
         * </p>
         * 
         * @param items
         *        The metadata entries for the folders and objects at the requested path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<Item> items);

        /**
         * <p>
         * The metadata entries for the folders and objects at the requested path.
         * </p>
         * 
         * @param items
         *        The metadata entries for the folders and objects at the requested path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Item... items);

        /**
         * <p>
         * The metadata entries for the folders and objects at the requested path.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Item>.Builder} avoiding the need to create
         * one manually via {@link List<Item>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Item>.Builder#build()} is called immediately and its result
         * is passed to {@link #items(List<Item>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<Item>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<Item>)
         */
        Builder items(Consumer<Item.Builder>... items);

        /**
         * <p>
         * The token that can be used in a request to view the next set of results. For example, you submit a
         * <code>ListItems</code> request that matches 2,000 items with <code>MaxResults</code> set at 500. The service
         * returns the first batch of results (up to 500) and a <code>NextToken</code> value that can be used to fetch
         * the next batch of results.
         * </p>
         * 
         * @param nextToken
         *        The token that can be used in a request to view the next set of results. For example, you submit a
         *        <code>ListItems</code> request that matches 2,000 items with <code>MaxResults</code> set at 500. The
         *        service returns the first batch of results (up to 500) and a <code>NextToken</code> value that can be
         *        used to fetch the next batch of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaStoreDataResponse.BuilderImpl implements Builder {
        private List<Item> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListItemsResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
        }

        public final Collection<Item.Builder> getItems() {
            return items != null ? items.stream().map(Item::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder items(Collection<Item> items) {
            this.items = ItemListCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Item... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<Item.Builder>... items) {
            items(Stream.of(items).map(c -> Item.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<Item.BuilderImpl> items) {
            this.items = ItemListCopier.copyFromBuilder(items);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListItemsResponse build() {
            return new ListItemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
