/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutObjectRequest extends MediaStoreDataRequest implements
        ToCopyableBuilder<PutObjectRequest.Builder, PutObjectRequest> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRequest::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("Path").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRequest::cacheControl)).setter(setter(Builder::cacheControl))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Cache-Control").build()).build();

    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRequest::storageClassAsString)).setter(setter(Builder::storageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-storage-class").build())
            .build();

    private static final SdkField<String> UPLOAD_AVAILABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PutObjectRequest::uploadAvailabilityAsString)).setter(setter(Builder::uploadAvailability))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-upload-availability").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD,
            CONTENT_TYPE_FIELD, CACHE_CONTROL_FIELD, STORAGE_CLASS_FIELD, UPLOAD_AVAILABILITY_FIELD));

    private final String path;

    private final String contentType;

    private final String cacheControl;

    private final String storageClass;

    private final String uploadAvailability;

    private PutObjectRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.contentType = builder.contentType;
        this.cacheControl = builder.cacheControl;
        this.storageClass = builder.storageClass;
        this.uploadAvailability = builder.uploadAvailability;
    }

    /**
     * <p>
     * The path (including the file name) where the object is stored in the container. Format: &lt;folder
     * name&gt;/&lt;folder name&gt;/&lt;file name&gt;
     * </p>
     * <p>
     * For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\canada</code> in the
     * container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.
     * </p>
     * <p>
     * Do not include the container name in this path.
     * </p>
     * <p>
     * If the path includes any folders that don't exist yet, the service creates them. For example, suppose you have an
     * existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>, the service creates a
     * <code>canada</code> subfolder in the <code>premium</code> folder. You then have two subfolders, <code>usa</code>
     * and <code>canada</code>, in the <code>premium</code> folder.
     * </p>
     * <p>
     * There is no correlation between the path to the source and the path (folders) in the container in AWS Elemental
     * MediaStore.
     * </p>
     * <p>
     * For more information about folders and how they exist in a container, see the <a
     * href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.
     * </p>
     * <p>
     * The file name is the name that is assigned to the file that you upload. The file can have the same name inside
     * and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or omit an
     * extension.
     * </p>
     * 
     * @return The path (including the file name) where the object is stored in the container. Format: &lt;folder
     *         name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p>
     *         <p>
     *         For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\canada</code> in
     *         the container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.
     *         </p>
     *         <p>
     *         Do not include the container name in this path.
     *         </p>
     *         <p>
     *         If the path includes any folders that don't exist yet, the service creates them. For example, suppose you
     *         have an existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>, the
     *         service creates a <code>canada</code> subfolder in the <code>premium</code> folder. You then have two
     *         subfolders, <code>usa</code> and <code>canada</code>, in the <code>premium</code> folder.
     *         </p>
     *         <p>
     *         There is no correlation between the path to the source and the path (folders) in the container in AWS
     *         Elemental MediaStore.
     *         </p>
     *         <p>
     *         For more information about folders and how they exist in a container, see the <a
     *         href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.
     *         </p>
     *         <p>
     *         The file name is the name that is assigned to the file that you upload. The file can have the same name
     *         inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include
     *         or omit an extension.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The content type of the object.
     * </p>
     * 
     * @return The content type of the object.
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p>
     * An optional <code>CacheControl</code> header that allows the caller to control the object's cache behavior.
     * Headers can be passed in as specified in the HTTP at <a
     * href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
     * >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.
     * </p>
     * <p>
     * Headers with a custom user-defined value are also accepted.
     * </p>
     * 
     * @return An optional <code>CacheControl</code> header that allows the caller to control the object's cache
     *         behavior. Headers can be passed in as specified in the HTTP at <a
     *         href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
     *         >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
     *         <p>
     *         Headers with a custom user-defined value are also accepted.
     */
    public String cacheControl() {
        return cacheControl;
    }

    /**
     * <p>
     * Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal storage class,
     * and objects are persisted into durable storage shortly after being received.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal storage
     *         class, and objects are persisted into durable storage shortly after being received.
     * @see StorageClass
     */
    public StorageClass storageClass() {
        return StorageClass.fromValue(storageClass);
    }

    /**
     * <p>
     * Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal storage class,
     * and objects are persisted into durable storage shortly after being received.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageClass} will
     * return {@link StorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageClassAsString}.
     * </p>
     * 
     * @return Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal storage
     *         class, and objects are persisted into durable storage shortly after being received.
     * @see StorageClass
     */
    public String storageClassAsString() {
        return storageClass;
    }

    /**
     * <p>
     * Indicates the availability of an object while it is still uploading. If the value is set to
     * <code>streaming</code>, the object is available for downloading after some initial buffering but before the
     * object is uploaded completely. If the value is set to <code>standard</code>, the object is available for
     * downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.
     * </p>
     * <p>
     * To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #uploadAvailability} will return {@link UploadAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #uploadAvailabilityAsString}.
     * </p>
     * 
     * @return Indicates the availability of an object while it is still uploading. If the value is set to
     *         <code>streaming</code>, the object is available for downloading after some initial buffering but before
     *         the object is uploaded completely. If the value is set to <code>standard</code>, the object is available
     *         for downloading only when it is uploaded completely. The default value for this header is
     *         <code>standard</code>.</p>
     *         <p>
     *         To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to
     *         <code>chunked</code>.
     * @see UploadAvailability
     */
    public UploadAvailability uploadAvailability() {
        return UploadAvailability.fromValue(uploadAvailability);
    }

    /**
     * <p>
     * Indicates the availability of an object while it is still uploading. If the value is set to
     * <code>streaming</code>, the object is available for downloading after some initial buffering but before the
     * object is uploaded completely. If the value is set to <code>standard</code>, the object is available for
     * downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.
     * </p>
     * <p>
     * To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #uploadAvailability} will return {@link UploadAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #uploadAvailabilityAsString}.
     * </p>
     * 
     * @return Indicates the availability of an object while it is still uploading. If the value is set to
     *         <code>streaming</code>, the object is available for downloading after some initial buffering but before
     *         the object is uploaded completely. If the value is set to <code>standard</code>, the object is available
     *         for downloading only when it is uploaded completely. The default value for this header is
     *         <code>standard</code>.</p>
     *         <p>
     *         To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to
     *         <code>chunked</code>.
     * @see UploadAvailability
     */
    public String uploadAvailabilityAsString() {
        return uploadAvailability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uploadAvailabilityAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectRequest)) {
            return false;
        }
        PutObjectRequest other = (PutObjectRequest) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(cacheControl(), other.cacheControl())
                && Objects.equals(storageClassAsString(), other.storageClassAsString())
                && Objects.equals(uploadAvailabilityAsString(), other.uploadAvailabilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutObjectRequest").add("Path", path()).add("ContentType", contentType())
                .add("CacheControl", cacheControl()).add("StorageClass", storageClassAsString())
                .add("UploadAvailability", uploadAvailabilityAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "CacheControl":
            return Optional.ofNullable(clazz.cast(cacheControl()));
        case "StorageClass":
            return Optional.ofNullable(clazz.cast(storageClassAsString()));
        case "UploadAvailability":
            return Optional.ofNullable(clazz.cast(uploadAvailabilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectRequest, T> g) {
        return obj -> g.apply((PutObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreDataRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutObjectRequest> {
        /**
         * <p>
         * The path (including the file name) where the object is stored in the container. Format: &lt;folder
         * name&gt;/&lt;folder name&gt;/&lt;file name&gt;
         * </p>
         * <p>
         * For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\canada</code> in the
         * container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.
         * </p>
         * <p>
         * Do not include the container name in this path.
         * </p>
         * <p>
         * If the path includes any folders that don't exist yet, the service creates them. For example, suppose you
         * have an existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>, the service
         * creates a <code>canada</code> subfolder in the <code>premium</code> folder. You then have two subfolders,
         * <code>usa</code> and <code>canada</code>, in the <code>premium</code> folder.
         * </p>
         * <p>
         * There is no correlation between the path to the source and the path (folders) in the container in AWS
         * Elemental MediaStore.
         * </p>
         * <p>
         * For more information about folders and how they exist in a container, see the <a
         * href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.
         * </p>
         * <p>
         * The file name is the name that is assigned to the file that you upload. The file can have the same name
         * inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can include or
         * omit an extension.
         * </p>
         * 
         * @param path
         *        The path (including the file name) where the object is stored in the container. Format: &lt;folder
         *        name&gt;/&lt;folder name&gt;/&lt;file name&gt;</p>
         *        <p>
         *        For example, to upload the file <code>mlaw.avi</code> to the folder path <code>premium\canada</code>
         *        in the container <code>movies</code>, enter the path <code>premium/canada/mlaw.avi</code>.
         *        </p>
         *        <p>
         *        Do not include the container name in this path.
         *        </p>
         *        <p>
         *        If the path includes any folders that don't exist yet, the service creates them. For example, suppose
         *        you have an existing <code>premium/usa</code> subfolder. If you specify <code>premium/canada</code>,
         *        the service creates a <code>canada</code> subfolder in the <code>premium</code> folder. You then have
         *        two subfolders, <code>usa</code> and <code>canada</code>, in the <code>premium</code> folder.
         *        </p>
         *        <p>
         *        There is no correlation between the path to the source and the path (folders) in the container in AWS
         *        Elemental MediaStore.
         *        </p>
         *        <p>
         *        For more information about folders and how they exist in a container, see the <a
         *        href="http://docs.aws.amazon.com/mediastore/latest/ug/">AWS Elemental MediaStore User Guide</a>.
         *        </p>
         *        <p>
         *        The file name is the name that is assigned to the file that you upload. The file can have the same
         *        name inside and outside of AWS Elemental MediaStore, or it can have the same name. The file name can
         *        include or omit an extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The content type of the object.
         * </p>
         * 
         * @param contentType
         *        The content type of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * An optional <code>CacheControl</code> header that allows the caller to control the object's cache behavior.
         * Headers can be passed in as specified in the HTTP at <a
         * href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
         * >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.
         * </p>
         * <p>
         * Headers with a custom user-defined value are also accepted.
         * </p>
         * 
         * @param cacheControl
         *        An optional <code>CacheControl</code> header that allows the caller to control the object's cache
         *        behavior. Headers can be passed in as specified in the HTTP at <a
         *        href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
         *        >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
         *        <p>
         *        Headers with a custom user-defined value are also accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheControl(String cacheControl);

        /**
         * <p>
         * Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal storage
         * class, and objects are persisted into durable storage shortly after being received.
         * </p>
         * 
         * @param storageClass
         *        Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal
         *        storage class, and objects are persisted into durable storage shortly after being received.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(String storageClass);

        /**
         * <p>
         * Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal storage
         * class, and objects are persisted into durable storage shortly after being received.
         * </p>
         * 
         * @param storageClass
         *        Indicates the storage class of a <code>Put</code> request. Defaults to high-performance temporal
         *        storage class, and objects are persisted into durable storage shortly after being received.
         * @see StorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageClass
         */
        Builder storageClass(StorageClass storageClass);

        /**
         * <p>
         * Indicates the availability of an object while it is still uploading. If the value is set to
         * <code>streaming</code>, the object is available for downloading after some initial buffering but before the
         * object is uploaded completely. If the value is set to <code>standard</code>, the object is available for
         * downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.
         * </p>
         * <p>
         * To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.
         * </p>
         * 
         * @param uploadAvailability
         *        Indicates the availability of an object while it is still uploading. If the value is set to
         *        <code>streaming</code>, the object is available for downloading after some initial buffering but
         *        before the object is uploaded completely. If the value is set to <code>standard</code>, the object is
         *        available for downloading only when it is uploaded completely. The default value for this header is
         *        <code>standard</code>.</p>
         *        <p>
         *        To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to
         *        <code>chunked</code>.
         * @see UploadAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadAvailability
         */
        Builder uploadAvailability(String uploadAvailability);

        /**
         * <p>
         * Indicates the availability of an object while it is still uploading. If the value is set to
         * <code>streaming</code>, the object is available for downloading after some initial buffering but before the
         * object is uploaded completely. If the value is set to <code>standard</code>, the object is available for
         * downloading only when it is uploaded completely. The default value for this header is <code>standard</code>.
         * </p>
         * <p>
         * To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to <code>chunked</code>.
         * </p>
         * 
         * @param uploadAvailability
         *        Indicates the availability of an object while it is still uploading. If the value is set to
         *        <code>streaming</code>, the object is available for downloading after some initial buffering but
         *        before the object is uploaded completely. If the value is set to <code>standard</code>, the object is
         *        available for downloading only when it is uploaded completely. The default value for this header is
         *        <code>standard</code>.</p>
         *        <p>
         *        To use this header, you must also set the HTTP <code>Transfer-Encoding</code> header to
         *        <code>chunked</code>.
         * @see UploadAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadAvailability
         */
        Builder uploadAvailability(UploadAvailability uploadAvailability);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaStoreDataRequest.BuilderImpl implements Builder {
        private String path;

        private String contentType;

        private String cacheControl;

        private String storageClass;

        private String uploadAvailability;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectRequest model) {
            super(model);
            path(model.path);
            contentType(model.contentType);
            cacheControl(model.cacheControl);
            storageClass(model.storageClass);
            uploadAvailability(model.uploadAvailability);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getCacheControl() {
            return cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        public final String getStorageClass() {
            return storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        public final String getUploadAvailability() {
            return uploadAvailability;
        }

        @Override
        public final Builder uploadAvailability(String uploadAvailability) {
            this.uploadAvailability = uploadAvailability;
            return this;
        }

        @Override
        public final Builder uploadAvailability(UploadAvailability uploadAvailability) {
            this.uploadAvailability(uploadAvailability == null ? null : uploadAvailability.toString());
            return this;
        }

        public final void setUploadAvailability(String uploadAvailability) {
            this.uploadAvailability = uploadAvailability;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutObjectRequest build() {
            return new PutObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
