/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetObjectResponse extends MediaStoreDataResponse implements
        ToCopyableBuilder<GetObjectResponse.Builder, GetObjectResponse> {
    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheControl").getter(getter(GetObjectResponse::cacheControl)).setter(setter(Builder::cacheControl))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Cache-Control").build()).build();

    private static final SdkField<String> CONTENT_RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentRange").getter(getter(GetObjectResponse::contentRange)).setter(setter(Builder::contentRange))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Range").build()).build();

    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ContentLength").getter(getter(GetObjectResponse::contentLength)).setter(setter(Builder::contentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Length").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(GetObjectResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(GetObjectResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(GetObjectResponse::lastModified)).setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Last-Modified").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusCode").getter(getter(GetObjectResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("StatusCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_CONTROL_FIELD,
            CONTENT_RANGE_FIELD, CONTENT_LENGTH_FIELD, CONTENT_TYPE_FIELD, E_TAG_FIELD, LAST_MODIFIED_FIELD, STATUS_CODE_FIELD));

    private final String cacheControl;

    private final String contentRange;

    private final Long contentLength;

    private final String contentType;

    private final String eTag;

    private final Instant lastModified;

    private final Integer statusCode;

    private GetObjectResponse(BuilderImpl builder) {
        super(builder);
        this.cacheControl = builder.cacheControl;
        this.contentRange = builder.contentRange;
        this.contentLength = builder.contentLength;
        this.contentType = builder.contentType;
        this.eTag = builder.eTag;
        this.lastModified = builder.lastModified;
        this.statusCode = builder.statusCode;
    }

    /**
     * <p>
     * An optional <code>CacheControl</code> header that allows the caller to control the object's cache behavior.
     * Headers can be passed in as specified in the HTTP spec at <a
     * href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
     * >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.
     * </p>
     * <p>
     * Headers with a custom user-defined value are also accepted.
     * </p>
     * 
     * @return An optional <code>CacheControl</code> header that allows the caller to control the object's cache
     *         behavior. Headers can be passed in as specified in the HTTP spec at <a
     *         href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
     *         >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
     *         <p>
     *         Headers with a custom user-defined value are also accepted.
     */
    public final String cacheControl() {
        return cacheControl;
    }

    /**
     * <p>
     * The range of bytes to retrieve.
     * </p>
     * 
     * @return The range of bytes to retrieve.
     */
    public final String contentRange() {
        return contentRange;
    }

    /**
     * <p>
     * The length of the object in bytes.
     * </p>
     * 
     * @return The length of the object in bytes.
     */
    public final Long contentLength() {
        return contentLength;
    }

    /**
     * <p>
     * The content type of the object.
     * </p>
     * 
     * @return The content type of the object.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The ETag that represents a unique instance of the object.
     * </p>
     * 
     * @return The ETag that represents a unique instance of the object.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The date and time that the object was last modified.
     * </p>
     * 
     * @return The date and time that the object was last modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    /**
     * <p>
     * The HTML status code of the request. Status codes ranging from 200 to 299 indicate success. All other status
     * codes indicate the type of error that occurred.
     * </p>
     * 
     * @return The HTML status code of the request. Status codes ranging from 200 to 299 indicate success. All other
     *         status codes indicate the type of error that occurred.
     */
    public final Integer statusCode() {
        return statusCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(contentRange());
        hashCode = 31 * hashCode + Objects.hashCode(contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetObjectResponse)) {
            return false;
        }
        GetObjectResponse other = (GetObjectResponse) obj;
        return Objects.equals(cacheControl(), other.cacheControl()) && Objects.equals(contentRange(), other.contentRange())
                && Objects.equals(contentLength(), other.contentLength()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(eTag(), other.eTag()) && Objects.equals(lastModified(), other.lastModified())
                && Objects.equals(statusCode(), other.statusCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetObjectResponse").add("CacheControl", cacheControl()).add("ContentRange", contentRange())
                .add("ContentLength", contentLength()).add("ContentType", contentType()).add("ETag", eTag())
                .add("LastModified", lastModified()).add("StatusCode", statusCode()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheControl":
            return Optional.ofNullable(clazz.cast(cacheControl()));
        case "ContentRange":
            return Optional.ofNullable(clazz.cast(contentRange()));
        case "ContentLength":
            return Optional.ofNullable(clazz.cast(contentLength()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetObjectResponse, T> g) {
        return obj -> g.apply((GetObjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaStoreDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetObjectResponse> {
        /**
         * <p>
         * An optional <code>CacheControl</code> header that allows the caller to control the object's cache behavior.
         * Headers can be passed in as specified in the HTTP spec at <a
         * href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
         * >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.
         * </p>
         * <p>
         * Headers with a custom user-defined value are also accepted.
         * </p>
         * 
         * @param cacheControl
         *        An optional <code>CacheControl</code> header that allows the caller to control the object's cache
         *        behavior. Headers can be passed in as specified in the HTTP spec at <a
         *        href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
         *        >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
         *        <p>
         *        Headers with a custom user-defined value are also accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheControl(String cacheControl);

        /**
         * <p>
         * The range of bytes to retrieve.
         * </p>
         * 
         * @param contentRange
         *        The range of bytes to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentRange(String contentRange);

        /**
         * <p>
         * The length of the object in bytes.
         * </p>
         * 
         * @param contentLength
         *        The length of the object in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLength(Long contentLength);

        /**
         * <p>
         * The content type of the object.
         * </p>
         * 
         * @param contentType
         *        The content type of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The ETag that represents a unique instance of the object.
         * </p>
         * 
         * @param eTag
         *        The ETag that represents a unique instance of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The date and time that the object was last modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time that the object was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);

        /**
         * <p>
         * The HTML status code of the request. Status codes ranging from 200 to 299 indicate success. All other status
         * codes indicate the type of error that occurred.
         * </p>
         * 
         * @param statusCode
         *        The HTML status code of the request. Status codes ranging from 200 to 299 indicate success. All other
         *        status codes indicate the type of error that occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);
    }

    static final class BuilderImpl extends MediaStoreDataResponse.BuilderImpl implements Builder {
        private String cacheControl;

        private String contentRange;

        private Long contentLength;

        private String contentType;

        private String eTag;

        private Instant lastModified;

        private Integer statusCode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetObjectResponse model) {
            super(model);
            cacheControl(model.cacheControl);
            contentRange(model.contentRange);
            contentLength(model.contentLength);
            contentType(model.contentType);
            eTag(model.eTag);
            lastModified(model.lastModified);
            statusCode(model.statusCode);
        }

        public final String getCacheControl() {
            return cacheControl;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @Override
        @Transient
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final String getContentRange() {
            return contentRange;
        }

        public final void setContentRange(String contentRange) {
            this.contentRange = contentRange;
        }

        @Override
        @Transient
        public final Builder contentRange(String contentRange) {
            this.contentRange = contentRange;
            return this;
        }

        public final Long getContentLength() {
            return contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        @Transient
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        @Transient
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        @Transient
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        @Transient
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        @Override
        @Transient
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public GetObjectResponse build() {
            return new GetObjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
