/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediastoredata.DefaultMediaStoreDataAsyncClient;
import software.amazon.awssdk.services.mediastoredata.DefaultMediaStoreDataBaseClientBuilder;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataAsyncClient;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataAsyncClientBuilder;
import software.amazon.awssdk.services.mediastoredata.MediaStoreDataServiceClientConfiguration;
import software.amazon.awssdk.services.mediastoredata.endpoints.MediaStoreDataEndpointProvider;

@SdkInternalApi
final class DefaultMediaStoreDataAsyncClientBuilder
extends DefaultMediaStoreDataBaseClientBuilder<MediaStoreDataAsyncClientBuilder, MediaStoreDataAsyncClient>
implements MediaStoreDataAsyncClientBuilder {
    DefaultMediaStoreDataAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaStoreDataAsyncClientBuilder endpointProvider(MediaStoreDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaStoreDataAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaStoreDataAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MediaStoreDataServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaStoreDataAsyncClient client = new DefaultMediaStoreDataAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaStoreDataServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaStoreDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

