/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediastoredata.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediastoredata.model.MediaStoreDataResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeObjectResponse
extends MediaStoreDataResponse
implements ToCopyableBuilder<Builder, DescribeObjectResponse> {
    private static final SdkField<String> E_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ETag").getter(DescribeObjectResponse.getter(DescribeObjectResponse::eTag)).setter(DescribeObjectResponse.setter(Builder::eTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContentType").getter(DescribeObjectResponse.getter(DescribeObjectResponse::contentType)).setter(DescribeObjectResponse.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ContentLength").getter(DescribeObjectResponse.getter(DescribeObjectResponse::contentLength)).setter(DescribeObjectResponse.setter(Builder::contentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Length").build()}).build();
    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CacheControl").getter(DescribeObjectResponse.getter(DescribeObjectResponse::cacheControl)).setter(DescribeObjectResponse.setter(Builder::cacheControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Cache-Control").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(DescribeObjectResponse.getter(DescribeObjectResponse::lastModified)).setter(DescribeObjectResponse.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Last-Modified").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E_TAG_FIELD, CONTENT_TYPE_FIELD, CONTENT_LENGTH_FIELD, CACHE_CONTROL_FIELD, LAST_MODIFIED_FIELD));
    private final String eTag;
    private final String contentType;
    private final Long contentLength;
    private final String cacheControl;
    private final Instant lastModified;

    private DescribeObjectResponse(BuilderImpl builder) {
        super(builder);
        this.eTag = builder.eTag;
        this.contentType = builder.contentType;
        this.contentLength = builder.contentLength;
        this.cacheControl = builder.cacheControl;
        this.lastModified = builder.lastModified;
    }

    public final String eTag() {
        return this.eTag;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final Long contentLength() {
        return this.contentLength;
    }

    public final String cacheControl() {
        return this.cacheControl;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectResponse)) {
            return false;
        }
        DescribeObjectResponse other = (DescribeObjectResponse)((Object)obj);
        return Objects.equals(this.eTag(), other.eTag()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.contentLength(), other.contentLength()) && Objects.equals(this.cacheControl(), other.cacheControl()) && Objects.equals(this.lastModified(), other.lastModified());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeObjectResponse").add("ETag", (Object)this.eTag()).add("ContentType", (Object)this.contentType()).add("ContentLength", (Object)this.contentLength()).add("CacheControl", (Object)this.cacheControl()).add("LastModified", (Object)this.lastModified()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ETag": {
                return Optional.ofNullable(clazz.cast(this.eTag()));
            }
            case "ContentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "ContentLength": {
                return Optional.ofNullable(clazz.cast(this.contentLength()));
            }
            case "CacheControl": {
                return Optional.ofNullable(clazz.cast(this.cacheControl()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeObjectResponse, T> g) {
        return obj -> g.apply((DescribeObjectResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaStoreDataResponse.BuilderImpl
    implements Builder {
        private String eTag;
        private String contentType;
        private Long contentLength;
        private String cacheControl;
        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectResponse model) {
            super(model);
            this.eTag(model.eTag);
            this.contentType(model.contentType);
            this.contentLength(model.contentLength);
            this.cacheControl(model.cacheControl);
            this.lastModified(model.lastModified);
        }

        public final String getETag() {
            return this.eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Long getContentLength() {
            return this.contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final String getCacheControl() {
            return this.cacheControl;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public DescribeObjectResponse build() {
            return new DescribeObjectResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaStoreDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeObjectResponse> {
        public Builder eTag(String var1);

        public Builder contentType(String var1);

        public Builder contentLength(Long var1);

        public Builder cacheControl(String var1);

        public Builder lastModified(Instant var1);
    }
}

