/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediastoredata.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeObjectResponse extends MediaStoreDataResponse implements
        ToCopyableBuilder<DescribeObjectResponse.Builder, DescribeObjectResponse> {
    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(DescribeObjectResponse::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("ETag").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentType").getter(getter(DescribeObjectResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ContentLength").getter(getter(DescribeObjectResponse::contentLength))
            .setter(setter(Builder::contentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Length").build()).build();

    private static final SdkField<String> CACHE_CONTROL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CacheControl").getter(getter(DescribeObjectResponse::cacheControl))
            .setter(setter(Builder::cacheControl))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Cache-Control").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModified").getter(getter(DescribeObjectResponse::lastModified))
            .setter(setter(Builder::lastModified))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Last-Modified").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(E_TAG_FIELD,
            CONTENT_TYPE_FIELD, CONTENT_LENGTH_FIELD, CACHE_CONTROL_FIELD, LAST_MODIFIED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String eTag;

    private final String contentType;

    private final Long contentLength;

    private final String cacheControl;

    private final Instant lastModified;

    private DescribeObjectResponse(BuilderImpl builder) {
        super(builder);
        this.eTag = builder.eTag;
        this.contentType = builder.contentType;
        this.contentLength = builder.contentLength;
        this.cacheControl = builder.cacheControl;
        this.lastModified = builder.lastModified;
    }

    /**
     * <p>
     * The ETag that represents a unique instance of the object.
     * </p>
     * 
     * @return The ETag that represents a unique instance of the object.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * The content type of the object.
     * </p>
     * 
     * @return The content type of the object.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * The length of the object in bytes.
     * </p>
     * 
     * @return The length of the object in bytes.
     */
    public final Long contentLength() {
        return contentLength;
    }

    /**
     * <p>
     * An optional <code>CacheControl</code> header that allows the caller to control the object's cache behavior.
     * Headers can be passed in as specified in the HTTP at <a
     * href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
     * >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.
     * </p>
     * <p>
     * Headers with a custom user-defined value are also accepted.
     * </p>
     * 
     * @return An optional <code>CacheControl</code> header that allows the caller to control the object's cache
     *         behavior. Headers can be passed in as specified in the HTTP at <a
     *         href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
     *         >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
     *         <p>
     *         Headers with a custom user-defined value are also accepted.
     */
    public final String cacheControl() {
        return cacheControl;
    }

    /**
     * <p>
     * The date and time that the object was last modified.
     * </p>
     * 
     * @return The date and time that the object was last modified.
     */
    public final Instant lastModified() {
        return lastModified;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(cacheControl());
        hashCode = 31 * hashCode + Objects.hashCode(lastModified());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeObjectResponse)) {
            return false;
        }
        DescribeObjectResponse other = (DescribeObjectResponse) obj;
        return Objects.equals(eTag(), other.eTag()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(contentLength(), other.contentLength()) && Objects.equals(cacheControl(), other.cacheControl())
                && Objects.equals(lastModified(), other.lastModified());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeObjectResponse").add("ETag", eTag()).add("ContentType", contentType())
                .add("ContentLength", contentLength()).add("CacheControl", cacheControl()).add("LastModified", lastModified())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "ContentLength":
            return Optional.ofNullable(clazz.cast(contentLength()));
        case "CacheControl":
            return Optional.ofNullable(clazz.cast(cacheControl()));
        case "LastModified":
            return Optional.ofNullable(clazz.cast(lastModified()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ETag", E_TAG_FIELD);
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("Content-Length", CONTENT_LENGTH_FIELD);
        map.put("Cache-Control", CACHE_CONTROL_FIELD);
        map.put("Last-Modified", LAST_MODIFIED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeObjectResponse, T> g) {
        return obj -> g.apply((DescribeObjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MediaStoreDataResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeObjectResponse> {
        /**
         * <p>
         * The ETag that represents a unique instance of the object.
         * </p>
         * 
         * @param eTag
         *        The ETag that represents a unique instance of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * The content type of the object.
         * </p>
         * 
         * @param contentType
         *        The content type of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The length of the object in bytes.
         * </p>
         * 
         * @param contentLength
         *        The length of the object in bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLength(Long contentLength);

        /**
         * <p>
         * An optional <code>CacheControl</code> header that allows the caller to control the object's cache behavior.
         * Headers can be passed in as specified in the HTTP at <a
         * href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
         * >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.
         * </p>
         * <p>
         * Headers with a custom user-defined value are also accepted.
         * </p>
         * 
         * @param cacheControl
         *        An optional <code>CacheControl</code> header that allows the caller to control the object's cache
         *        behavior. Headers can be passed in as specified in the HTTP at <a
         *        href="https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9"
         *        >https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9</a>.</p>
         *        <p>
         *        Headers with a custom user-defined value are also accepted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheControl(String cacheControl);

        /**
         * <p>
         * The date and time that the object was last modified.
         * </p>
         * 
         * @param lastModified
         *        The date and time that the object was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModified(Instant lastModified);
    }

    static final class BuilderImpl extends MediaStoreDataResponse.BuilderImpl implements Builder {
        private String eTag;

        private String contentType;

        private Long contentLength;

        private String cacheControl;

        private Instant lastModified;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeObjectResponse model) {
            super(model);
            eTag(model.eTag);
            contentType(model.contentType);
            contentLength(model.contentLength);
            cacheControl(model.cacheControl);
            lastModified(model.lastModified);
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final Long getContentLength() {
            return contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final String getCacheControl() {
            return cacheControl;
        }

        public final void setCacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
        }

        @Override
        public final Builder cacheControl(String cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public final Instant getLastModified() {
            return lastModified;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public DescribeObjectResponse build() {
            return new DescribeObjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
