/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for DASH PUT operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashConfigurationForPut implements SdkPojo, Serializable,
        ToCopyableBuilder<DashConfigurationForPut.Builder, DashConfigurationForPut> {
    private static final SdkField<String> MPD_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashConfigurationForPut::mpdLocation)).setter(setter(Builder::mpdLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MpdLocation").build()).build();

    private static final SdkField<String> ORIGIN_MANIFEST_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DashConfigurationForPut::originManifestTypeAsString)).setter(setter(Builder::originManifestType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginManifestType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MPD_LOCATION_FIELD,
            ORIGIN_MANIFEST_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mpdLocation;

    private final String originManifestType;

    private DashConfigurationForPut(BuilderImpl builder) {
        this.mpdLocation = builder.mpdLocation;
        this.originManifestType = builder.originManifestType;
    }

    /**
     * <p>
     * The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor populates
     * the Location tag with the URL for manifest update requests, to be used by players that don't support sticky
     * redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor manifests, and you are
     * either using client-side reporting or your players support sticky HTTP redirects. Valid values are DISABLED and
     * EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is the default value.
     * </p>
     * 
     * @return The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor
     *         populates the Location tag with the URL for manifest update requests, to be used by players that don't
     *         support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor
     *         manifests, and you are either using client-side reporting or your players support sticky HTTP redirects.
     *         Valid values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and
     *         is the default value.
     */
    public String mpdLocation() {
        return mpdLocation;
    }

    /**
     * <p>
     * The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests
     * or single-period manifests. If your origin server produces single-period manifests, set this to SINGLE_PERIOD.
     * The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originManifestType} will return {@link OriginManifestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #originManifestTypeAsString}.
     * </p>
     * 
     * @return The setting that controls whether MediaTailor handles manifests from the origin server as multi-period
     *         manifests or single-period manifests. If your origin server produces single-period manifests, set this to
     *         SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set
     *         it to MULTI_PERIOD.
     * @see OriginManifestType
     */
    public OriginManifestType originManifestType() {
        return OriginManifestType.fromValue(originManifestType);
    }

    /**
     * <p>
     * The setting that controls whether MediaTailor handles manifests from the origin server as multi-period manifests
     * or single-period manifests. If your origin server produces single-period manifests, set this to SINGLE_PERIOD.
     * The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it to MULTI_PERIOD.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originManifestType} will return {@link OriginManifestType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #originManifestTypeAsString}.
     * </p>
     * 
     * @return The setting that controls whether MediaTailor handles manifests from the origin server as multi-period
     *         manifests or single-period manifests. If your origin server produces single-period manifests, set this to
     *         SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set
     *         it to MULTI_PERIOD.
     * @see OriginManifestType
     */
    public String originManifestTypeAsString() {
        return originManifestType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mpdLocation());
        hashCode = 31 * hashCode + Objects.hashCode(originManifestTypeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashConfigurationForPut)) {
            return false;
        }
        DashConfigurationForPut other = (DashConfigurationForPut) obj;
        return Objects.equals(mpdLocation(), other.mpdLocation())
                && Objects.equals(originManifestTypeAsString(), other.originManifestTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DashConfigurationForPut").add("MpdLocation", mpdLocation())
                .add("OriginManifestType", originManifestTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MpdLocation":
            return Optional.ofNullable(clazz.cast(mpdLocation()));
        case "OriginManifestType":
            return Optional.ofNullable(clazz.cast(originManifestTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashConfigurationForPut, T> g) {
        return obj -> g.apply((DashConfigurationForPut) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashConfigurationForPut> {
        /**
         * <p>
         * The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor
         * populates the Location tag with the URL for manifest update requests, to be used by players that don't
         * support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor
         * manifests, and you are either using client-side reporting or your players support sticky HTTP redirects.
         * Valid values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of the tag and is
         * the default value.
         * </p>
         * 
         * @param mpdLocation
         *        The setting that controls whether MediaTailor includes the Location tag in DASH manifests. MediaTailor
         *        populates the Location tag with the URL for manifest update requests, to be used by players that don't
         *        support sticky redirects. Disable this if you have CDN routing rules set up for accessing MediaTailor
         *        manifests, and you are either using client-side reporting or your players support sticky HTTP
         *        redirects. Valid values are DISABLED and EMT_DEFAULT. The EMT_DEFAULT setting enables the inclusion of
         *        the tag and is the default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mpdLocation(String mpdLocation);

        /**
         * <p>
         * The setting that controls whether MediaTailor handles manifests from the origin server as multi-period
         * manifests or single-period manifests. If your origin server produces single-period manifests, set this to
         * SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it
         * to MULTI_PERIOD.
         * </p>
         * 
         * @param originManifestType
         *        The setting that controls whether MediaTailor handles manifests from the origin server as multi-period
         *        manifests or single-period manifests. If your origin server produces single-period manifests, set this
         *        to SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting
         *        or set it to MULTI_PERIOD.
         * @see OriginManifestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginManifestType
         */
        Builder originManifestType(String originManifestType);

        /**
         * <p>
         * The setting that controls whether MediaTailor handles manifests from the origin server as multi-period
         * manifests or single-period manifests. If your origin server produces single-period manifests, set this to
         * SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting or set it
         * to MULTI_PERIOD.
         * </p>
         * 
         * @param originManifestType
         *        The setting that controls whether MediaTailor handles manifests from the origin server as multi-period
         *        manifests or single-period manifests. If your origin server produces single-period manifests, set this
         *        to SINGLE_PERIOD. The default setting is MULTI_PERIOD. For multi-period manifests, omit this setting
         *        or set it to MULTI_PERIOD.
         * @see OriginManifestType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginManifestType
         */
        Builder originManifestType(OriginManifestType originManifestType);
    }

    static final class BuilderImpl implements Builder {
        private String mpdLocation;

        private String originManifestType;

        private BuilderImpl() {
        }

        private BuilderImpl(DashConfigurationForPut model) {
            mpdLocation(model.mpdLocation);
            originManifestType(model.originManifestType);
        }

        public final String getMpdLocation() {
            return mpdLocation;
        }

        @Override
        public final Builder mpdLocation(String mpdLocation) {
            this.mpdLocation = mpdLocation;
            return this;
        }

        public final void setMpdLocation(String mpdLocation) {
            this.mpdLocation = mpdLocation;
        }

        public final String getOriginManifestTypeAsString() {
            return originManifestType;
        }

        @Override
        public final Builder originManifestType(String originManifestType) {
            this.originManifestType = originManifestType;
            return this;
        }

        @Override
        public final Builder originManifestType(OriginManifestType originManifestType) {
            this.originManifestType(originManifestType == null ? null : originManifestType.toString());
            return this;
        }

        public final void setOriginManifestType(String originManifestType) {
            this.originManifestType = originManifestType;
        }

        @Override
        public DashConfigurationForPut build() {
            return new DashConfigurationForPut(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
