/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for Avail Suppression. Ad suppression can be used to turn off ad personalization in a long
 * manifest, or if a viewer joins mid-break.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AvailSuppression implements SdkPojo, Serializable,
        ToCopyableBuilder<AvailSuppression.Builder, AvailSuppression> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AvailSuppression::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AvailSuppression::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final String value;

    private AvailSuppression(BuilderImpl builder) {
        this.mode = builder.mode;
        this.value = builder.value;
    }

    /**
     * Sets the mode for avail suppression, also known as ad suppression. By default, ad suppression is off and all ad
     * breaks are filled by MediaTailor with ads or slate.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Sets the mode for avail suppression, also known as ad suppression. By default, ad suppression is off and
     *         all ad breaks are filled by MediaTailor with ads or slate.
     * @see Mode
     */
    public Mode mode() {
        return Mode.fromValue(mode);
    }

    /**
     * Sets the mode for avail suppression, also known as ad suppression. By default, ad suppression is off and all ad
     * breaks are filled by MediaTailor with ads or slate.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link Mode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return Sets the mode for avail suppression, also known as ad suppression. By default, ad suppression is off and
     *         all ad breaks are filled by MediaTailor with ads or slate.
     * @see Mode
     */
    public String modeAsString() {
        return mode;
    }

    /**
     * The avail suppression value is a live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or behind
     * this time in the manifest lookback window.
     * 
     * @return The avail suppression value is a live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on
     *         or behind this time in the manifest lookback window.
     */
    public String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailSuppression)) {
            return false;
        }
        AvailSuppression other = (AvailSuppression) obj;
        return Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AvailSuppression").add("Mode", modeAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailSuppression, T> g) {
        return obj -> g.apply((AvailSuppression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AvailSuppression> {
        /**
         * Sets the mode for avail suppression, also known as ad suppression. By default, ad suppression is off and all
         * ad breaks are filled by MediaTailor with ads or slate.
         * 
         * @param mode
         *        Sets the mode for avail suppression, also known as ad suppression. By default, ad suppression is off
         *        and all ad breaks are filled by MediaTailor with ads or slate.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(String mode);

        /**
         * Sets the mode for avail suppression, also known as ad suppression. By default, ad suppression is off and all
         * ad breaks are filled by MediaTailor with ads or slate.
         * 
         * @param mode
         *        Sets the mode for avail suppression, also known as ad suppression. By default, ad suppression is off
         *        and all ad breaks are filled by MediaTailor with ads or slate.
         * @see Mode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Mode
         */
        Builder mode(Mode mode);

        /**
         * The avail suppression value is a live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks on or
         * behind this time in the manifest lookback window.
         * 
         * @param value
         *        The avail suppression value is a live edge offset time in HH:MM:SS. MediaTailor won't fill ad breaks
         *        on or behind this time in the manifest lookback window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailSuppression model) {
            mode(model.mode);
            value(model.value);
        }

        public final String getMode() {
            return mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(Mode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public AvailSuppression build() {
            return new AvailSuppression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
