/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediatailor.model.AvailSuppression;
import software.amazon.awssdk.services.mediatailor.model.Bumper;
import software.amazon.awssdk.services.mediatailor.model.CdnConfiguration;
import software.amazon.awssdk.services.mediatailor.model.DashConfigurationForPut;
import software.amazon.awssdk.services.mediatailor.model.LivePreRollConfiguration;
import software.amazon.awssdk.services.mediatailor.model.ManifestProcessingRules;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.services.mediatailor.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutPlaybackConfigurationRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, PutPlaybackConfigurationRequest> {
    private static final SdkField<String> AD_DECISION_SERVER_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdDecisionServerUrl").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::adDecisionServerUrl)).setter(PutPlaybackConfigurationRequest.setter(Builder::adDecisionServerUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdDecisionServerUrl").build()}).build();
    private static final SdkField<AvailSuppression> AVAIL_SUPPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AvailSuppression").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::availSuppression)).setter(PutPlaybackConfigurationRequest.setter(Builder::availSuppression)).constructor(AvailSuppression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailSuppression").build()}).build();
    private static final SdkField<Bumper> BUMPER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Bumper").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::bumper)).setter(PutPlaybackConfigurationRequest.setter(Builder::bumper)).constructor(Bumper::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bumper").build()}).build();
    private static final SdkField<CdnConfiguration> CDN_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CdnConfiguration").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::cdnConfiguration)).setter(PutPlaybackConfigurationRequest.setter(Builder::cdnConfiguration)).constructor(CdnConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnConfiguration").build()}).build();
    private static final SdkField<DashConfigurationForPut> DASH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashConfiguration").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::dashConfiguration)).setter(PutPlaybackConfigurationRequest.setter(Builder::dashConfiguration)).constructor(DashConfigurationForPut::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashConfiguration").build()}).build();
    private static final SdkField<LivePreRollConfiguration> LIVE_PRE_ROLL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LivePreRollConfiguration").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::livePreRollConfiguration)).setter(PutPlaybackConfigurationRequest.setter(Builder::livePreRollConfiguration)).constructor(LivePreRollConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LivePreRollConfiguration").build()}).build();
    private static final SdkField<ManifestProcessingRules> MANIFEST_PROCESSING_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManifestProcessingRules").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::manifestProcessingRules)).setter(PutPlaybackConfigurationRequest.setter(Builder::manifestProcessingRules)).constructor(ManifestProcessingRules::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestProcessingRules").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::name)).setter(PutPlaybackConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> PERSONALIZATION_THRESHOLD_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PersonalizationThresholdSeconds").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::personalizationThresholdSeconds)).setter(PutPlaybackConfigurationRequest.setter(Builder::personalizationThresholdSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalizationThresholdSeconds").build()}).build();
    private static final SdkField<String> SLATE_AD_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlateAdUrl").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::slateAdUrl)).setter(PutPlaybackConfigurationRequest.setter(Builder::slateAdUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlateAdUrl").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::tags)).setter(PutPlaybackConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TRANSCODE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TranscodeProfileName").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::transcodeProfileName)).setter(PutPlaybackConfigurationRequest.setter(Builder::transcodeProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscodeProfileName").build()}).build();
    private static final SdkField<String> VIDEO_CONTENT_SOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VideoContentSourceUrl").getter(PutPlaybackConfigurationRequest.getter(PutPlaybackConfigurationRequest::videoContentSourceUrl)).setter(PutPlaybackConfigurationRequest.setter(Builder::videoContentSourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoContentSourceUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_DECISION_SERVER_URL_FIELD, AVAIL_SUPPRESSION_FIELD, BUMPER_FIELD, CDN_CONFIGURATION_FIELD, DASH_CONFIGURATION_FIELD, LIVE_PRE_ROLL_CONFIGURATION_FIELD, MANIFEST_PROCESSING_RULES_FIELD, NAME_FIELD, PERSONALIZATION_THRESHOLD_SECONDS_FIELD, SLATE_AD_URL_FIELD, TAGS_FIELD, TRANSCODE_PROFILE_NAME_FIELD, VIDEO_CONTENT_SOURCE_URL_FIELD));
    private final String adDecisionServerUrl;
    private final AvailSuppression availSuppression;
    private final Bumper bumper;
    private final CdnConfiguration cdnConfiguration;
    private final DashConfigurationForPut dashConfiguration;
    private final LivePreRollConfiguration livePreRollConfiguration;
    private final ManifestProcessingRules manifestProcessingRules;
    private final String name;
    private final Integer personalizationThresholdSeconds;
    private final String slateAdUrl;
    private final Map<String, String> tags;
    private final String transcodeProfileName;
    private final String videoContentSourceUrl;

    private PutPlaybackConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.adDecisionServerUrl = builder.adDecisionServerUrl;
        this.availSuppression = builder.availSuppression;
        this.bumper = builder.bumper;
        this.cdnConfiguration = builder.cdnConfiguration;
        this.dashConfiguration = builder.dashConfiguration;
        this.livePreRollConfiguration = builder.livePreRollConfiguration;
        this.manifestProcessingRules = builder.manifestProcessingRules;
        this.name = builder.name;
        this.personalizationThresholdSeconds = builder.personalizationThresholdSeconds;
        this.slateAdUrl = builder.slateAdUrl;
        this.tags = builder.tags;
        this.transcodeProfileName = builder.transcodeProfileName;
        this.videoContentSourceUrl = builder.videoContentSourceUrl;
    }

    public String adDecisionServerUrl() {
        return this.adDecisionServerUrl;
    }

    public AvailSuppression availSuppression() {
        return this.availSuppression;
    }

    public Bumper bumper() {
        return this.bumper;
    }

    public CdnConfiguration cdnConfiguration() {
        return this.cdnConfiguration;
    }

    public DashConfigurationForPut dashConfiguration() {
        return this.dashConfiguration;
    }

    public LivePreRollConfiguration livePreRollConfiguration() {
        return this.livePreRollConfiguration;
    }

    public ManifestProcessingRules manifestProcessingRules() {
        return this.manifestProcessingRules;
    }

    public String name() {
        return this.name;
    }

    public Integer personalizationThresholdSeconds() {
        return this.personalizationThresholdSeconds;
    }

    public String slateAdUrl() {
        return this.slateAdUrl;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public String transcodeProfileName() {
        return this.transcodeProfileName;
    }

    public String videoContentSourceUrl() {
        return this.videoContentSourceUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.adDecisionServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.availSuppression());
        hashCode = 31 * hashCode + Objects.hashCode(this.bumper());
        hashCode = 31 * hashCode + Objects.hashCode(this.cdnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.livePreRollConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestProcessingRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.personalizationThresholdSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.slateAdUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.transcodeProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoContentSourceUrl());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPlaybackConfigurationRequest)) {
            return false;
        }
        PutPlaybackConfigurationRequest other = (PutPlaybackConfigurationRequest)((Object)obj);
        return Objects.equals(this.adDecisionServerUrl(), other.adDecisionServerUrl()) && Objects.equals(this.availSuppression(), other.availSuppression()) && Objects.equals(this.bumper(), other.bumper()) && Objects.equals(this.cdnConfiguration(), other.cdnConfiguration()) && Objects.equals(this.dashConfiguration(), other.dashConfiguration()) && Objects.equals(this.livePreRollConfiguration(), other.livePreRollConfiguration()) && Objects.equals(this.manifestProcessingRules(), other.manifestProcessingRules()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.personalizationThresholdSeconds(), other.personalizationThresholdSeconds()) && Objects.equals(this.slateAdUrl(), other.slateAdUrl()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.transcodeProfileName(), other.transcodeProfileName()) && Objects.equals(this.videoContentSourceUrl(), other.videoContentSourceUrl());
    }

    public String toString() {
        return ToString.builder((String)"PutPlaybackConfigurationRequest").add("AdDecisionServerUrl", (Object)this.adDecisionServerUrl()).add("AvailSuppression", (Object)this.availSuppression()).add("Bumper", (Object)this.bumper()).add("CdnConfiguration", (Object)this.cdnConfiguration()).add("DashConfiguration", (Object)this.dashConfiguration()).add("LivePreRollConfiguration", (Object)this.livePreRollConfiguration()).add("ManifestProcessingRules", (Object)this.manifestProcessingRules()).add("Name", (Object)this.name()).add("PersonalizationThresholdSeconds", (Object)this.personalizationThresholdSeconds()).add("SlateAdUrl", (Object)this.slateAdUrl()).add("Tags", this.hasTags() ? this.tags() : null).add("TranscodeProfileName", (Object)this.transcodeProfileName()).add("VideoContentSourceUrl", (Object)this.videoContentSourceUrl()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdDecisionServerUrl": {
                return Optional.ofNullable(clazz.cast(this.adDecisionServerUrl()));
            }
            case "AvailSuppression": {
                return Optional.ofNullable(clazz.cast(this.availSuppression()));
            }
            case "Bumper": {
                return Optional.ofNullable(clazz.cast(this.bumper()));
            }
            case "CdnConfiguration": {
                return Optional.ofNullable(clazz.cast(this.cdnConfiguration()));
            }
            case "DashConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dashConfiguration()));
            }
            case "LivePreRollConfiguration": {
                return Optional.ofNullable(clazz.cast(this.livePreRollConfiguration()));
            }
            case "ManifestProcessingRules": {
                return Optional.ofNullable(clazz.cast(this.manifestProcessingRules()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PersonalizationThresholdSeconds": {
                return Optional.ofNullable(clazz.cast(this.personalizationThresholdSeconds()));
            }
            case "SlateAdUrl": {
                return Optional.ofNullable(clazz.cast(this.slateAdUrl()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "TranscodeProfileName": {
                return Optional.ofNullable(clazz.cast(this.transcodeProfileName()));
            }
            case "VideoContentSourceUrl": {
                return Optional.ofNullable(clazz.cast(this.videoContentSourceUrl()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPlaybackConfigurationRequest, T> g) {
        return obj -> g.apply((PutPlaybackConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private String adDecisionServerUrl;
        private AvailSuppression availSuppression;
        private Bumper bumper;
        private CdnConfiguration cdnConfiguration;
        private DashConfigurationForPut dashConfiguration;
        private LivePreRollConfiguration livePreRollConfiguration;
        private ManifestProcessingRules manifestProcessingRules;
        private String name;
        private Integer personalizationThresholdSeconds;
        private String slateAdUrl;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String transcodeProfileName;
        private String videoContentSourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPlaybackConfigurationRequest model) {
            super(model);
            this.adDecisionServerUrl(model.adDecisionServerUrl);
            this.availSuppression(model.availSuppression);
            this.bumper(model.bumper);
            this.cdnConfiguration(model.cdnConfiguration);
            this.dashConfiguration(model.dashConfiguration);
            this.livePreRollConfiguration(model.livePreRollConfiguration);
            this.manifestProcessingRules(model.manifestProcessingRules);
            this.name(model.name);
            this.personalizationThresholdSeconds(model.personalizationThresholdSeconds);
            this.slateAdUrl(model.slateAdUrl);
            this.tags(model.tags);
            this.transcodeProfileName(model.transcodeProfileName);
            this.videoContentSourceUrl(model.videoContentSourceUrl);
        }

        public final String getAdDecisionServerUrl() {
            return this.adDecisionServerUrl;
        }

        @Override
        public final Builder adDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
            return this;
        }

        public final void setAdDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
        }

        public final AvailSuppression.Builder getAvailSuppression() {
            return this.availSuppression != null ? this.availSuppression.toBuilder() : null;
        }

        @Override
        public final Builder availSuppression(AvailSuppression availSuppression) {
            this.availSuppression = availSuppression;
            return this;
        }

        public final void setAvailSuppression(AvailSuppression.BuilderImpl availSuppression) {
            this.availSuppression = availSuppression != null ? availSuppression.build() : null;
        }

        public final Bumper.Builder getBumper() {
            return this.bumper != null ? this.bumper.toBuilder() : null;
        }

        @Override
        public final Builder bumper(Bumper bumper) {
            this.bumper = bumper;
            return this;
        }

        public final void setBumper(Bumper.BuilderImpl bumper) {
            this.bumper = bumper != null ? bumper.build() : null;
        }

        public final CdnConfiguration.Builder getCdnConfiguration() {
            return this.cdnConfiguration != null ? this.cdnConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cdnConfiguration(CdnConfiguration cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration;
            return this;
        }

        public final void setCdnConfiguration(CdnConfiguration.BuilderImpl cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration != null ? cdnConfiguration.build() : null;
        }

        public final DashConfigurationForPut.Builder getDashConfiguration() {
            return this.dashConfiguration != null ? this.dashConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder dashConfiguration(DashConfigurationForPut dashConfiguration) {
            this.dashConfiguration = dashConfiguration;
            return this;
        }

        public final void setDashConfiguration(DashConfigurationForPut.BuilderImpl dashConfiguration) {
            this.dashConfiguration = dashConfiguration != null ? dashConfiguration.build() : null;
        }

        public final LivePreRollConfiguration.Builder getLivePreRollConfiguration() {
            return this.livePreRollConfiguration != null ? this.livePreRollConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder livePreRollConfiguration(LivePreRollConfiguration livePreRollConfiguration) {
            this.livePreRollConfiguration = livePreRollConfiguration;
            return this;
        }

        public final void setLivePreRollConfiguration(LivePreRollConfiguration.BuilderImpl livePreRollConfiguration) {
            this.livePreRollConfiguration = livePreRollConfiguration != null ? livePreRollConfiguration.build() : null;
        }

        public final ManifestProcessingRules.Builder getManifestProcessingRules() {
            return this.manifestProcessingRules != null ? this.manifestProcessingRules.toBuilder() : null;
        }

        @Override
        public final Builder manifestProcessingRules(ManifestProcessingRules manifestProcessingRules) {
            this.manifestProcessingRules = manifestProcessingRules;
            return this;
        }

        public final void setManifestProcessingRules(ManifestProcessingRules.BuilderImpl manifestProcessingRules) {
            this.manifestProcessingRules = manifestProcessingRules != null ? manifestProcessingRules.build() : null;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPersonalizationThresholdSeconds() {
            return this.personalizationThresholdSeconds;
        }

        @Override
        public final Builder personalizationThresholdSeconds(Integer personalizationThresholdSeconds) {
            this.personalizationThresholdSeconds = personalizationThresholdSeconds;
            return this;
        }

        public final void setPersonalizationThresholdSeconds(Integer personalizationThresholdSeconds) {
            this.personalizationThresholdSeconds = personalizationThresholdSeconds;
        }

        public final String getSlateAdUrl() {
            return this.slateAdUrl;
        }

        @Override
        public final Builder slateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
            return this;
        }

        public final void setSlateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final String getTranscodeProfileName() {
            return this.transcodeProfileName;
        }

        @Override
        public final Builder transcodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
            return this;
        }

        public final void setTranscodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
        }

        public final String getVideoContentSourceUrl() {
            return this.videoContentSourceUrl;
        }

        @Override
        public final Builder videoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
            return this;
        }

        public final void setVideoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutPlaybackConfigurationRequest build() {
            return new PutPlaybackConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutPlaybackConfigurationRequest> {
        public Builder adDecisionServerUrl(String var1);

        public Builder availSuppression(AvailSuppression var1);

        default public Builder availSuppression(Consumer<AvailSuppression.Builder> availSuppression) {
            return this.availSuppression((AvailSuppression)((AvailSuppression.Builder)AvailSuppression.builder().applyMutation(availSuppression)).build());
        }

        public Builder bumper(Bumper var1);

        default public Builder bumper(Consumer<Bumper.Builder> bumper) {
            return this.bumper((Bumper)((Bumper.Builder)Bumper.builder().applyMutation(bumper)).build());
        }

        public Builder cdnConfiguration(CdnConfiguration var1);

        default public Builder cdnConfiguration(Consumer<CdnConfiguration.Builder> cdnConfiguration) {
            return this.cdnConfiguration((CdnConfiguration)((CdnConfiguration.Builder)CdnConfiguration.builder().applyMutation(cdnConfiguration)).build());
        }

        public Builder dashConfiguration(DashConfigurationForPut var1);

        default public Builder dashConfiguration(Consumer<DashConfigurationForPut.Builder> dashConfiguration) {
            return this.dashConfiguration((DashConfigurationForPut)((DashConfigurationForPut.Builder)DashConfigurationForPut.builder().applyMutation(dashConfiguration)).build());
        }

        public Builder livePreRollConfiguration(LivePreRollConfiguration var1);

        default public Builder livePreRollConfiguration(Consumer<LivePreRollConfiguration.Builder> livePreRollConfiguration) {
            return this.livePreRollConfiguration((LivePreRollConfiguration)((LivePreRollConfiguration.Builder)LivePreRollConfiguration.builder().applyMutation(livePreRollConfiguration)).build());
        }

        public Builder manifestProcessingRules(ManifestProcessingRules var1);

        default public Builder manifestProcessingRules(Consumer<ManifestProcessingRules.Builder> manifestProcessingRules) {
            return this.manifestProcessingRules((ManifestProcessingRules)((ManifestProcessingRules.Builder)ManifestProcessingRules.builder().applyMutation(manifestProcessingRules)).build());
        }

        public Builder name(String var1);

        public Builder personalizationThresholdSeconds(Integer var1);

        public Builder slateAdUrl(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder transcodeProfileName(String var1);

        public Builder videoContentSourceUrl(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

