/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeProgramResponse extends MediaTailorResponse implements
        ToCopyableBuilder<DescribeProgramResponse.Builder, DescribeProgramResponse> {
    private static final SdkField<List<AdBreak>> AD_BREAKS_FIELD = SdkField
            .<List<AdBreak>> builder(MarshallingType.LIST)
            .memberName("AdBreaks")
            .getter(getter(DescribeProgramResponse::adBreaks))
            .setter(setter(Builder::adBreaks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreaks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdBreak> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdBreak::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DescribeProgramResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(DescribeProgramResponse::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(DescribeProgramResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(DescribeProgramResponse::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramName").build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(DescribeProgramResponse::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(DescribeProgramResponse::vodSourceName))
            .setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAKS_FIELD, ARN_FIELD,
            CHANNEL_NAME_FIELD, CREATION_TIME_FIELD, PROGRAM_NAME_FIELD, SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));

    private final List<AdBreak> adBreaks;

    private final String arn;

    private final String channelName;

    private final Instant creationTime;

    private final String programName;

    private final String sourceLocationName;

    private final String vodSourceName;

    private DescribeProgramResponse(BuilderImpl builder) {
        super(builder);
        this.adBreaks = builder.adBreaks;
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.creationTime = builder.creationTime;
        this.programName = builder.programName;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    /**
     * Returns true if the AdBreaks property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAdBreaks() {
        return adBreaks != null && !(adBreaks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ad break configuration settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdBreaks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ad break configuration settings.
     */
    public final List<AdBreak> adBreaks() {
        return adBreaks;
    }

    /**
     * <p>
     * The ARN of the program.
     * </p>
     * 
     * @return The ARN of the program.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the channel that the program belongs to.
     * </p>
     * 
     * @return The name of the channel that the program belongs to.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The timestamp of when the program was created.
     * </p>
     * 
     * @return The timestamp of when the program was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name of the program.
     * </p>
     * 
     * @return The name of the program.
     */
    public final String programName() {
        return programName;
    }

    /**
     * <p>
     * The source location name.
     * </p>
     * 
     * @return The source location name.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * <p>
     * The name that's used to refer to a VOD source.
     * </p>
     * 
     * @return The name that's used to refer to a VOD source.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdBreaks() ? adBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeProgramResponse)) {
            return false;
        }
        DescribeProgramResponse other = (DescribeProgramResponse) obj;
        return hasAdBreaks() == other.hasAdBreaks() && Objects.equals(adBreaks(), other.adBreaks())
                && Objects.equals(arn(), other.arn()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(programName(), other.programName())
                && Objects.equals(sourceLocationName(), other.sourceLocationName())
                && Objects.equals(vodSourceName(), other.vodSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeProgramResponse").add("AdBreaks", hasAdBreaks() ? adBreaks() : null).add("Arn", arn())
                .add("ChannelName", channelName()).add("CreationTime", creationTime()).add("ProgramName", programName())
                .add("SourceLocationName", sourceLocationName()).add("VodSourceName", vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdBreaks":
            return Optional.ofNullable(clazz.cast(adBreaks()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeProgramResponse, T> g) {
        return obj -> g.apply((DescribeProgramResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeProgramResponse> {
        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * 
         * @param adBreaks
         *        The ad break configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(Collection<AdBreak> adBreaks);

        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * 
         * @param adBreaks
         *        The ad break configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(AdBreak... adBreaks);

        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdBreak>.Builder} avoiding the need to
         * create one manually via {@link List<AdBreak>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdBreak>.Builder#build()} is called immediately and its
         * result is passed to {@link #adBreaks(List<AdBreak>)}.
         * 
         * @param adBreaks
         *        a consumer that will call methods on {@link List<AdBreak>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adBreaks(List<AdBreak>)
         */
        Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks);

        /**
         * <p>
         * The ARN of the program.
         * </p>
         * 
         * @param arn
         *        The ARN of the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the channel that the program belongs to.
         * </p>
         * 
         * @param channelName
         *        The name of the channel that the program belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The timestamp of when the program was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of when the program was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The name of the program.
         * </p>
         * 
         * @param programName
         *        The name of the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        /**
         * <p>
         * The source location name.
         * </p>
         * 
         * @param sourceLocationName
         *        The source location name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The name that's used to refer to a VOD source.
         * </p>
         * 
         * @param vodSourceName
         *        The name that's used to refer to a VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private List<AdBreak> adBreaks = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private String channelName;

        private Instant creationTime;

        private String programName;

        private String sourceLocationName;

        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeProgramResponse model) {
            super(model);
            adBreaks(model.adBreaks);
            arn(model.arn);
            channelName(model.channelName);
            creationTime(model.creationTime);
            programName(model.programName);
            sourceLocationName(model.sourceLocationName);
            vodSourceName(model.vodSourceName);
        }

        public final Collection<AdBreak.Builder> getAdBreaks() {
            if (adBreaks instanceof SdkAutoConstructList) {
                return null;
            }
            return adBreaks != null ? adBreaks.stream().map(AdBreak::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder adBreaks(Collection<AdBreak> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copy(adBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(AdBreak... adBreaks) {
            adBreaks(Arrays.asList(adBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks) {
            adBreaks(Stream.of(adBreaks).map(c -> AdBreak.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAdBreaks(Collection<AdBreak.BuilderImpl> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copyFromBuilder(adBreaks);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getChannelName() {
            return channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getProgramName() {
            return programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public DescribeProgramResponse build() {
            return new DescribeProgramResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
