/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateVodSourceRequest extends MediaTailorRequest implements
        ToCopyableBuilder<CreateVodSourceRequest.Builder, CreateVodSourceRequest> {
    private static final SdkField<List<HttpPackageConfiguration>> HTTP_PACKAGE_CONFIGURATIONS_FIELD = SdkField
            .<List<HttpPackageConfiguration>> builder(MarshallingType.LIST)
            .memberName("HttpPackageConfigurations")
            .getter(getter(CreateVodSourceRequest::httpPackageConfigurations))
            .setter(setter(Builder::httpPackageConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPackageConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpPackageConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpPackageConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(CreateVodSourceRequest::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceLocationName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateVodSourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(CreateVodSourceRequest::vodSourceName))
            .setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("vodSourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HTTP_PACKAGE_CONFIGURATIONS_FIELD, SOURCE_LOCATION_NAME_FIELD, TAGS_FIELD, VOD_SOURCE_NAME_FIELD));

    private final List<HttpPackageConfiguration> httpPackageConfigurations;

    private final String sourceLocationName;

    private final Map<String, String> tags;

    private final String vodSourceName;

    private CreateVodSourceRequest(BuilderImpl builder) {
        super(builder);
        this.httpPackageConfigurations = builder.httpPackageConfigurations;
        this.sourceLocationName = builder.sourceLocationName;
        this.tags = builder.tags;
        this.vodSourceName = builder.vodSourceName;
    }

    /**
     * Returns true if the HttpPackageConfigurations property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasHttpPackageConfigurations() {
        return httpPackageConfigurations != null && !(httpPackageConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of HTTP package configuration parameters for this VOD source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHttpPackageConfigurations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of HTTP package configuration parameters for this VOD source.
     */
    public final List<HttpPackageConfiguration> httpPackageConfigurations() {
        return httpPackageConfigurations;
    }

    /**
     * <p>
     * The identifier for the source location you are working on.
     * </p>
     * 
     * @return The identifier for the source location you are working on.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the VOD source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags to assign to the VOD source.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The identifier for the VOD source you are working on.
     * </p>
     * 
     * @return The identifier for the VOD source you are working on.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHttpPackageConfigurations() ? httpPackageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVodSourceRequest)) {
            return false;
        }
        CreateVodSourceRequest other = (CreateVodSourceRequest) obj;
        return hasHttpPackageConfigurations() == other.hasHttpPackageConfigurations()
                && Objects.equals(httpPackageConfigurations(), other.httpPackageConfigurations())
                && Objects.equals(sourceLocationName(), other.sourceLocationName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vodSourceName(), other.vodSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateVodSourceRequest")
                .add("HttpPackageConfigurations", hasHttpPackageConfigurations() ? httpPackageConfigurations() : null)
                .add("SourceLocationName", sourceLocationName()).add("Tags", hasTags() ? tags() : null)
                .add("VodSourceName", vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpPackageConfigurations":
            return Optional.ofNullable(clazz.cast(httpPackageConfigurations()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateVodSourceRequest, T> g) {
        return obj -> g.apply((CreateVodSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateVodSourceRequest> {
        /**
         * <p>
         * An array of HTTP package configuration parameters for this VOD source.
         * </p>
         * 
         * @param httpPackageConfigurations
         *        An array of HTTP package configuration parameters for this VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations);

        /**
         * <p>
         * An array of HTTP package configuration parameters for this VOD source.
         * </p>
         * 
         * @param httpPackageConfigurations
         *        An array of HTTP package configuration parameters for this VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPackageConfigurations(HttpPackageConfiguration... httpPackageConfigurations);

        /**
         * <p>
         * An array of HTTP package configuration parameters for this VOD source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<HttpPackageConfiguration>.Builder} avoiding
         * the need to create one manually via {@link List<HttpPackageConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<HttpPackageConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #httpPackageConfigurations(List<HttpPackageConfiguration>)}.
         * 
         * @param httpPackageConfigurations
         *        a consumer that will call methods on {@link List<HttpPackageConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpPackageConfigurations(List<HttpPackageConfiguration>)
         */
        Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder>... httpPackageConfigurations);

        /**
         * <p>
         * The identifier for the source location you are working on.
         * </p>
         * 
         * @param sourceLocationName
         *        The identifier for the source location you are working on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The tags to assign to the VOD source.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The identifier for the VOD source you are working on.
         * </p>
         * 
         * @param vodSourceName
         *        The identifier for the VOD source you are working on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private List<HttpPackageConfiguration> httpPackageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String sourceLocationName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVodSourceRequest model) {
            super(model);
            httpPackageConfigurations(model.httpPackageConfigurations);
            sourceLocationName(model.sourceLocationName);
            tags(model.tags);
            vodSourceName(model.vodSourceName);
        }

        public final List<HttpPackageConfiguration.Builder> getHttpPackageConfigurations() {
            List<HttpPackageConfiguration.Builder> result = HttpPackageConfigurationsCopier
                    .copyToBuilder(this.httpPackageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copy(httpPackageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(HttpPackageConfiguration... httpPackageConfigurations) {
            httpPackageConfigurations(Arrays.asList(httpPackageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder>... httpPackageConfigurations) {
            httpPackageConfigurations(Stream.of(httpPackageConfigurations)
                    .map(c -> HttpPackageConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHttpPackageConfigurations(Collection<HttpPackageConfiguration.BuilderImpl> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copyFromBuilder(httpPackageConfigurations);
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVodSourceRequest build() {
            return new CreateVodSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
