/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSourceLocationsResponse extends MediaTailorResponse implements
        ToCopyableBuilder<ListSourceLocationsResponse.Builder, ListSourceLocationsResponse> {
    private static final SdkField<List<SourceLocation>> ITEMS_FIELD = SdkField
            .<List<SourceLocation>> builder(MarshallingType.LIST)
            .memberName("Items")
            .getter(getter(ListSourceLocationsResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SourceLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(SourceLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSourceLocationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<SourceLocation> items;

    private final String nextToken;

    private ListSourceLocationsResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Items property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of source locations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of source locations.
     */
    public final List<SourceLocation> items() {
        return items;
    }

    /**
     * <p>
     * Pagination token from the list request. Use the token to fetch the next page of results.
     * </p>
     * 
     * @return Pagination token from the list request. Use the token to fetch the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSourceLocationsResponse)) {
            return false;
        }
        ListSourceLocationsResponse other = (ListSourceLocationsResponse) obj;
        return hasItems() == other.hasItems() && Objects.equals(items(), other.items())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSourceLocationsResponse").add("Items", hasItems() ? items() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Items":
            return Optional.ofNullable(clazz.cast(items()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSourceLocationsResponse, T> g) {
        return obj -> g.apply((ListSourceLocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSourceLocationsResponse> {
        /**
         * <p>
         * An array of source locations.
         * </p>
         * 
         * @param items
         *        An array of source locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<SourceLocation> items);

        /**
         * <p>
         * An array of source locations.
         * </p>
         * 
         * @param items
         *        An array of source locations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(SourceLocation... items);

        /**
         * <p>
         * An array of source locations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SourceLocation>.Builder} avoiding the need
         * to create one manually via {@link List<SourceLocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SourceLocation>.Builder#build()} is called immediately and
         * its result is passed to {@link #items(List<SourceLocation>)}.
         * 
         * @param items
         *        a consumer that will call methods on {@link List<SourceLocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(List<SourceLocation>)
         */
        Builder items(Consumer<SourceLocation.Builder>... items);

        /**
         * <p>
         * Pagination token from the list request. Use the token to fetch the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Pagination token from the list request. Use the token to fetch the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private List<SourceLocation> items = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSourceLocationsResponse model) {
            super(model);
            items(model.items);
            nextToken(model.nextToken);
        }

        public final List<SourceLocation.Builder> getItems() {
            List<SourceLocation.Builder> result = ___listOfSourceLocationCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder items(Collection<SourceLocation> items) {
            this.items = ___listOfSourceLocationCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(SourceLocation... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<SourceLocation.Builder>... items) {
            items(Stream.of(items).map(c -> SourceLocation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setItems(Collection<SourceLocation.BuilderImpl> items) {
            this.items = ___listOfSourceLocationCopier.copyFromBuilder(items);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListSourceLocationsResponse build() {
            return new ListSourceLocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
