/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties for a schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleEntry implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleEntry.Builder, ScheduleEntry> {
    private static final SdkField<Long> APPROXIMATE_DURATION_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ApproximateDurationSeconds")
            .getter(getter(ScheduleEntry::approximateDurationSeconds))
            .setter(setter(Builder::approximateDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateDurationSeconds").build())
            .build();

    private static final SdkField<Instant> APPROXIMATE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApproximateStartTime")
            .getter(getter(ScheduleEntry::approximateStartTime))
            .setter(setter(Builder::approximateStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ScheduleEntry::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(ScheduleEntry::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(ScheduleEntry::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramName").build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(ScheduleEntry::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(ScheduleEntry::vodSourceName)).setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROXIMATE_DURATION_SECONDS_FIELD, APPROXIMATE_START_TIME_FIELD, ARN_FIELD, CHANNEL_NAME_FIELD, PROGRAM_NAME_FIELD,
            SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long approximateDurationSeconds;

    private final Instant approximateStartTime;

    private final String arn;

    private final String channelName;

    private final String programName;

    private final String sourceLocationName;

    private final String vodSourceName;

    private ScheduleEntry(BuilderImpl builder) {
        this.approximateDurationSeconds = builder.approximateDurationSeconds;
        this.approximateStartTime = builder.approximateStartTime;
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.programName = builder.programName;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    /**
     * <p>
     * The approximate duration of this program, in seconds.
     * </p>
     * 
     * @return The approximate duration of this program, in seconds.
     */
    public final Long approximateDurationSeconds() {
        return approximateDurationSeconds;
    }

    /**
     * <p>
     * The approximate time that the program will start playing.
     * </p>
     * 
     * @return The approximate time that the program will start playing.
     */
    public final Instant approximateStartTime() {
        return approximateStartTime;
    }

    /**
     * <p>
     * The ARN of the program.
     * </p>
     * 
     * @return The ARN of the program.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the channel that uses this schedule.
     * </p>
     * 
     * @return The name of the channel that uses this schedule.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name of the program.
     * </p>
     * 
     * @return The name of the program.
     */
    public final String programName() {
        return programName;
    }

    /**
     * <p>
     * The name of the source location.
     * </p>
     * 
     * @return The name of the source location.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * <p>
     * The name of the VOD source.
     * </p>
     * 
     * @return The name of the VOD source.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approximateDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(approximateStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleEntry)) {
            return false;
        }
        ScheduleEntry other = (ScheduleEntry) obj;
        return Objects.equals(approximateDurationSeconds(), other.approximateDurationSeconds())
                && Objects.equals(approximateStartTime(), other.approximateStartTime()) && Objects.equals(arn(), other.arn())
                && Objects.equals(channelName(), other.channelName()) && Objects.equals(programName(), other.programName())
                && Objects.equals(sourceLocationName(), other.sourceLocationName())
                && Objects.equals(vodSourceName(), other.vodSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleEntry").add("ApproximateDurationSeconds", approximateDurationSeconds())
                .add("ApproximateStartTime", approximateStartTime()).add("Arn", arn()).add("ChannelName", channelName())
                .add("ProgramName", programName()).add("SourceLocationName", sourceLocationName())
                .add("VodSourceName", vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApproximateDurationSeconds":
            return Optional.ofNullable(clazz.cast(approximateDurationSeconds()));
        case "ApproximateStartTime":
            return Optional.ofNullable(clazz.cast(approximateStartTime()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleEntry, T> g) {
        return obj -> g.apply((ScheduleEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleEntry> {
        /**
         * <p>
         * The approximate duration of this program, in seconds.
         * </p>
         * 
         * @param approximateDurationSeconds
         *        The approximate duration of this program, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateDurationSeconds(Long approximateDurationSeconds);

        /**
         * <p>
         * The approximate time that the program will start playing.
         * </p>
         * 
         * @param approximateStartTime
         *        The approximate time that the program will start playing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateStartTime(Instant approximateStartTime);

        /**
         * <p>
         * The ARN of the program.
         * </p>
         * 
         * @param arn
         *        The ARN of the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the channel that uses this schedule.
         * </p>
         * 
         * @param channelName
         *        The name of the channel that uses this schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name of the program.
         * </p>
         * 
         * @param programName
         *        The name of the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        /**
         * <p>
         * The name of the source location.
         * </p>
         * 
         * @param sourceLocationName
         *        The name of the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The name of the VOD source.
         * </p>
         * 
         * @param vodSourceName
         *        The name of the VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);
    }

    static final class BuilderImpl implements Builder {
        private Long approximateDurationSeconds;

        private Instant approximateStartTime;

        private String arn;

        private String channelName;

        private String programName;

        private String sourceLocationName;

        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleEntry model) {
            approximateDurationSeconds(model.approximateDurationSeconds);
            approximateStartTime(model.approximateStartTime);
            arn(model.arn);
            channelName(model.channelName);
            programName(model.programName);
            sourceLocationName(model.sourceLocationName);
            vodSourceName(model.vodSourceName);
        }

        public final Long getApproximateDurationSeconds() {
            return approximateDurationSeconds;
        }

        @Override
        public final Builder approximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
            return this;
        }

        public final void setApproximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
        }

        public final Instant getApproximateStartTime() {
            return approximateStartTime;
        }

        @Override
        public final Builder approximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
            return this;
        }

        public final void setApproximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getChannelName() {
            return channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final String getProgramName() {
            return programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public ScheduleEntry build() {
            return new ScheduleEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
