/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelResponse extends MediaTailorResponse implements
        ToCopyableBuilder<UpdateChannelResponse.Builder, UpdateChannelResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateChannelResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(UpdateChannelResponse::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> CHANNEL_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelState").getter(getter(UpdateChannelResponse::channelStateAsString))
            .setter(setter(Builder::channelState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelState").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(UpdateChannelResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(UpdateChannelResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<List<ResponseOutputItem>> OUTPUTS_FIELD = SdkField
            .<List<ResponseOutputItem>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(UpdateChannelResponse::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResponseOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResponseOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLAYBACK_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackMode").getter(getter(UpdateChannelResponse::playbackMode)).setter(setter(Builder::playbackMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackMode").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(UpdateChannelResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CHANNEL_NAME_FIELD,
            CHANNEL_STATE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, OUTPUTS_FIELD, PLAYBACK_MODE_FIELD, TAGS_FIELD));

    private final String arn;

    private final String channelName;

    private final String channelState;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final List<ResponseOutputItem> outputs;

    private final String playbackMode;

    private final Map<String, String> tags;

    private UpdateChannelResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.channelState = builder.channelState;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.outputs = builder.outputs;
        this.playbackMode = builder.playbackMode;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the channel.
     * </p>
     * 
     * @return The ARN of the channel.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * Indicates whether the channel is in a running state or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelState} will
     * return {@link ChannelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStateAsString}.
     * </p>
     * 
     * @return Indicates whether the channel is in a running state or not.
     * @see ChannelState
     */
    public final ChannelState channelState() {
        return ChannelState.fromValue(channelState);
    }

    /**
     * <p>
     * Indicates whether the channel is in a running state or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelState} will
     * return {@link ChannelState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStateAsString}.
     * </p>
     * 
     * @return Indicates whether the channel is in a running state or not.
     * @see ChannelState
     */
    public final String channelStateAsString() {
        return channelState;
    }

    /**
     * <p>
     * The timestamp of when the channel was created.
     * </p>
     * 
     * @return The timestamp of when the channel was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The timestamp of when the channel was last modified.
     * </p>
     * 
     * @return The timestamp of when the channel was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns true if the Outputs property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channel's output properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOutputs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The channel's output properties.
     */
    public final List<ResponseOutputItem> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The type of playback for this channel. The only supported value is LOOP.
     * </p>
     * 
     * @return The type of playback for this channel. The only supported value is LOOP.
     */
    public final String playbackMode() {
        return playbackMode;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags assigned to the channel.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(playbackMode());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelResponse)) {
            return false;
        }
        UpdateChannelResponse other = (UpdateChannelResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(channelStateAsString(), other.channelStateAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && hasOutputs() == other.hasOutputs()
                && Objects.equals(outputs(), other.outputs()) && Objects.equals(playbackMode(), other.playbackMode())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelResponse").add("Arn", arn()).add("ChannelName", channelName())
                .add("ChannelState", channelStateAsString()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).add("Outputs", hasOutputs() ? outputs() : null)
                .add("PlaybackMode", playbackMode()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ChannelState":
            return Optional.ofNullable(clazz.cast(channelStateAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "PlaybackMode":
            return Optional.ofNullable(clazz.cast(playbackMode()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelResponse, T> g) {
        return obj -> g.apply((UpdateChannelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChannelResponse> {
        /**
         * <p>
         * The ARN of the channel.
         * </p>
         * 
         * @param arn
         *        The ARN of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param channelName
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * Indicates whether the channel is in a running state or not.
         * </p>
         * 
         * @param channelState
         *        Indicates whether the channel is in a running state or not.
         * @see ChannelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelState
         */
        Builder channelState(String channelState);

        /**
         * <p>
         * Indicates whether the channel is in a running state or not.
         * </p>
         * 
         * @param channelState
         *        Indicates whether the channel is in a running state or not.
         * @see ChannelState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelState
         */
        Builder channelState(ChannelState channelState);

        /**
         * <p>
         * The timestamp of when the channel was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp of when the channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The timestamp of when the channel was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp of when the channel was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * 
         * @param outputs
         *        The channel's output properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<ResponseOutputItem> outputs);

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * 
         * @param outputs
         *        The channel's output properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(ResponseOutputItem... outputs);

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResponseOutputItem>.Builder} avoiding the
         * need to create one manually via {@link List<ResponseOutputItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResponseOutputItem>.Builder#build()} is called immediately
         * and its result is passed to {@link #outputs(List<ResponseOutputItem>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on {@link List<ResponseOutputItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(List<ResponseOutputItem>)
         */
        Builder outputs(Consumer<ResponseOutputItem.Builder>... outputs);

        /**
         * <p>
         * The type of playback for this channel. The only supported value is LOOP.
         * </p>
         * 
         * @param playbackMode
         *        The type of playback for this channel. The only supported value is LOOP.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackMode(String playbackMode);

        /**
         * <p>
         * The tags assigned to the channel.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private String arn;

        private String channelName;

        private String channelState;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private List<ResponseOutputItem> outputs = DefaultSdkAutoConstructList.getInstance();

        private String playbackMode;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelResponse model) {
            super(model);
            arn(model.arn);
            channelName(model.channelName);
            channelState(model.channelState);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            outputs(model.outputs);
            playbackMode(model.playbackMode);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getChannelName() {
            return channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final String getChannelState() {
            return channelState;
        }

        @Override
        public final Builder channelState(String channelState) {
            this.channelState = channelState;
            return this;
        }

        @Override
        public final Builder channelState(ChannelState channelState) {
            this.channelState(channelState == null ? null : channelState.toString());
            return this;
        }

        public final void setChannelState(String channelState) {
            this.channelState = channelState;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final List<ResponseOutputItem.Builder> getOutputs() {
            List<ResponseOutputItem.Builder> result = ResponseOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder outputs(Collection<ResponseOutputItem> outputs) {
            this.outputs = ResponseOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(ResponseOutputItem... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<ResponseOutputItem.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> ResponseOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setOutputs(Collection<ResponseOutputItem.BuilderImpl> outputs) {
            this.outputs = ResponseOutputsCopier.copyFromBuilder(outputs);
        }

        public final String getPlaybackMode() {
            return playbackMode;
        }

        @Override
        public final Builder playbackMode(String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        public final void setPlaybackMode(String playbackMode) {
            this.playbackMode = playbackMode;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public UpdateChannelResponse build() {
            return new UpdateChannelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
