/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSourceLocationRequest extends MediaTailorRequest implements
        ToCopyableBuilder<UpdateSourceLocationRequest.Builder, UpdateSourceLocationRequest> {
    private static final SdkField<AccessConfiguration> ACCESS_CONFIGURATION_FIELD = SdkField
            .<AccessConfiguration> builder(MarshallingType.SDK_POJO).memberName("AccessConfiguration")
            .getter(getter(UpdateSourceLocationRequest::accessConfiguration)).setter(setter(Builder::accessConfiguration))
            .constructor(AccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessConfiguration").build())
            .build();

    private static final SdkField<DefaultSegmentDeliveryConfiguration> DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<DefaultSegmentDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultSegmentDeliveryConfiguration")
            .getter(getter(UpdateSourceLocationRequest::defaultSegmentDeliveryConfiguration))
            .setter(setter(Builder::defaultSegmentDeliveryConfiguration))
            .constructor(DefaultSegmentDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DefaultSegmentDeliveryConfiguration").build()).build();

    private static final SdkField<HttpConfiguration> HTTP_CONFIGURATION_FIELD = SdkField
            .<HttpConfiguration> builder(MarshallingType.SDK_POJO).memberName("HttpConfiguration")
            .getter(getter(UpdateSourceLocationRequest::httpConfiguration)).setter(setter(Builder::httpConfiguration))
            .constructor(HttpConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpConfiguration").build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(UpdateSourceLocationRequest::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceLocationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONFIGURATION_FIELD,
            DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD, HTTP_CONFIGURATION_FIELD, SOURCE_LOCATION_NAME_FIELD));

    private final AccessConfiguration accessConfiguration;

    private final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;

    private final HttpConfiguration httpConfiguration;

    private final String sourceLocationName;

    private UpdateSourceLocationRequest(BuilderImpl builder) {
        super(builder);
        this.accessConfiguration = builder.accessConfiguration;
        this.defaultSegmentDeliveryConfiguration = builder.defaultSegmentDeliveryConfiguration;
        this.httpConfiguration = builder.httpConfiguration;
        this.sourceLocationName = builder.sourceLocationName;
    }

    /**
     * <p>
     * Access configuration parameters. Configures the type of authentication used to access content from your source
     * location.
     * </p>
     * 
     * @return Access configuration parameters. Configures the type of authentication used to access content from your
     *         source location.
     */
    public final AccessConfiguration accessConfiguration() {
        return accessConfiguration;
    }

    /**
     * <p>
     * The optional configuration for the host server that serves segments.
     * </p>
     * 
     * @return The optional configuration for the host server that serves segments.
     */
    public final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration() {
        return defaultSegmentDeliveryConfiguration;
    }

    /**
     * <p>
     * The HTTP configuration for the source location.
     * </p>
     * 
     * @return The HTTP configuration for the source location.
     */
    public final HttpConfiguration httpConfiguration() {
        return httpConfiguration;
    }

    /**
     * <p>
     * The identifier for the source location you are working on.
     * </p>
     * 
     * @return The identifier for the source location you are working on.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSegmentDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(httpConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSourceLocationRequest)) {
            return false;
        }
        UpdateSourceLocationRequest other = (UpdateSourceLocationRequest) obj;
        return Objects.equals(accessConfiguration(), other.accessConfiguration())
                && Objects.equals(defaultSegmentDeliveryConfiguration(), other.defaultSegmentDeliveryConfiguration())
                && Objects.equals(httpConfiguration(), other.httpConfiguration())
                && Objects.equals(sourceLocationName(), other.sourceLocationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSourceLocationRequest").add("AccessConfiguration", accessConfiguration())
                .add("DefaultSegmentDeliveryConfiguration", defaultSegmentDeliveryConfiguration())
                .add("HttpConfiguration", httpConfiguration()).add("SourceLocationName", sourceLocationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessConfiguration":
            return Optional.ofNullable(clazz.cast(accessConfiguration()));
        case "DefaultSegmentDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(defaultSegmentDeliveryConfiguration()));
        case "HttpConfiguration":
            return Optional.ofNullable(clazz.cast(httpConfiguration()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSourceLocationRequest, T> g) {
        return obj -> g.apply((UpdateSourceLocationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSourceLocationRequest> {
        /**
         * <p>
         * Access configuration parameters. Configures the type of authentication used to access content from your
         * source location.
         * </p>
         * 
         * @param accessConfiguration
         *        Access configuration parameters. Configures the type of authentication used to access content from
         *        your source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessConfiguration(AccessConfiguration accessConfiguration);

        /**
         * <p>
         * Access configuration parameters. Configures the type of authentication used to access content from your
         * source location.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessConfiguration.Builder} avoiding the need
         * to create one manually via {@link AccessConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #accessConfiguration(AccessConfiguration)}.
         * 
         * @param accessConfiguration
         *        a consumer that will call methods on {@link AccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessConfiguration(AccessConfiguration)
         */
        default Builder accessConfiguration(Consumer<AccessConfiguration.Builder> accessConfiguration) {
            return accessConfiguration(AccessConfiguration.builder().applyMutation(accessConfiguration).build());
        }

        /**
         * <p>
         * The optional configuration for the host server that serves segments.
         * </p>
         * 
         * @param defaultSegmentDeliveryConfiguration
         *        The optional configuration for the host server that serves segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration);

        /**
         * <p>
         * The optional configuration for the host server that serves segments.
         * </p>
         * This is a convenience that creates an instance of the {@link DefaultSegmentDeliveryConfiguration.Builder}
         * avoiding the need to create one manually via {@link DefaultSegmentDeliveryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefaultSegmentDeliveryConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration)}.
         * 
         * @param defaultSegmentDeliveryConfiguration
         *        a consumer that will call methods on {@link DefaultSegmentDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration)
         */
        default Builder defaultSegmentDeliveryConfiguration(
                Consumer<DefaultSegmentDeliveryConfiguration.Builder> defaultSegmentDeliveryConfiguration) {
            return defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration.builder()
                    .applyMutation(defaultSegmentDeliveryConfiguration).build());
        }

        /**
         * <p>
         * The HTTP configuration for the source location.
         * </p>
         * 
         * @param httpConfiguration
         *        The HTTP configuration for the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpConfiguration(HttpConfiguration httpConfiguration);

        /**
         * <p>
         * The HTTP configuration for the source location.
         * </p>
         * This is a convenience that creates an instance of the {@link HttpConfiguration.Builder} avoiding the need to
         * create one manually via {@link HttpConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #httpConfiguration(HttpConfiguration)}.
         * 
         * @param httpConfiguration
         *        a consumer that will call methods on {@link HttpConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpConfiguration(HttpConfiguration)
         */
        default Builder httpConfiguration(Consumer<HttpConfiguration.Builder> httpConfiguration) {
            return httpConfiguration(HttpConfiguration.builder().applyMutation(httpConfiguration).build());
        }

        /**
         * <p>
         * The identifier for the source location you are working on.
         * </p>
         * 
         * @param sourceLocationName
         *        The identifier for the source location you are working on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private AccessConfiguration accessConfiguration;

        private DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;

        private HttpConfiguration httpConfiguration;

        private String sourceLocationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSourceLocationRequest model) {
            super(model);
            accessConfiguration(model.accessConfiguration);
            defaultSegmentDeliveryConfiguration(model.defaultSegmentDeliveryConfiguration);
            httpConfiguration(model.httpConfiguration);
            sourceLocationName(model.sourceLocationName);
        }

        public final AccessConfiguration.Builder getAccessConfiguration() {
            return accessConfiguration != null ? accessConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder accessConfiguration(AccessConfiguration accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        public final void setAccessConfiguration(AccessConfiguration.BuilderImpl accessConfiguration) {
            this.accessConfiguration = accessConfiguration != null ? accessConfiguration.build() : null;
        }

        public final DefaultSegmentDeliveryConfiguration.Builder getDefaultSegmentDeliveryConfiguration() {
            return defaultSegmentDeliveryConfiguration != null ? defaultSegmentDeliveryConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder defaultSegmentDeliveryConfiguration(
                DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration;
            return this;
        }

        public final void setDefaultSegmentDeliveryConfiguration(
                DefaultSegmentDeliveryConfiguration.BuilderImpl defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration != null ? defaultSegmentDeliveryConfiguration
                    .build() : null;
        }

        public final HttpConfiguration.Builder getHttpConfiguration() {
            return httpConfiguration != null ? httpConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder httpConfiguration(HttpConfiguration httpConfiguration) {
            this.httpConfiguration = httpConfiguration;
            return this;
        }

        public final void setHttpConfiguration(HttpConfiguration.BuilderImpl httpConfiguration) {
            this.httpConfiguration = httpConfiguration != null ? httpConfiguration.build() : null;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSourceLocationRequest build() {
            return new UpdateSourceLocationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
