/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of an
 * ad break. To learn more about bumpers, see <a
 * href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Bumper implements SdkPojo, Serializable, ToCopyableBuilder<Bumper.Builder, Bumper> {
    private static final SdkField<String> END_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("EndUrl")
            .getter(getter(Bumper::endUrl)).setter(setter(Builder::endUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndUrl").build()).build();

    private static final SdkField<String> START_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartUrl").getter(getter(Bumper::startUrl)).setter(setter(Builder::startUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(END_URL_FIELD, START_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String endUrl;

    private final String startUrl;

    private Bumper(BuilderImpl builder) {
        this.endUrl = builder.endUrl;
        this.startUrl = builder.startUrl;
    }

    /**
     * <p>
     * The URL for the end bumper asset.
     * </p>
     * 
     * @return The URL for the end bumper asset.
     */
    public final String endUrl() {
        return endUrl;
    }

    /**
     * <p>
     * The URL for the start bumper asset.
     * </p>
     * 
     * @return The URL for the start bumper asset.
     */
    public final String startUrl() {
        return startUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endUrl());
        hashCode = 31 * hashCode + Objects.hashCode(startUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Bumper)) {
            return false;
        }
        Bumper other = (Bumper) obj;
        return Objects.equals(endUrl(), other.endUrl()) && Objects.equals(startUrl(), other.startUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Bumper").add("EndUrl", endUrl()).add("StartUrl", startUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndUrl":
            return Optional.ofNullable(clazz.cast(endUrl()));
        case "StartUrl":
            return Optional.ofNullable(clazz.cast(startUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Bumper, T> g) {
        return obj -> g.apply((Bumper) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Bumper> {
        /**
         * <p>
         * The URL for the end bumper asset.
         * </p>
         * 
         * @param endUrl
         *        The URL for the end bumper asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endUrl(String endUrl);

        /**
         * <p>
         * The URL for the start bumper asset.
         * </p>
         * 
         * @param startUrl
         *        The URL for the start bumper asset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startUrl(String startUrl);
    }

    static final class BuilderImpl implements Builder {
        private String endUrl;

        private String startUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(Bumper model) {
            endUrl(model.endUrl);
            startUrl(model.startUrl);
        }

        public final String getEndUrl() {
            return endUrl;
        }

        @Override
        public final Builder endUrl(String endUrl) {
            this.endUrl = endUrl;
            return this;
        }

        public final void setEndUrl(String endUrl) {
            this.endUrl = endUrl;
        }

        public final String getStartUrl() {
            return startUrl;
        }

        @Override
        public final Builder startUrl(String startUrl) {
            this.startUrl = startUrl;
            return this;
        }

        public final void setStartUrl(String startUrl) {
            this.startUrl = startUrl;
        }

        @Override
        public Bumper build() {
            return new Bumper(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
