/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSourceLocationResponse extends MediaTailorResponse implements
        ToCopyableBuilder<CreateSourceLocationResponse.Builder, CreateSourceLocationResponse> {
    private static final SdkField<AccessConfiguration> ACCESS_CONFIGURATION_FIELD = SdkField
            .<AccessConfiguration> builder(MarshallingType.SDK_POJO).memberName("AccessConfiguration")
            .getter(getter(CreateSourceLocationResponse::accessConfiguration)).setter(setter(Builder::accessConfiguration))
            .constructor(AccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessConfiguration").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreateSourceLocationResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(CreateSourceLocationResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<DefaultSegmentDeliveryConfiguration> DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD = SdkField
            .<DefaultSegmentDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultSegmentDeliveryConfiguration")
            .getter(getter(CreateSourceLocationResponse::defaultSegmentDeliveryConfiguration))
            .setter(setter(Builder::defaultSegmentDeliveryConfiguration))
            .constructor(DefaultSegmentDeliveryConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DefaultSegmentDeliveryConfiguration").build()).build();

    private static final SdkField<HttpConfiguration> HTTP_CONFIGURATION_FIELD = SdkField
            .<HttpConfiguration> builder(MarshallingType.SDK_POJO).memberName("HttpConfiguration")
            .getter(getter(CreateSourceLocationResponse::httpConfiguration)).setter(setter(Builder::httpConfiguration))
            .constructor(HttpConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpConfiguration").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(CreateSourceLocationResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<List<SegmentDeliveryConfiguration>> SEGMENT_DELIVERY_CONFIGURATIONS_FIELD = SdkField
            .<List<SegmentDeliveryConfiguration>> builder(MarshallingType.LIST)
            .memberName("SegmentDeliveryConfigurations")
            .getter(getter(CreateSourceLocationResponse::segmentDeliveryConfigurations))
            .setter(setter(Builder::segmentDeliveryConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentDeliveryConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SegmentDeliveryConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(SegmentDeliveryConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(CreateSourceLocationResponse::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateSourceLocationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONFIGURATION_FIELD,
            ARN_FIELD, CREATION_TIME_FIELD, DEFAULT_SEGMENT_DELIVERY_CONFIGURATION_FIELD, HTTP_CONFIGURATION_FIELD,
            LAST_MODIFIED_TIME_FIELD, SEGMENT_DELIVERY_CONFIGURATIONS_FIELD, SOURCE_LOCATION_NAME_FIELD, TAGS_FIELD));

    private final AccessConfiguration accessConfiguration;

    private final String arn;

    private final Instant creationTime;

    private final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;

    private final HttpConfiguration httpConfiguration;

    private final Instant lastModifiedTime;

    private final List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations;

    private final String sourceLocationName;

    private final Map<String, String> tags;

    private CreateSourceLocationResponse(BuilderImpl builder) {
        super(builder);
        this.accessConfiguration = builder.accessConfiguration;
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.defaultSegmentDeliveryConfiguration = builder.defaultSegmentDeliveryConfiguration;
        this.httpConfiguration = builder.httpConfiguration;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.segmentDeliveryConfigurations = builder.segmentDeliveryConfigurations;
        this.sourceLocationName = builder.sourceLocationName;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The access configuration for the source location.
     * </p>
     * 
     * @return The access configuration for the source location.
     */
    public final AccessConfiguration accessConfiguration() {
        return accessConfiguration;
    }

    /**
     * <p>
     * The ARN of the source location.
     * </p>
     * 
     * @return The ARN of the source location.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The timestamp that indicates when the source location was created.
     * </p>
     * 
     * @return The timestamp that indicates when the source location was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The default segment delivery configuration settings.
     * </p>
     * 
     * @return The default segment delivery configuration settings.
     */
    public final DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration() {
        return defaultSegmentDeliveryConfiguration;
    }

    /**
     * <p>
     * The HTTP package configuration settings for the source location.
     * </p>
     * 
     * @return The HTTP package configuration settings for the source location.
     */
    public final HttpConfiguration httpConfiguration() {
        return httpConfiguration;
    }

    /**
     * <p>
     * The timestamp that indicates when the source location was last modified.
     * </p>
     * 
     * @return The timestamp that indicates when the source location was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the SegmentDeliveryConfigurations property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSegmentDeliveryConfigurations() {
        return segmentDeliveryConfigurations != null && !(segmentDeliveryConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the SegmentDeliveryConfigurations property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSegmentDeliveryConfigurations} method.
     * </p>
     * 
     * @return The value of the SegmentDeliveryConfigurations property for this object.
     */
    public final List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations() {
        return segmentDeliveryConfigurations;
    }

    /**
     * <p>
     * The name of the source location.
     * </p>
     * 
     * @return The name of the source location.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the source location.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the source location.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSegmentDeliveryConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(httpConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSegmentDeliveryConfigurations() ? segmentDeliveryConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSourceLocationResponse)) {
            return false;
        }
        CreateSourceLocationResponse other = (CreateSourceLocationResponse) obj;
        return Objects.equals(accessConfiguration(), other.accessConfiguration()) && Objects.equals(arn(), other.arn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(defaultSegmentDeliveryConfiguration(), other.defaultSegmentDeliveryConfiguration())
                && Objects.equals(httpConfiguration(), other.httpConfiguration())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && hasSegmentDeliveryConfigurations() == other.hasSegmentDeliveryConfigurations()
                && Objects.equals(segmentDeliveryConfigurations(), other.segmentDeliveryConfigurations())
                && Objects.equals(sourceLocationName(), other.sourceLocationName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateSourceLocationResponse")
                .add("AccessConfiguration", accessConfiguration())
                .add("Arn", arn())
                .add("CreationTime", creationTime())
                .add("DefaultSegmentDeliveryConfiguration", defaultSegmentDeliveryConfiguration())
                .add("HttpConfiguration", httpConfiguration())
                .add("LastModifiedTime", lastModifiedTime())
                .add("SegmentDeliveryConfigurations", hasSegmentDeliveryConfigurations() ? segmentDeliveryConfigurations() : null)
                .add("SourceLocationName", sourceLocationName()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessConfiguration":
            return Optional.ofNullable(clazz.cast(accessConfiguration()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DefaultSegmentDeliveryConfiguration":
            return Optional.ofNullable(clazz.cast(defaultSegmentDeliveryConfiguration()));
        case "HttpConfiguration":
            return Optional.ofNullable(clazz.cast(httpConfiguration()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "SegmentDeliveryConfigurations":
            return Optional.ofNullable(clazz.cast(segmentDeliveryConfigurations()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSourceLocationResponse, T> g) {
        return obj -> g.apply((CreateSourceLocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSourceLocationResponse> {
        /**
         * <p>
         * The access configuration for the source location.
         * </p>
         * 
         * @param accessConfiguration
         *        The access configuration for the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessConfiguration(AccessConfiguration accessConfiguration);

        /**
         * <p>
         * The access configuration for the source location.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccessConfiguration.Builder} avoiding the
         * need to create one manually via {@link AccessConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #accessConfiguration(AccessConfiguration)}.
         * 
         * @param accessConfiguration
         *        a consumer that will call methods on {@link AccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessConfiguration(AccessConfiguration)
         */
        default Builder accessConfiguration(Consumer<AccessConfiguration.Builder> accessConfiguration) {
            return accessConfiguration(AccessConfiguration.builder().applyMutation(accessConfiguration).build());
        }

        /**
         * <p>
         * The ARN of the source location.
         * </p>
         * 
         * @param arn
         *        The ARN of the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The timestamp that indicates when the source location was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp that indicates when the source location was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The default segment delivery configuration settings.
         * </p>
         * 
         * @param defaultSegmentDeliveryConfiguration
         *        The default segment delivery configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration);

        /**
         * <p>
         * The default segment delivery configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DefaultSegmentDeliveryConfiguration.Builder} avoiding the need to create one manually via
         * {@link DefaultSegmentDeliveryConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefaultSegmentDeliveryConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration)}.
         * 
         * @param defaultSegmentDeliveryConfiguration
         *        a consumer that will call methods on {@link DefaultSegmentDeliveryConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration)
         */
        default Builder defaultSegmentDeliveryConfiguration(
                Consumer<DefaultSegmentDeliveryConfiguration.Builder> defaultSegmentDeliveryConfiguration) {
            return defaultSegmentDeliveryConfiguration(DefaultSegmentDeliveryConfiguration.builder()
                    .applyMutation(defaultSegmentDeliveryConfiguration).build());
        }

        /**
         * <p>
         * The HTTP package configuration settings for the source location.
         * </p>
         * 
         * @param httpConfiguration
         *        The HTTP package configuration settings for the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpConfiguration(HttpConfiguration httpConfiguration);

        /**
         * <p>
         * The HTTP package configuration settings for the source location.
         * </p>
         * This is a convenience method that creates an instance of the {@link HttpConfiguration.Builder} avoiding the
         * need to create one manually via {@link HttpConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link HttpConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #httpConfiguration(HttpConfiguration)}.
         * 
         * @param httpConfiguration
         *        a consumer that will call methods on {@link HttpConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpConfiguration(HttpConfiguration)
         */
        default Builder httpConfiguration(Consumer<HttpConfiguration.Builder> httpConfiguration) {
            return httpConfiguration(HttpConfiguration.builder().applyMutation(httpConfiguration).build());
        }

        /**
         * <p>
         * The timestamp that indicates when the source location was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp that indicates when the source location was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the SegmentDeliveryConfigurations property for this object.
         *
         * @param segmentDeliveryConfigurations
         *        The new value for the SegmentDeliveryConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDeliveryConfigurations(Collection<SegmentDeliveryConfiguration> segmentDeliveryConfigurations);

        /**
         * Sets the value of the SegmentDeliveryConfigurations property for this object.
         *
         * @param segmentDeliveryConfigurations
         *        The new value for the SegmentDeliveryConfigurations property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentDeliveryConfigurations(SegmentDeliveryConfiguration... segmentDeliveryConfigurations);

        /**
         * Sets the value of the SegmentDeliveryConfigurations property for this object.
         *
         * This is a convenience method that creates an instance of the {@link List
         * <SegmentDeliveryConfiguration>.Builder} avoiding the need to create one manually via {@link List
         * <SegmentDeliveryConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SegmentDeliveryConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #segmentDeliveryConfigurations(List<SegmentDeliveryConfiguration>)}.
         * 
         * @param segmentDeliveryConfigurations
         *        a consumer that will call methods on {@link List<SegmentDeliveryConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentDeliveryConfigurations(List<SegmentDeliveryConfiguration>)
         */
        Builder segmentDeliveryConfigurations(Consumer<SegmentDeliveryConfiguration.Builder>... segmentDeliveryConfigurations);

        /**
         * <p>
         * The name of the source location.
         * </p>
         * 
         * @param sourceLocationName
         *        The name of the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The tags assigned to the source location.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private AccessConfiguration accessConfiguration;

        private String arn;

        private Instant creationTime;

        private DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration;

        private HttpConfiguration httpConfiguration;

        private Instant lastModifiedTime;

        private List<SegmentDeliveryConfiguration> segmentDeliveryConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String sourceLocationName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSourceLocationResponse model) {
            super(model);
            accessConfiguration(model.accessConfiguration);
            arn(model.arn);
            creationTime(model.creationTime);
            defaultSegmentDeliveryConfiguration(model.defaultSegmentDeliveryConfiguration);
            httpConfiguration(model.httpConfiguration);
            lastModifiedTime(model.lastModifiedTime);
            segmentDeliveryConfigurations(model.segmentDeliveryConfigurations);
            sourceLocationName(model.sourceLocationName);
            tags(model.tags);
        }

        public final AccessConfiguration.Builder getAccessConfiguration() {
            return accessConfiguration != null ? accessConfiguration.toBuilder() : null;
        }

        public final void setAccessConfiguration(AccessConfiguration.BuilderImpl accessConfiguration) {
            this.accessConfiguration = accessConfiguration != null ? accessConfiguration.build() : null;
        }

        @Override
        public final Builder accessConfiguration(AccessConfiguration accessConfiguration) {
            this.accessConfiguration = accessConfiguration;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final DefaultSegmentDeliveryConfiguration.Builder getDefaultSegmentDeliveryConfiguration() {
            return defaultSegmentDeliveryConfiguration != null ? defaultSegmentDeliveryConfiguration.toBuilder() : null;
        }

        public final void setDefaultSegmentDeliveryConfiguration(
                DefaultSegmentDeliveryConfiguration.BuilderImpl defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration != null ? defaultSegmentDeliveryConfiguration
                    .build() : null;
        }

        @Override
        public final Builder defaultSegmentDeliveryConfiguration(
                DefaultSegmentDeliveryConfiguration defaultSegmentDeliveryConfiguration) {
            this.defaultSegmentDeliveryConfiguration = defaultSegmentDeliveryConfiguration;
            return this;
        }

        public final HttpConfiguration.Builder getHttpConfiguration() {
            return httpConfiguration != null ? httpConfiguration.toBuilder() : null;
        }

        public final void setHttpConfiguration(HttpConfiguration.BuilderImpl httpConfiguration) {
            this.httpConfiguration = httpConfiguration != null ? httpConfiguration.build() : null;
        }

        @Override
        public final Builder httpConfiguration(HttpConfiguration httpConfiguration) {
            this.httpConfiguration = httpConfiguration;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final List<SegmentDeliveryConfiguration.Builder> getSegmentDeliveryConfigurations() {
            List<SegmentDeliveryConfiguration.Builder> result = ___listOfSegmentDeliveryConfigurationCopier
                    .copyToBuilder(this.segmentDeliveryConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentDeliveryConfigurations(
                Collection<SegmentDeliveryConfiguration.BuilderImpl> segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations = ___listOfSegmentDeliveryConfigurationCopier
                    .copyFromBuilder(segmentDeliveryConfigurations);
        }

        @Override
        public final Builder segmentDeliveryConfigurations(Collection<SegmentDeliveryConfiguration> segmentDeliveryConfigurations) {
            this.segmentDeliveryConfigurations = ___listOfSegmentDeliveryConfigurationCopier.copy(segmentDeliveryConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentDeliveryConfigurations(SegmentDeliveryConfiguration... segmentDeliveryConfigurations) {
            segmentDeliveryConfigurations(Arrays.asList(segmentDeliveryConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentDeliveryConfigurations(
                Consumer<SegmentDeliveryConfiguration.Builder>... segmentDeliveryConfigurations) {
            segmentDeliveryConfigurations(Stream.of(segmentDeliveryConfigurations)
                    .map(c -> SegmentDeliveryConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        @Override
        public CreateSourceLocationResponse build() {
            return new CreateSourceLocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
