/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SegmentDeliveryConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SegmentDeliveryConfiguration.Builder, SegmentDeliveryConfiguration> {
    private static final SdkField<String> BASE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BaseUrl").getter(getter(SegmentDeliveryConfiguration::baseUrl)).setter(setter(Builder::baseUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseUrl").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SegmentDeliveryConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_URL_FIELD, NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String baseUrl;

    private final String name;

    private SegmentDeliveryConfiguration(BuilderImpl builder) {
        this.baseUrl = builder.baseUrl;
        this.name = builder.name;
    }

    /**
     * Returns the value of the BaseUrl property for this object.
     * 
     * @return The value of the BaseUrl property for this object.
     */
    public final String baseUrl() {
        return baseUrl;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SegmentDeliveryConfiguration)) {
            return false;
        }
        SegmentDeliveryConfiguration other = (SegmentDeliveryConfiguration) obj;
        return Objects.equals(baseUrl(), other.baseUrl()) && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SegmentDeliveryConfiguration").add("BaseUrl", baseUrl()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BaseUrl":
            return Optional.ofNullable(clazz.cast(baseUrl()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SegmentDeliveryConfiguration, T> g) {
        return obj -> g.apply((SegmentDeliveryConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SegmentDeliveryConfiguration> {
        /**
         * Sets the value of the BaseUrl property for this object.
         *
         * @param baseUrl
         *        The new value for the BaseUrl property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseUrl(String baseUrl);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);
    }

    static final class BuilderImpl implements Builder {
        private String baseUrl;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(SegmentDeliveryConfiguration model) {
            baseUrl(model.baseUrl);
            name(model.name);
        }

        public final String getBaseUrl() {
            return baseUrl;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SegmentDeliveryConfiguration build() {
            return new SegmentDeliveryConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
