/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Access configuration parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessConfiguration.Builder, AccessConfiguration> {
    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessType").getter(getter(AccessConfiguration::accessTypeAsString)).setter(setter(Builder::accessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessType").build()).build();

    private static final SdkField<SecretsManagerAccessTokenConfiguration> SECRETS_MANAGER_ACCESS_TOKEN_CONFIGURATION_FIELD = SdkField
            .<SecretsManagerAccessTokenConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SecretsManagerAccessTokenConfiguration")
            .getter(getter(AccessConfiguration::secretsManagerAccessTokenConfiguration))
            .setter(setter(Builder::secretsManagerAccessTokenConfiguration))
            .constructor(SecretsManagerAccessTokenConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SecretsManagerAccessTokenConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_TYPE_FIELD,
            SECRETS_MANAGER_ACCESS_TOKEN_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accessType;

    private final SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration;

    private AccessConfiguration(BuilderImpl builder) {
        this.accessType = builder.accessType;
        this.secretsManagerAccessTokenConfiguration = builder.secretsManagerAccessTokenConfiguration;
    }

    /**
     * <p>
     * The type of authentication used to access content from HttpConfiguration::BaseUrl on your source location.
     * Accepted value: S3_SIGV4.
     * </p>
     * <p>
     * S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source
     * location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to
     * access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the
     * S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.
     * </p>
     * <p>
     * Before you can use S3_SIGV4, you must meet these requirements:
     * </p>
     * <p>
     * • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in
     * IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.
     * </p>
     * <p>
     * • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests
     * referenced by the VodSource packaging configurations.
     * </p>
     * <p>
     * • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your
     * MediaTailor VodSource packaging configurations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link AccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of authentication used to access content from HttpConfiguration::BaseUrl on your source
     *         location. Accepted value: S3_SIGV4.</p>
     *         <p>
     *         S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your
     *         source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4)
     *         authentication to access the bucket where your source content is stored. Your MediaTailor source location
     *         baseURL must follow the S3 virtual hosted-style request URL format. For example,
     *         https://bucket-name.s3.Region.amazonaws.com/key-name.
     *         </p>
     *         <p>
     *         Before you can use S3_SIGV4, you must meet these requirements:
     *         </p>
     *         <p>
     *         • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal
     *         access in IAM. For information about configuring access in IAM, see Access management in the IAM User
     *         Guide.
     *         </p>
     *         <p>
     *         • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests
     *         referenced by the VodSource packaging configurations.
     *         </p>
     *         <p>
     *         • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced
     *         by your MediaTailor VodSource packaging configurations.
     * @see AccessType
     */
    public final AccessType accessType() {
        return AccessType.fromValue(accessType);
    }

    /**
     * <p>
     * The type of authentication used to access content from HttpConfiguration::BaseUrl on your source location.
     * Accepted value: S3_SIGV4.
     * </p>
     * <p>
     * S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source
     * location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication to
     * access the bucket where your source content is stored. Your MediaTailor source location baseURL must follow the
     * S3 virtual hosted-style request URL format. For example, https://bucket-name.s3.Region.amazonaws.com/key-name.
     * </p>
     * <p>
     * Before you can use S3_SIGV4, you must meet these requirements:
     * </p>
     * <p>
     * • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access in
     * IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.
     * </p>
     * <p>
     * • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests
     * referenced by the VodSource packaging configurations.
     * </p>
     * <p>
     * • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by your
     * MediaTailor VodSource packaging configurations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link AccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of authentication used to access content from HttpConfiguration::BaseUrl on your source
     *         location. Accepted value: S3_SIGV4.</p>
     *         <p>
     *         S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your
     *         source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4)
     *         authentication to access the bucket where your source content is stored. Your MediaTailor source location
     *         baseURL must follow the S3 virtual hosted-style request URL format. For example,
     *         https://bucket-name.s3.Region.amazonaws.com/key-name.
     *         </p>
     *         <p>
     *         Before you can use S3_SIGV4, you must meet these requirements:
     *         </p>
     *         <p>
     *         • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal
     *         access in IAM. For information about configuring access in IAM, see Access management in the IAM User
     *         Guide.
     *         </p>
     *         <p>
     *         • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests
     *         referenced by the VodSource packaging configurations.
     *         </p>
     *         <p>
     *         • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced
     *         by your MediaTailor VodSource packaging configurations.
     * @see AccessType
     */
    public final String accessTypeAsString() {
        return accessType;
    }

    /**
     * <p>
     * AWS Secrets Manager access token configuration parameters.
     * </p>
     * 
     * @return AWS Secrets Manager access token configuration parameters.
     */
    public final SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration() {
        return secretsManagerAccessTokenConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(secretsManagerAccessTokenConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessConfiguration)) {
            return false;
        }
        AccessConfiguration other = (AccessConfiguration) obj;
        return Objects.equals(accessTypeAsString(), other.accessTypeAsString())
                && Objects.equals(secretsManagerAccessTokenConfiguration(), other.secretsManagerAccessTokenConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessConfiguration").add("AccessType", accessTypeAsString())
                .add("SecretsManagerAccessTokenConfiguration", secretsManagerAccessTokenConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessType":
            return Optional.ofNullable(clazz.cast(accessTypeAsString()));
        case "SecretsManagerAccessTokenConfiguration":
            return Optional.ofNullable(clazz.cast(secretsManagerAccessTokenConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessConfiguration, T> g) {
        return obj -> g.apply((AccessConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessConfiguration> {
        /**
         * <p>
         * The type of authentication used to access content from HttpConfiguration::BaseUrl on your source location.
         * Accepted value: S3_SIGV4.
         * </p>
         * <p>
         * S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source
         * location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication
         * to access the bucket where your source content is stored. Your MediaTailor source location baseURL must
         * follow the S3 virtual hosted-style request URL format. For example,
         * https://bucket-name.s3.Region.amazonaws.com/key-name.
         * </p>
         * <p>
         * Before you can use S3_SIGV4, you must meet these requirements:
         * </p>
         * <p>
         * • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access
         * in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.
         * </p>
         * <p>
         * • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests
         * referenced by the VodSource packaging configurations.
         * </p>
         * <p>
         * • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by
         * your MediaTailor VodSource packaging configurations.
         * </p>
         * 
         * @param accessType
         *        The type of authentication used to access content from HttpConfiguration::BaseUrl on your source
         *        location. Accepted value: S3_SIGV4.</p>
         *        <p>
         *        S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your
         *        source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4)
         *        authentication to access the bucket where your source content is stored. Your MediaTailor source
         *        location baseURL must follow the S3 virtual hosted-style request URL format. For example,
         *        https://bucket-name.s3.Region.amazonaws.com/key-name.
         *        </p>
         *        <p>
         *        Before you can use S3_SIGV4, you must meet these requirements:
         *        </p>
         *        <p>
         *        • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal
         *        access in IAM. For information about configuring access in IAM, see Access management in the IAM User
         *        Guide.
         *        </p>
         *        <p>
         *        • The mediatailor.amazonaws.com service principal must have permissions to read all top level
         *        manifests referenced by the VodSource packaging configurations.
         *        </p>
         *        <p>
         *        • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests
         *        referenced by your MediaTailor VodSource packaging configurations.
         * @see AccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessType
         */
        Builder accessType(String accessType);

        /**
         * <p>
         * The type of authentication used to access content from HttpConfiguration::BaseUrl on your source location.
         * Accepted value: S3_SIGV4.
         * </p>
         * <p>
         * S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your source
         * location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4) authentication
         * to access the bucket where your source content is stored. Your MediaTailor source location baseURL must
         * follow the S3 virtual hosted-style request URL format. For example,
         * https://bucket-name.s3.Region.amazonaws.com/key-name.
         * </p>
         * <p>
         * Before you can use S3_SIGV4, you must meet these requirements:
         * </p>
         * <p>
         * • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal access
         * in IAM. For information about configuring access in IAM, see Access management in the IAM User Guide.
         * </p>
         * <p>
         * • The mediatailor.amazonaws.com service principal must have permissions to read all top level manifests
         * referenced by the VodSource packaging configurations.
         * </p>
         * <p>
         * • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests referenced by
         * your MediaTailor VodSource packaging configurations.
         * </p>
         * 
         * @param accessType
         *        The type of authentication used to access content from HttpConfiguration::BaseUrl on your source
         *        location. Accepted value: S3_SIGV4.</p>
         *        <p>
         *        S3_SIGV4 - AWS Signature Version 4 authentication for Amazon S3 hosted virtual-style access. If your
         *        source location base URL is an Amazon S3 bucket, MediaTailor can use AWS Signature Version 4 (SigV4)
         *        authentication to access the bucket where your source content is stored. Your MediaTailor source
         *        location baseURL must follow the S3 virtual hosted-style request URL format. For example,
         *        https://bucket-name.s3.Region.amazonaws.com/key-name.
         *        </p>
         *        <p>
         *        Before you can use S3_SIGV4, you must meet these requirements:
         *        </p>
         *        <p>
         *        • You must allow MediaTailor to access your S3 bucket by granting mediatailor.amazonaws.com principal
         *        access in IAM. For information about configuring access in IAM, see Access management in the IAM User
         *        Guide.
         *        </p>
         *        <p>
         *        • The mediatailor.amazonaws.com service principal must have permissions to read all top level
         *        manifests referenced by the VodSource packaging configurations.
         *        </p>
         *        <p>
         *        • The caller of the API must have s3:GetObject IAM permissions to read all top level manifests
         *        referenced by your MediaTailor VodSource packaging configurations.
         * @see AccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessType
         */
        Builder accessType(AccessType accessType);

        /**
         * <p>
         * AWS Secrets Manager access token configuration parameters.
         * </p>
         * 
         * @param secretsManagerAccessTokenConfiguration
         *        AWS Secrets Manager access token configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretsManagerAccessTokenConfiguration(
                SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration);

        /**
         * <p>
         * AWS Secrets Manager access token configuration parameters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SecretsManagerAccessTokenConfiguration.Builder} avoiding the need to create one manually via
         * {@link SecretsManagerAccessTokenConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecretsManagerAccessTokenConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #secretsManagerAccessTokenConfiguration(SecretsManagerAccessTokenConfiguration)}.
         * 
         * @param secretsManagerAccessTokenConfiguration
         *        a consumer that will call methods on {@link SecretsManagerAccessTokenConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secretsManagerAccessTokenConfiguration(SecretsManagerAccessTokenConfiguration)
         */
        default Builder secretsManagerAccessTokenConfiguration(
                Consumer<SecretsManagerAccessTokenConfiguration.Builder> secretsManagerAccessTokenConfiguration) {
            return secretsManagerAccessTokenConfiguration(SecretsManagerAccessTokenConfiguration.builder()
                    .applyMutation(secretsManagerAccessTokenConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessType;

        private SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessConfiguration model) {
            accessType(model.accessType);
            secretsManagerAccessTokenConfiguration(model.secretsManagerAccessTokenConfiguration);
        }

        public final String getAccessType() {
            return accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(AccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final SecretsManagerAccessTokenConfiguration.Builder getSecretsManagerAccessTokenConfiguration() {
            return secretsManagerAccessTokenConfiguration != null ? secretsManagerAccessTokenConfiguration.toBuilder() : null;
        }

        public final void setSecretsManagerAccessTokenConfiguration(
                SecretsManagerAccessTokenConfiguration.BuilderImpl secretsManagerAccessTokenConfiguration) {
            this.secretsManagerAccessTokenConfiguration = secretsManagerAccessTokenConfiguration != null ? secretsManagerAccessTokenConfiguration
                    .build() : null;
        }

        @Override
        public final Builder secretsManagerAccessTokenConfiguration(
                SecretsManagerAccessTokenConfiguration secretsManagerAccessTokenConfiguration) {
            this.secretsManagerAccessTokenConfiguration = secretsManagerAccessTokenConfiguration;
            return this;
        }

        @Override
        public AccessConfiguration build() {
            return new AccessConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
