/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Schedule configuration parameters. A channel must be stopped before changes can be made to the schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduleConfiguration.Builder, ScheduleConfiguration> {
    private static final SdkField<Transition> TRANSITION_FIELD = SdkField.<Transition> builder(MarshallingType.SDK_POJO)
            .memberName("Transition").getter(getter(ScheduleConfiguration::transition)).setter(setter(Builder::transition))
            .constructor(Transition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Transition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Transition transition;

    private ScheduleConfiguration(BuilderImpl builder) {
        this.transition = builder.transition;
    }

    /**
     * <p>
     * Program transition configurations.
     * </p>
     * 
     * @return Program transition configurations.
     */
    public final Transition transition() {
        return transition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(transition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleConfiguration)) {
            return false;
        }
        ScheduleConfiguration other = (ScheduleConfiguration) obj;
        return Objects.equals(transition(), other.transition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleConfiguration").add("Transition", transition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Transition":
            return Optional.ofNullable(clazz.cast(transition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleConfiguration, T> g) {
        return obj -> g.apply((ScheduleConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleConfiguration> {
        /**
         * <p>
         * Program transition configurations.
         * </p>
         * 
         * @param transition
         *        Program transition configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transition(Transition transition);

        /**
         * <p>
         * Program transition configurations.
         * </p>
         * This is a convenience method that creates an instance of the {@link Transition.Builder} avoiding the need to
         * create one manually via {@link Transition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Transition.Builder#build()} is called immediately and its result
         * is passed to {@link #transition(Transition)}.
         * 
         * @param transition
         *        a consumer that will call methods on {@link Transition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transition(Transition)
         */
        default Builder transition(Consumer<Transition.Builder> transition) {
            return transition(Transition.builder().applyMutation(transition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Transition transition;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleConfiguration model) {
            transition(model.transition);
        }

        public final Transition.Builder getTransition() {
            return transition != null ? transition.toBuilder() : null;
        }

        public final void setTransition(Transition.BuilderImpl transition) {
            this.transition = transition != null ? transition.build() : null;
        }

        @Override
        public final Builder transition(Transition transition) {
            this.transition = transition;
            return this;
        }

        @Override
        public ScheduleConfiguration build() {
            return new ScheduleConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
