/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutPlaybackConfigurationResponse extends MediaTailorResponse implements
        ToCopyableBuilder<PutPlaybackConfigurationResponse.Builder, PutPlaybackConfigurationResponse> {
    private static final SdkField<String> AD_DECISION_SERVER_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdDecisionServerUrl").getter(getter(PutPlaybackConfigurationResponse::adDecisionServerUrl))
            .setter(setter(Builder::adDecisionServerUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdDecisionServerUrl").build())
            .build();

    private static final SdkField<AvailSuppression> AVAIL_SUPPRESSION_FIELD = SdkField
            .<AvailSuppression> builder(MarshallingType.SDK_POJO).memberName("AvailSuppression")
            .getter(getter(PutPlaybackConfigurationResponse::availSuppression)).setter(setter(Builder::availSuppression))
            .constructor(AvailSuppression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailSuppression").build()).build();

    private static final SdkField<Bumper> BUMPER_FIELD = SdkField.<Bumper> builder(MarshallingType.SDK_POJO).memberName("Bumper")
            .getter(getter(PutPlaybackConfigurationResponse::bumper)).setter(setter(Builder::bumper))
            .constructor(Bumper::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bumper").build()).build();

    private static final SdkField<CdnConfiguration> CDN_CONFIGURATION_FIELD = SdkField
            .<CdnConfiguration> builder(MarshallingType.SDK_POJO).memberName("CdnConfiguration")
            .getter(getter(PutPlaybackConfigurationResponse::cdnConfiguration)).setter(setter(Builder::cdnConfiguration))
            .constructor(CdnConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CdnConfiguration").build()).build();

    private static final SdkField<Map<String, Map<String, String>>> CONFIGURATION_ALIASES_FIELD = SdkField
            .<Map<String, Map<String, String>>> builder(MarshallingType.MAP)
            .memberName("ConfigurationAliases")
            .getter(getter(PutPlaybackConfigurationResponse::configurationAliases))
            .setter(setter(Builder::configurationAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationAliases").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<DashConfiguration> DASH_CONFIGURATION_FIELD = SdkField
            .<DashConfiguration> builder(MarshallingType.SDK_POJO).memberName("DashConfiguration")
            .getter(getter(PutPlaybackConfigurationResponse::dashConfiguration)).setter(setter(Builder::dashConfiguration))
            .constructor(DashConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashConfiguration").build()).build();

    private static final SdkField<HlsConfiguration> HLS_CONFIGURATION_FIELD = SdkField
            .<HlsConfiguration> builder(MarshallingType.SDK_POJO).memberName("HlsConfiguration")
            .getter(getter(PutPlaybackConfigurationResponse::hlsConfiguration)).setter(setter(Builder::hlsConfiguration))
            .constructor(HlsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsConfiguration").build()).build();

    private static final SdkField<LivePreRollConfiguration> LIVE_PRE_ROLL_CONFIGURATION_FIELD = SdkField
            .<LivePreRollConfiguration> builder(MarshallingType.SDK_POJO).memberName("LivePreRollConfiguration")
            .getter(getter(PutPlaybackConfigurationResponse::livePreRollConfiguration))
            .setter(setter(Builder::livePreRollConfiguration)).constructor(LivePreRollConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LivePreRollConfiguration").build())
            .build();

    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("LogConfiguration")
            .getter(getter(PutPlaybackConfigurationResponse::logConfiguration)).setter(setter(Builder::logConfiguration))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfiguration").build()).build();

    private static final SdkField<ManifestProcessingRules> MANIFEST_PROCESSING_RULES_FIELD = SdkField
            .<ManifestProcessingRules> builder(MarshallingType.SDK_POJO).memberName("ManifestProcessingRules")
            .getter(getter(PutPlaybackConfigurationResponse::manifestProcessingRules))
            .setter(setter(Builder::manifestProcessingRules)).constructor(ManifestProcessingRules::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestProcessingRules").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PutPlaybackConfigurationResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Integer> PERSONALIZATION_THRESHOLD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PersonalizationThresholdSeconds")
            .getter(getter(PutPlaybackConfigurationResponse::personalizationThresholdSeconds))
            .setter(setter(Builder::personalizationThresholdSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalizationThresholdSeconds")
                    .build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackConfigurationArn").getter(getter(PutPlaybackConfigurationResponse::playbackConfigurationArn))
            .setter(setter(Builder::playbackConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationArn").build())
            .build();

    private static final SdkField<String> PLAYBACK_ENDPOINT_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackEndpointPrefix").getter(getter(PutPlaybackConfigurationResponse::playbackEndpointPrefix))
            .setter(setter(Builder::playbackEndpointPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackEndpointPrefix").build())
            .build();

    private static final SdkField<String> SESSION_INITIALIZATION_ENDPOINT_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SessionInitializationEndpointPrefix")
            .getter(getter(PutPlaybackConfigurationResponse::sessionInitializationEndpointPrefix))
            .setter(setter(Builder::sessionInitializationEndpointPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SessionInitializationEndpointPrefix").build()).build();

    private static final SdkField<String> SLATE_AD_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SlateAdUrl").getter(getter(PutPlaybackConfigurationResponse::slateAdUrl))
            .setter(setter(Builder::slateAdUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlateAdUrl").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(PutPlaybackConfigurationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TRANSCODE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TranscodeProfileName").getter(getter(PutPlaybackConfigurationResponse::transcodeProfileName))
            .setter(setter(Builder::transcodeProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TranscodeProfileName").build())
            .build();

    private static final SdkField<String> VIDEO_CONTENT_SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VideoContentSourceUrl").getter(getter(PutPlaybackConfigurationResponse::videoContentSourceUrl))
            .setter(setter(Builder::videoContentSourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VideoContentSourceUrl").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_DECISION_SERVER_URL_FIELD,
            AVAIL_SUPPRESSION_FIELD, BUMPER_FIELD, CDN_CONFIGURATION_FIELD, CONFIGURATION_ALIASES_FIELD,
            DASH_CONFIGURATION_FIELD, HLS_CONFIGURATION_FIELD, LIVE_PRE_ROLL_CONFIGURATION_FIELD, LOG_CONFIGURATION_FIELD,
            MANIFEST_PROCESSING_RULES_FIELD, NAME_FIELD, PERSONALIZATION_THRESHOLD_SECONDS_FIELD,
            PLAYBACK_CONFIGURATION_ARN_FIELD, PLAYBACK_ENDPOINT_PREFIX_FIELD, SESSION_INITIALIZATION_ENDPOINT_PREFIX_FIELD,
            SLATE_AD_URL_FIELD, TAGS_FIELD, TRANSCODE_PROFILE_NAME_FIELD, VIDEO_CONTENT_SOURCE_URL_FIELD));

    private final String adDecisionServerUrl;

    private final AvailSuppression availSuppression;

    private final Bumper bumper;

    private final CdnConfiguration cdnConfiguration;

    private final Map<String, Map<String, String>> configurationAliases;

    private final DashConfiguration dashConfiguration;

    private final HlsConfiguration hlsConfiguration;

    private final LivePreRollConfiguration livePreRollConfiguration;

    private final LogConfiguration logConfiguration;

    private final ManifestProcessingRules manifestProcessingRules;

    private final String name;

    private final Integer personalizationThresholdSeconds;

    private final String playbackConfigurationArn;

    private final String playbackEndpointPrefix;

    private final String sessionInitializationEndpointPrefix;

    private final String slateAdUrl;

    private final Map<String, String> tags;

    private final String transcodeProfileName;

    private final String videoContentSourceUrl;

    private PutPlaybackConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.adDecisionServerUrl = builder.adDecisionServerUrl;
        this.availSuppression = builder.availSuppression;
        this.bumper = builder.bumper;
        this.cdnConfiguration = builder.cdnConfiguration;
        this.configurationAliases = builder.configurationAliases;
        this.dashConfiguration = builder.dashConfiguration;
        this.hlsConfiguration = builder.hlsConfiguration;
        this.livePreRollConfiguration = builder.livePreRollConfiguration;
        this.logConfiguration = builder.logConfiguration;
        this.manifestProcessingRules = builder.manifestProcessingRules;
        this.name = builder.name;
        this.personalizationThresholdSeconds = builder.personalizationThresholdSeconds;
        this.playbackConfigurationArn = builder.playbackConfigurationArn;
        this.playbackEndpointPrefix = builder.playbackEndpointPrefix;
        this.sessionInitializationEndpointPrefix = builder.sessionInitializationEndpointPrefix;
        this.slateAdUrl = builder.slateAdUrl;
        this.tags = builder.tags;
        this.transcodeProfileName = builder.transcodeProfileName;
        this.videoContentSourceUrl = builder.videoContentSourceUrl;
    }

    /**
     * <p>
     * The URL for the ad decision server (ADS). This includes the specification of static parameters and placeholders
     * for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and session-specific parameters as
     * needed when calling the ADS. Alternately, for testing, you can provide a static VAST URL. The maximum length is
     * 25,000 characters.
     * </p>
     * 
     * @return The URL for the ad decision server (ADS). This includes the specification of static parameters and
     *         placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and
     *         session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a
     *         static VAST URL. The maximum length is 25,000 characters.
     */
    public final String adDecisionServerUrl() {
        return adDecisionServerUrl;
    }

    /**
     * <p>
     * The configuration for avail suppression, also known as ad suppression. For more information about ad suppression,
     * see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Suppression</a>.
     * </p>
     * 
     * @return The configuration for avail suppression, also known as ad suppression. For more information about ad
     *         suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad
     *         Suppression</a>.
     */
    public final AvailSuppression availSuppression() {
        return availSuppression;
    }

    /**
     * <p>
     * The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the end of
     * an ad break. To learn more about bumpers, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.
     * </p>
     * 
     * @return The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before
     *         the end of an ad break. To learn more about bumpers, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.
     */
    public final Bumper bumper() {
        return bumper;
    }

    /**
     * <p>
     * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment
     * management.
     * </p>
     * 
     * @return The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad
     *         segment management.
     */
    public final CdnConfiguration cdnConfiguration() {
        return cdnConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the ConfigurationAliases property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasConfigurationAliases() {
        return configurationAliases != null && !(configurationAliases instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The player parameters and aliases used as dynamic variables during session initialization. For more information,
     * see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConfigurationAliases} method.
     * </p>
     * 
     * @return The player parameters and aliases used as dynamic variables during session initialization. For more
     *         information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain
     *         Variables</a>.
     */
    public final Map<String, Map<String, String>> configurationAliases() {
        return configurationAliases;
    }

    /**
     * <p>
     * The configuration for DASH content.
     * </p>
     * 
     * @return The configuration for DASH content.
     */
    public final DashConfiguration dashConfiguration() {
        return dashConfiguration;
    }

    /**
     * <p>
     * The configuration for HLS content.
     * </p>
     * 
     * @return The configuration for HLS content.
     */
    public final HlsConfiguration hlsConfiguration() {
        return hlsConfiguration;
    }

    /**
     * <p>
     * The configuration for pre-roll ad insertion.
     * </p>
     * 
     * @return The configuration for pre-roll ad insertion.
     */
    public final LivePreRollConfiguration livePreRollConfiguration() {
        return livePreRollConfiguration;
    }

    /**
     * <p>
     * The Amazon CloudWatch log settings for a playback configuration.
     * </p>
     * 
     * @return The Amazon CloudWatch log settings for a playback configuration.
     */
    public final LogConfiguration logConfiguration() {
        return logConfiguration;
    }

    /**
     * <p>
     * The configuration for manifest processing rules. Manifest processing rules enable customization of the
     * personalized manifests created by MediaTailor.
     * </p>
     * 
     * @return The configuration for manifest processing rules. Manifest processing rules enable customization of the
     *         personalized manifests created by MediaTailor.
     */
    public final ManifestProcessingRules manifestProcessingRules() {
        return manifestProcessingRules;
    }

    /**
     * <p>
     * The identifier for the playback configuration.
     * </p>
     * 
     * @return The identifier for the playback configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of
     * underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is abandoned
     * and the underlying content is shown. This feature applies to <i>ad replacement</i> in live and VOD streams,
     * rather than ad insertion, because it relies on an underlying content stream. For more information about ad break
     * behavior, including ad replacement and insertion, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS Elemental
     * MediaTailor</a>.
     * </p>
     * 
     * @return Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration
     *         of underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is
     *         abandoned and the underlying content is shown. This feature applies to <i>ad replacement</i> in live and
     *         VOD streams, rather than ad insertion, because it relies on an underlying content stream. For more
     *         information about ad break behavior, including ad replacement and insertion, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS Elemental
     *         MediaTailor</a>.
     */
    public final Integer personalizationThresholdSeconds() {
        return personalizationThresholdSeconds;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the playback configuration.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the playback configuration.
     */
    public final String playbackConfigurationArn() {
        return playbackConfigurationArn;
    }

    /**
     * <p>
     * The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will use
     * server-side reporting.
     * </p>
     * 
     * @return The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will use
     *         server-side reporting.
     */
    public final String playbackEndpointPrefix() {
        return playbackEndpointPrefix;
    }

    /**
     * <p>
     * The URL that the player uses to initialize a session that uses client-side reporting.
     * </p>
     * 
     * @return The URL that the player uses to initialize a session that uses client-side reporting.
     */
    public final String sessionInitializationEndpointPrefix() {
        return sessionInitializationEndpointPrefix;
    }

    /**
     * <p>
     * The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS Elemental
     * MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for non-VPAID
     * playback configurations. For VPAID, the slate is required because MediaTailor provides it in the slots designated
     * for dynamic ad content. The slate must be a high-quality asset that contains both audio and video.
     * </p>
     * 
     * @return The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS
     *         Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional
     *         for non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor provides it
     *         in the slots designated for dynamic ad content. The slate must be a high-quality asset that contains both
     *         audio and video.
     */
    public final String slateAdUrl() {
        return slateAdUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags assigned to the playback configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags assigned to the playback configuration.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name that is used to associate this playback configuration with a custom transcode profile. This overrides
     * the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom profiles with
     * the help of AWS Support.
     * </p>
     * 
     * @return The name that is used to associate this playback configuration with a custom transcode profile. This
     *         overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up
     *         custom profiles with the help of AWS Support.
     */
    public final String transcodeProfileName() {
        return transcodeProfileName;
    }

    /**
     * <p>
     * The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512 characters.
     * </p>
     * 
     * @return The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512
     *         characters.
     */
    public final String videoContentSourceUrl() {
        return videoContentSourceUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(adDecisionServerUrl());
        hashCode = 31 * hashCode + Objects.hashCode(availSuppression());
        hashCode = 31 * hashCode + Objects.hashCode(bumper());
        hashCode = 31 * hashCode + Objects.hashCode(cdnConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasConfigurationAliases() ? configurationAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dashConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hlsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(livePreRollConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(manifestProcessingRules());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(personalizationThresholdSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(playbackEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(sessionInitializationEndpointPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(slateAdUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(transcodeProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(videoContentSourceUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutPlaybackConfigurationResponse)) {
            return false;
        }
        PutPlaybackConfigurationResponse other = (PutPlaybackConfigurationResponse) obj;
        return Objects.equals(adDecisionServerUrl(), other.adDecisionServerUrl())
                && Objects.equals(availSuppression(), other.availSuppression()) && Objects.equals(bumper(), other.bumper())
                && Objects.equals(cdnConfiguration(), other.cdnConfiguration())
                && hasConfigurationAliases() == other.hasConfigurationAliases()
                && Objects.equals(configurationAliases(), other.configurationAliases())
                && Objects.equals(dashConfiguration(), other.dashConfiguration())
                && Objects.equals(hlsConfiguration(), other.hlsConfiguration())
                && Objects.equals(livePreRollConfiguration(), other.livePreRollConfiguration())
                && Objects.equals(logConfiguration(), other.logConfiguration())
                && Objects.equals(manifestProcessingRules(), other.manifestProcessingRules())
                && Objects.equals(name(), other.name())
                && Objects.equals(personalizationThresholdSeconds(), other.personalizationThresholdSeconds())
                && Objects.equals(playbackConfigurationArn(), other.playbackConfigurationArn())
                && Objects.equals(playbackEndpointPrefix(), other.playbackEndpointPrefix())
                && Objects.equals(sessionInitializationEndpointPrefix(), other.sessionInitializationEndpointPrefix())
                && Objects.equals(slateAdUrl(), other.slateAdUrl()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(transcodeProfileName(), other.transcodeProfileName())
                && Objects.equals(videoContentSourceUrl(), other.videoContentSourceUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutPlaybackConfigurationResponse").add("AdDecisionServerUrl", adDecisionServerUrl())
                .add("AvailSuppression", availSuppression()).add("Bumper", bumper()).add("CdnConfiguration", cdnConfiguration())
                .add("ConfigurationAliases", hasConfigurationAliases() ? configurationAliases() : null)
                .add("DashConfiguration", dashConfiguration()).add("HlsConfiguration", hlsConfiguration())
                .add("LivePreRollConfiguration", livePreRollConfiguration()).add("LogConfiguration", logConfiguration())
                .add("ManifestProcessingRules", manifestProcessingRules()).add("Name", name())
                .add("PersonalizationThresholdSeconds", personalizationThresholdSeconds())
                .add("PlaybackConfigurationArn", playbackConfigurationArn())
                .add("PlaybackEndpointPrefix", playbackEndpointPrefix())
                .add("SessionInitializationEndpointPrefix", sessionInitializationEndpointPrefix())
                .add("SlateAdUrl", slateAdUrl()).add("Tags", hasTags() ? tags() : null)
                .add("TranscodeProfileName", transcodeProfileName()).add("VideoContentSourceUrl", videoContentSourceUrl())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdDecisionServerUrl":
            return Optional.ofNullable(clazz.cast(adDecisionServerUrl()));
        case "AvailSuppression":
            return Optional.ofNullable(clazz.cast(availSuppression()));
        case "Bumper":
            return Optional.ofNullable(clazz.cast(bumper()));
        case "CdnConfiguration":
            return Optional.ofNullable(clazz.cast(cdnConfiguration()));
        case "ConfigurationAliases":
            return Optional.ofNullable(clazz.cast(configurationAliases()));
        case "DashConfiguration":
            return Optional.ofNullable(clazz.cast(dashConfiguration()));
        case "HlsConfiguration":
            return Optional.ofNullable(clazz.cast(hlsConfiguration()));
        case "LivePreRollConfiguration":
            return Optional.ofNullable(clazz.cast(livePreRollConfiguration()));
        case "LogConfiguration":
            return Optional.ofNullable(clazz.cast(logConfiguration()));
        case "ManifestProcessingRules":
            return Optional.ofNullable(clazz.cast(manifestProcessingRules()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PersonalizationThresholdSeconds":
            return Optional.ofNullable(clazz.cast(personalizationThresholdSeconds()));
        case "PlaybackConfigurationArn":
            return Optional.ofNullable(clazz.cast(playbackConfigurationArn()));
        case "PlaybackEndpointPrefix":
            return Optional.ofNullable(clazz.cast(playbackEndpointPrefix()));
        case "SessionInitializationEndpointPrefix":
            return Optional.ofNullable(clazz.cast(sessionInitializationEndpointPrefix()));
        case "SlateAdUrl":
            return Optional.ofNullable(clazz.cast(slateAdUrl()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "TranscodeProfileName":
            return Optional.ofNullable(clazz.cast(transcodeProfileName()));
        case "VideoContentSourceUrl":
            return Optional.ofNullable(clazz.cast(videoContentSourceUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutPlaybackConfigurationResponse, T> g) {
        return obj -> g.apply((PutPlaybackConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutPlaybackConfigurationResponse> {
        /**
         * <p>
         * The URL for the ad decision server (ADS). This includes the specification of static parameters and
         * placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and
         * session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide a
         * static VAST URL. The maximum length is 25,000 characters.
         * </p>
         * 
         * @param adDecisionServerUrl
         *        The URL for the ad decision server (ADS). This includes the specification of static parameters and
         *        placeholders for dynamic parameters. AWS Elemental MediaTailor substitutes player-specific and
         *        session-specific parameters as needed when calling the ADS. Alternately, for testing, you can provide
         *        a static VAST URL. The maximum length is 25,000 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adDecisionServerUrl(String adDecisionServerUrl);

        /**
         * <p>
         * The configuration for avail suppression, also known as ad suppression. For more information about ad
         * suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad
         * Suppression</a>.
         * </p>
         * 
         * @param availSuppression
         *        The configuration for avail suppression, also known as ad suppression. For more information about ad
         *        suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad
         *        Suppression</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availSuppression(AvailSuppression availSuppression);

        /**
         * <p>
         * The configuration for avail suppression, also known as ad suppression. For more information about ad
         * suppression, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad
         * Suppression</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AvailSuppression.Builder} avoiding the
         * need to create one manually via {@link AvailSuppression#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AvailSuppression.Builder#build()} is called immediately and its
         * result is passed to {@link #availSuppression(AvailSuppression)}.
         * 
         * @param availSuppression
         *        a consumer that will call methods on {@link AvailSuppression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availSuppression(AvailSuppression)
         */
        default Builder availSuppression(Consumer<AvailSuppression.Builder> availSuppression) {
            return availSuppression(AvailSuppression.builder().applyMutation(availSuppression).build());
        }

        /**
         * <p>
         * The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the
         * end of an ad break. To learn more about bumpers, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.
         * </p>
         * 
         * @param bumper
         *        The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before
         *        the end of an ad break. To learn more about bumpers, see <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bumper(Bumper bumper);

        /**
         * <p>
         * The configuration for bumpers. Bumpers are short audio or video clips that play at the start or before the
         * end of an ad break. To learn more about bumpers, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/bumpers.html">Bumpers</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Bumper.Builder} avoiding the need to
         * create one manually via {@link Bumper#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Bumper.Builder#build()} is called immediately and its result is
         * passed to {@link #bumper(Bumper)}.
         * 
         * @param bumper
         *        a consumer that will call methods on {@link Bumper.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bumper(Bumper)
         */
        default Builder bumper(Consumer<Bumper.Builder> bumper) {
            return bumper(Bumper.builder().applyMutation(bumper).build());
        }

        /**
         * <p>
         * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad
         * segment management.
         * </p>
         * 
         * @param cdnConfiguration
         *        The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and
         *        ad segment management.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cdnConfiguration(CdnConfiguration cdnConfiguration);

        /**
         * <p>
         * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad
         * segment management.
         * </p>
         * This is a convenience method that creates an instance of the {@link CdnConfiguration.Builder} avoiding the
         * need to create one manually via {@link CdnConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CdnConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #cdnConfiguration(CdnConfiguration)}.
         * 
         * @param cdnConfiguration
         *        a consumer that will call methods on {@link CdnConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cdnConfiguration(CdnConfiguration)
         */
        default Builder cdnConfiguration(Consumer<CdnConfiguration.Builder> cdnConfiguration) {
            return cdnConfiguration(CdnConfiguration.builder().applyMutation(cdnConfiguration).build());
        }

        /**
         * <p>
         * The player parameters and aliases used as dynamic variables during session initialization. For more
         * information, see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain
         * Variables</a>.
         * </p>
         * 
         * @param configurationAliases
         *        The player parameters and aliases used as dynamic variables during session initialization. For more
         *        information, see <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/variables-domain.html">Domain Variables</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationAliases(Map<String, ? extends Map<String, String>> configurationAliases);

        /**
         * <p>
         * The configuration for DASH content.
         * </p>
         * 
         * @param dashConfiguration
         *        The configuration for DASH content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashConfiguration(DashConfiguration dashConfiguration);

        /**
         * <p>
         * The configuration for DASH content.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashConfiguration.Builder} avoiding the
         * need to create one manually via {@link DashConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #dashConfiguration(DashConfiguration)}.
         * 
         * @param dashConfiguration
         *        a consumer that will call methods on {@link DashConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashConfiguration(DashConfiguration)
         */
        default Builder dashConfiguration(Consumer<DashConfiguration.Builder> dashConfiguration) {
            return dashConfiguration(DashConfiguration.builder().applyMutation(dashConfiguration).build());
        }

        /**
         * <p>
         * The configuration for HLS content.
         * </p>
         * 
         * @param hlsConfiguration
         *        The configuration for HLS content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsConfiguration(HlsConfiguration hlsConfiguration);

        /**
         * <p>
         * The configuration for HLS content.
         * </p>
         * This is a convenience method that creates an instance of the {@link HlsConfiguration.Builder} avoiding the
         * need to create one manually via {@link HlsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #hlsConfiguration(HlsConfiguration)}.
         * 
         * @param hlsConfiguration
         *        a consumer that will call methods on {@link HlsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsConfiguration(HlsConfiguration)
         */
        default Builder hlsConfiguration(Consumer<HlsConfiguration.Builder> hlsConfiguration) {
            return hlsConfiguration(HlsConfiguration.builder().applyMutation(hlsConfiguration).build());
        }

        /**
         * <p>
         * The configuration for pre-roll ad insertion.
         * </p>
         * 
         * @param livePreRollConfiguration
         *        The configuration for pre-roll ad insertion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder livePreRollConfiguration(LivePreRollConfiguration livePreRollConfiguration);

        /**
         * <p>
         * The configuration for pre-roll ad insertion.
         * </p>
         * This is a convenience method that creates an instance of the {@link LivePreRollConfiguration.Builder}
         * avoiding the need to create one manually via {@link LivePreRollConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LivePreRollConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #livePreRollConfiguration(LivePreRollConfiguration)}.
         * 
         * @param livePreRollConfiguration
         *        a consumer that will call methods on {@link LivePreRollConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #livePreRollConfiguration(LivePreRollConfiguration)
         */
        default Builder livePreRollConfiguration(Consumer<LivePreRollConfiguration.Builder> livePreRollConfiguration) {
            return livePreRollConfiguration(LivePreRollConfiguration.builder().applyMutation(livePreRollConfiguration).build());
        }

        /**
         * <p>
         * The Amazon CloudWatch log settings for a playback configuration.
         * </p>
         * 
         * @param logConfiguration
         *        The Amazon CloudWatch log settings for a playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfiguration(LogConfiguration logConfiguration);

        /**
         * <p>
         * The Amazon CloudWatch log settings for a playback configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #logConfiguration(LogConfiguration)}.
         * 
         * @param logConfiguration
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfiguration(LogConfiguration)
         */
        default Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return logConfiguration(LogConfiguration.builder().applyMutation(logConfiguration).build());
        }

        /**
         * <p>
         * The configuration for manifest processing rules. Manifest processing rules enable customization of the
         * personalized manifests created by MediaTailor.
         * </p>
         * 
         * @param manifestProcessingRules
         *        The configuration for manifest processing rules. Manifest processing rules enable customization of the
         *        personalized manifests created by MediaTailor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestProcessingRules(ManifestProcessingRules manifestProcessingRules);

        /**
         * <p>
         * The configuration for manifest processing rules. Manifest processing rules enable customization of the
         * personalized manifests created by MediaTailor.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManifestProcessingRules.Builder} avoiding
         * the need to create one manually via {@link ManifestProcessingRules#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManifestProcessingRules.Builder#build()} is called immediately
         * and its result is passed to {@link #manifestProcessingRules(ManifestProcessingRules)}.
         * 
         * @param manifestProcessingRules
         *        a consumer that will call methods on {@link ManifestProcessingRules.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestProcessingRules(ManifestProcessingRules)
         */
        default Builder manifestProcessingRules(Consumer<ManifestProcessingRules.Builder> manifestProcessingRules) {
            return manifestProcessingRules(ManifestProcessingRules.builder().applyMutation(manifestProcessingRules).build());
        }

        /**
         * <p>
         * The identifier for the playback configuration.
         * </p>
         * 
         * @param name
         *        The identifier for the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the duration of
         * underfilled ad time exceeds the personalization threshold, then the personalization of the ad break is
         * abandoned and the underlying content is shown. This feature applies to <i>ad replacement</i> in live and VOD
         * streams, rather than ad insertion, because it relies on an underlying content stream. For more information
         * about ad break behavior, including ad replacement and insertion, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS Elemental
         * MediaTailor</a>.
         * </p>
         * 
         * @param personalizationThresholdSeconds
         *        Defines the maximum duration of underfilled ad time (in seconds) allowed in an ad break. If the
         *        duration of underfilled ad time exceeds the personalization threshold, then the personalization of the
         *        ad break is abandoned and the underlying content is shown. This feature applies to <i>ad
         *        replacement</i> in live and VOD streams, rather than ad insertion, because it relies on an underlying
         *        content stream. For more information about ad break behavior, including ad replacement and insertion,
         *        see <a href="https://docs.aws.amazon.com/mediatailor/latest/ug/ad-behavior.html">Ad Behavior in AWS
         *        Elemental MediaTailor</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalizationThresholdSeconds(Integer personalizationThresholdSeconds);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationArn
         *        The Amazon Resource Name (ARN) for the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationArn(String playbackConfigurationArn);

        /**
         * <p>
         * The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will use
         * server-side reporting.
         * </p>
         * 
         * @param playbackEndpointPrefix
         *        The URL that the player accesses to get a manifest from AWS Elemental MediaTailor. This session will
         *        use server-side reporting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackEndpointPrefix(String playbackEndpointPrefix);

        /**
         * <p>
         * The URL that the player uses to initialize a session that uses client-side reporting.
         * </p>
         * 
         * @param sessionInitializationEndpointPrefix
         *        The URL that the player uses to initialize a session that uses client-side reporting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix);

        /**
         * <p>
         * The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads. AWS
         * Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is optional for
         * non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor provides it in the
         * slots designated for dynamic ad content. The slate must be a high-quality asset that contains both audio and
         * video.
         * </p>
         * 
         * @param slateAdUrl
         *        The URL for a high-quality video asset to transcode and use to fill in time that's not used by ads.
         *        AWS Elemental MediaTailor shows the slate to fill in gaps in media content. Configuring the slate is
         *        optional for non-VPAID playback configurations. For VPAID, the slate is required because MediaTailor
         *        provides it in the slots designated for dynamic ad content. The slate must be a high-quality asset
         *        that contains both audio and video.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slateAdUrl(String slateAdUrl);

        /**
         * <p>
         * The tags assigned to the playback configuration.
         * </p>
         * 
         * @param tags
         *        The tags assigned to the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name that is used to associate this playback configuration with a custom transcode profile. This
         * overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up custom
         * profiles with the help of AWS Support.
         * </p>
         * 
         * @param transcodeProfileName
         *        The name that is used to associate this playback configuration with a custom transcode profile. This
         *        overrides the dynamic transcoding defaults of MediaTailor. Use this only if you have already set up
         *        custom profiles with the help of AWS Support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transcodeProfileName(String transcodeProfileName);

        /**
         * <p>
         * The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512
         * characters.
         * </p>
         * 
         * @param videoContentSourceUrl
         *        The URL prefix for the parent manifest for the stream, minus the asset ID. The maximum length is 512
         *        characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder videoContentSourceUrl(String videoContentSourceUrl);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private String adDecisionServerUrl;

        private AvailSuppression availSuppression;

        private Bumper bumper;

        private CdnConfiguration cdnConfiguration;

        private Map<String, Map<String, String>> configurationAliases = DefaultSdkAutoConstructMap.getInstance();

        private DashConfiguration dashConfiguration;

        private HlsConfiguration hlsConfiguration;

        private LivePreRollConfiguration livePreRollConfiguration;

        private LogConfiguration logConfiguration;

        private ManifestProcessingRules manifestProcessingRules;

        private String name;

        private Integer personalizationThresholdSeconds;

        private String playbackConfigurationArn;

        private String playbackEndpointPrefix;

        private String sessionInitializationEndpointPrefix;

        private String slateAdUrl;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String transcodeProfileName;

        private String videoContentSourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(PutPlaybackConfigurationResponse model) {
            super(model);
            adDecisionServerUrl(model.adDecisionServerUrl);
            availSuppression(model.availSuppression);
            bumper(model.bumper);
            cdnConfiguration(model.cdnConfiguration);
            configurationAliases(model.configurationAliases);
            dashConfiguration(model.dashConfiguration);
            hlsConfiguration(model.hlsConfiguration);
            livePreRollConfiguration(model.livePreRollConfiguration);
            logConfiguration(model.logConfiguration);
            manifestProcessingRules(model.manifestProcessingRules);
            name(model.name);
            personalizationThresholdSeconds(model.personalizationThresholdSeconds);
            playbackConfigurationArn(model.playbackConfigurationArn);
            playbackEndpointPrefix(model.playbackEndpointPrefix);
            sessionInitializationEndpointPrefix(model.sessionInitializationEndpointPrefix);
            slateAdUrl(model.slateAdUrl);
            tags(model.tags);
            transcodeProfileName(model.transcodeProfileName);
            videoContentSourceUrl(model.videoContentSourceUrl);
        }

        public final String getAdDecisionServerUrl() {
            return adDecisionServerUrl;
        }

        public final void setAdDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
        }

        @Override
        public final Builder adDecisionServerUrl(String adDecisionServerUrl) {
            this.adDecisionServerUrl = adDecisionServerUrl;
            return this;
        }

        public final AvailSuppression.Builder getAvailSuppression() {
            return availSuppression != null ? availSuppression.toBuilder() : null;
        }

        public final void setAvailSuppression(AvailSuppression.BuilderImpl availSuppression) {
            this.availSuppression = availSuppression != null ? availSuppression.build() : null;
        }

        @Override
        public final Builder availSuppression(AvailSuppression availSuppression) {
            this.availSuppression = availSuppression;
            return this;
        }

        public final Bumper.Builder getBumper() {
            return bumper != null ? bumper.toBuilder() : null;
        }

        public final void setBumper(Bumper.BuilderImpl bumper) {
            this.bumper = bumper != null ? bumper.build() : null;
        }

        @Override
        public final Builder bumper(Bumper bumper) {
            this.bumper = bumper;
            return this;
        }

        public final CdnConfiguration.Builder getCdnConfiguration() {
            return cdnConfiguration != null ? cdnConfiguration.toBuilder() : null;
        }

        public final void setCdnConfiguration(CdnConfiguration.BuilderImpl cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration != null ? cdnConfiguration.build() : null;
        }

        @Override
        public final Builder cdnConfiguration(CdnConfiguration cdnConfiguration) {
            this.cdnConfiguration = cdnConfiguration;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getConfigurationAliases() {
            if (configurationAliases instanceof SdkAutoConstructMap) {
                return null;
            }
            return configurationAliases;
        }

        public final void setConfigurationAliases(Map<String, ? extends Map<String, String>> configurationAliases) {
            this.configurationAliases = ConfigurationAliasesResponseCopier.copy(configurationAliases);
        }

        @Override
        public final Builder configurationAliases(Map<String, ? extends Map<String, String>> configurationAliases) {
            this.configurationAliases = ConfigurationAliasesResponseCopier.copy(configurationAliases);
            return this;
        }

        public final DashConfiguration.Builder getDashConfiguration() {
            return dashConfiguration != null ? dashConfiguration.toBuilder() : null;
        }

        public final void setDashConfiguration(DashConfiguration.BuilderImpl dashConfiguration) {
            this.dashConfiguration = dashConfiguration != null ? dashConfiguration.build() : null;
        }

        @Override
        public final Builder dashConfiguration(DashConfiguration dashConfiguration) {
            this.dashConfiguration = dashConfiguration;
            return this;
        }

        public final HlsConfiguration.Builder getHlsConfiguration() {
            return hlsConfiguration != null ? hlsConfiguration.toBuilder() : null;
        }

        public final void setHlsConfiguration(HlsConfiguration.BuilderImpl hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration != null ? hlsConfiguration.build() : null;
        }

        @Override
        public final Builder hlsConfiguration(HlsConfiguration hlsConfiguration) {
            this.hlsConfiguration = hlsConfiguration;
            return this;
        }

        public final LivePreRollConfiguration.Builder getLivePreRollConfiguration() {
            return livePreRollConfiguration != null ? livePreRollConfiguration.toBuilder() : null;
        }

        public final void setLivePreRollConfiguration(LivePreRollConfiguration.BuilderImpl livePreRollConfiguration) {
            this.livePreRollConfiguration = livePreRollConfiguration != null ? livePreRollConfiguration.build() : null;
        }

        @Override
        public final Builder livePreRollConfiguration(LivePreRollConfiguration livePreRollConfiguration) {
            this.livePreRollConfiguration = livePreRollConfiguration;
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return logConfiguration != null ? logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final ManifestProcessingRules.Builder getManifestProcessingRules() {
            return manifestProcessingRules != null ? manifestProcessingRules.toBuilder() : null;
        }

        public final void setManifestProcessingRules(ManifestProcessingRules.BuilderImpl manifestProcessingRules) {
            this.manifestProcessingRules = manifestProcessingRules != null ? manifestProcessingRules.build() : null;
        }

        @Override
        public final Builder manifestProcessingRules(ManifestProcessingRules manifestProcessingRules) {
            this.manifestProcessingRules = manifestProcessingRules;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getPersonalizationThresholdSeconds() {
            return personalizationThresholdSeconds;
        }

        public final void setPersonalizationThresholdSeconds(Integer personalizationThresholdSeconds) {
            this.personalizationThresholdSeconds = personalizationThresholdSeconds;
        }

        @Override
        public final Builder personalizationThresholdSeconds(Integer personalizationThresholdSeconds) {
            this.personalizationThresholdSeconds = personalizationThresholdSeconds;
            return this;
        }

        public final String getPlaybackConfigurationArn() {
            return playbackConfigurationArn;
        }

        public final void setPlaybackConfigurationArn(String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
        }

        @Override
        public final Builder playbackConfigurationArn(String playbackConfigurationArn) {
            this.playbackConfigurationArn = playbackConfigurationArn;
            return this;
        }

        public final String getPlaybackEndpointPrefix() {
            return playbackEndpointPrefix;
        }

        public final void setPlaybackEndpointPrefix(String playbackEndpointPrefix) {
            this.playbackEndpointPrefix = playbackEndpointPrefix;
        }

        @Override
        public final Builder playbackEndpointPrefix(String playbackEndpointPrefix) {
            this.playbackEndpointPrefix = playbackEndpointPrefix;
            return this;
        }

        public final String getSessionInitializationEndpointPrefix() {
            return sessionInitializationEndpointPrefix;
        }

        public final void setSessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix) {
            this.sessionInitializationEndpointPrefix = sessionInitializationEndpointPrefix;
        }

        @Override
        public final Builder sessionInitializationEndpointPrefix(String sessionInitializationEndpointPrefix) {
            this.sessionInitializationEndpointPrefix = sessionInitializationEndpointPrefix;
            return this;
        }

        public final String getSlateAdUrl() {
            return slateAdUrl;
        }

        public final void setSlateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
        }

        @Override
        public final Builder slateAdUrl(String slateAdUrl) {
            this.slateAdUrl = slateAdUrl;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getTranscodeProfileName() {
            return transcodeProfileName;
        }

        public final void setTranscodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
        }

        @Override
        public final Builder transcodeProfileName(String transcodeProfileName) {
            this.transcodeProfileName = transcodeProfileName;
            return this;
        }

        public final String getVideoContentSourceUrl() {
            return videoContentSourceUrl;
        }

        public final void setVideoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
        }

        @Override
        public final Builder videoContentSourceUrl(String videoContentSourceUrl) {
            this.videoContentSourceUrl = videoContentSourceUrl;
            return this;
        }

        @Override
        public PutPlaybackConfigurationResponse build() {
            return new PutPlaybackConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
