/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output configuration for this channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestOutputItem implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestOutputItem.Builder, RequestOutputItem> {
    private static final SdkField<DashPlaylistSettings> DASH_PLAYLIST_SETTINGS_FIELD = SdkField
            .<DashPlaylistSettings> builder(MarshallingType.SDK_POJO).memberName("DashPlaylistSettings")
            .getter(getter(RequestOutputItem::dashPlaylistSettings)).setter(setter(Builder::dashPlaylistSettings))
            .constructor(DashPlaylistSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashPlaylistSettings").build())
            .build();

    private static final SdkField<HlsPlaylistSettings> HLS_PLAYLIST_SETTINGS_FIELD = SdkField
            .<HlsPlaylistSettings> builder(MarshallingType.SDK_POJO).memberName("HlsPlaylistSettings")
            .getter(getter(RequestOutputItem::hlsPlaylistSettings)).setter(setter(Builder::hlsPlaylistSettings))
            .constructor(HlsPlaylistSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsPlaylistSettings").build())
            .build();

    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ManifestName").getter(getter(RequestOutputItem::manifestName)).setter(setter(Builder::manifestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()).build();

    private static final SdkField<String> SOURCE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceGroup").getter(getter(RequestOutputItem::sourceGroup)).setter(setter(Builder::sourceGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASH_PLAYLIST_SETTINGS_FIELD,
            HLS_PLAYLIST_SETTINGS_FIELD, MANIFEST_NAME_FIELD, SOURCE_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final DashPlaylistSettings dashPlaylistSettings;

    private final HlsPlaylistSettings hlsPlaylistSettings;

    private final String manifestName;

    private final String sourceGroup;

    private RequestOutputItem(BuilderImpl builder) {
        this.dashPlaylistSettings = builder.dashPlaylistSettings;
        this.hlsPlaylistSettings = builder.hlsPlaylistSettings;
        this.manifestName = builder.manifestName;
        this.sourceGroup = builder.sourceGroup;
    }

    /**
     * <p>
     * DASH manifest configuration parameters.
     * </p>
     * 
     * @return DASH manifest configuration parameters.
     */
    public final DashPlaylistSettings dashPlaylistSettings() {
        return dashPlaylistSettings;
    }

    /**
     * <p>
     * HLS playlist configuration parameters.
     * </p>
     * 
     * @return HLS playlist configuration parameters.
     */
    public final HlsPlaylistSettings hlsPlaylistSettings() {
        return hlsPlaylistSettings;
    }

    /**
     * <p>
     * The name of the manifest for the channel. The name appears in the PlaybackUrl.
     * </p>
     * 
     * @return The name of the manifest for the channel. The name appears in the PlaybackUrl.
     */
    public final String manifestName() {
        return manifestName;
    }

    /**
     * <p>
     * A string used to match which HttpPackageConfiguration is used for each VodSource.
     * </p>
     * 
     * @return A string used to match which HttpPackageConfiguration is used for each VodSource.
     */
    public final String sourceGroup() {
        return sourceGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashPlaylistSettings());
        hashCode = 31 * hashCode + Objects.hashCode(hlsPlaylistSettings());
        hashCode = 31 * hashCode + Objects.hashCode(manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestOutputItem)) {
            return false;
        }
        RequestOutputItem other = (RequestOutputItem) obj;
        return Objects.equals(dashPlaylistSettings(), other.dashPlaylistSettings())
                && Objects.equals(hlsPlaylistSettings(), other.hlsPlaylistSettings())
                && Objects.equals(manifestName(), other.manifestName()) && Objects.equals(sourceGroup(), other.sourceGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestOutputItem").add("DashPlaylistSettings", dashPlaylistSettings())
                .add("HlsPlaylistSettings", hlsPlaylistSettings()).add("ManifestName", manifestName())
                .add("SourceGroup", sourceGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashPlaylistSettings":
            return Optional.ofNullable(clazz.cast(dashPlaylistSettings()));
        case "HlsPlaylistSettings":
            return Optional.ofNullable(clazz.cast(hlsPlaylistSettings()));
        case "ManifestName":
            return Optional.ofNullable(clazz.cast(manifestName()));
        case "SourceGroup":
            return Optional.ofNullable(clazz.cast(sourceGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestOutputItem, T> g) {
        return obj -> g.apply((RequestOutputItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestOutputItem> {
        /**
         * <p>
         * DASH manifest configuration parameters.
         * </p>
         * 
         * @param dashPlaylistSettings
         *        DASH manifest configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashPlaylistSettings(DashPlaylistSettings dashPlaylistSettings);

        /**
         * <p>
         * DASH manifest configuration parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashPlaylistSettings.Builder} avoiding
         * the need to create one manually via {@link DashPlaylistSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashPlaylistSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dashPlaylistSettings(DashPlaylistSettings)}.
         * 
         * @param dashPlaylistSettings
         *        a consumer that will call methods on {@link DashPlaylistSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashPlaylistSettings(DashPlaylistSettings)
         */
        default Builder dashPlaylistSettings(Consumer<DashPlaylistSettings.Builder> dashPlaylistSettings) {
            return dashPlaylistSettings(DashPlaylistSettings.builder().applyMutation(dashPlaylistSettings).build());
        }

        /**
         * <p>
         * HLS playlist configuration parameters.
         * </p>
         * 
         * @param hlsPlaylistSettings
         *        HLS playlist configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsPlaylistSettings(HlsPlaylistSettings hlsPlaylistSettings);

        /**
         * <p>
         * HLS playlist configuration parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link HlsPlaylistSettings.Builder} avoiding the
         * need to create one manually via {@link HlsPlaylistSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HlsPlaylistSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #hlsPlaylistSettings(HlsPlaylistSettings)}.
         * 
         * @param hlsPlaylistSettings
         *        a consumer that will call methods on {@link HlsPlaylistSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hlsPlaylistSettings(HlsPlaylistSettings)
         */
        default Builder hlsPlaylistSettings(Consumer<HlsPlaylistSettings.Builder> hlsPlaylistSettings) {
            return hlsPlaylistSettings(HlsPlaylistSettings.builder().applyMutation(hlsPlaylistSettings).build());
        }

        /**
         * <p>
         * The name of the manifest for the channel. The name appears in the PlaybackUrl.
         * </p>
         * 
         * @param manifestName
         *        The name of the manifest for the channel. The name appears in the PlaybackUrl.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestName(String manifestName);

        /**
         * <p>
         * A string used to match which HttpPackageConfiguration is used for each VodSource.
         * </p>
         * 
         * @param sourceGroup
         *        A string used to match which HttpPackageConfiguration is used for each VodSource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceGroup(String sourceGroup);
    }

    static final class BuilderImpl implements Builder {
        private DashPlaylistSettings dashPlaylistSettings;

        private HlsPlaylistSettings hlsPlaylistSettings;

        private String manifestName;

        private String sourceGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestOutputItem model) {
            dashPlaylistSettings(model.dashPlaylistSettings);
            hlsPlaylistSettings(model.hlsPlaylistSettings);
            manifestName(model.manifestName);
            sourceGroup(model.sourceGroup);
        }

        public final DashPlaylistSettings.Builder getDashPlaylistSettings() {
            return dashPlaylistSettings != null ? dashPlaylistSettings.toBuilder() : null;
        }

        public final void setDashPlaylistSettings(DashPlaylistSettings.BuilderImpl dashPlaylistSettings) {
            this.dashPlaylistSettings = dashPlaylistSettings != null ? dashPlaylistSettings.build() : null;
        }

        @Override
        public final Builder dashPlaylistSettings(DashPlaylistSettings dashPlaylistSettings) {
            this.dashPlaylistSettings = dashPlaylistSettings;
            return this;
        }

        public final HlsPlaylistSettings.Builder getHlsPlaylistSettings() {
            return hlsPlaylistSettings != null ? hlsPlaylistSettings.toBuilder() : null;
        }

        public final void setHlsPlaylistSettings(HlsPlaylistSettings.BuilderImpl hlsPlaylistSettings) {
            this.hlsPlaylistSettings = hlsPlaylistSettings != null ? hlsPlaylistSettings.build() : null;
        }

        @Override
        public final Builder hlsPlaylistSettings(HlsPlaylistSettings hlsPlaylistSettings) {
            this.hlsPlaylistSettings = hlsPlaylistSettings;
            return this;
        }

        public final String getManifestName() {
            return manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getSourceGroup() {
            return sourceGroup;
        }

        public final void setSourceGroup(String sourceGroup) {
            this.sourceGroup = sourceGroup;
        }

        @Override
        public final Builder sourceGroup(String sourceGroup) {
            this.sourceGroup = sourceGroup;
            return this;
        }

        @Override
        public RequestOutputItem build() {
            return new RequestOutputItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
