/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties for a schedule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduleEntry implements SdkPojo, Serializable, ToCopyableBuilder<ScheduleEntry.Builder, ScheduleEntry> {
    private static final SdkField<Long> APPROXIMATE_DURATION_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("ApproximateDurationSeconds")
            .getter(getter(ScheduleEntry::approximateDurationSeconds))
            .setter(setter(Builder::approximateDurationSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateDurationSeconds").build())
            .build();

    private static final SdkField<Instant> APPROXIMATE_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApproximateStartTime")
            .getter(getter(ScheduleEntry::approximateStartTime))
            .setter(setter(Builder::approximateStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ScheduleEntry::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(ScheduleEntry::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LiveSourceName").getter(getter(ScheduleEntry::liveSourceName)).setter(setter(Builder::liveSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSourceName").build()).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(ScheduleEntry::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramName").build()).build();

    private static final SdkField<List<ScheduleAdBreak>> SCHEDULE_AD_BREAKS_FIELD = SdkField
            .<List<ScheduleAdBreak>> builder(MarshallingType.LIST)
            .memberName("ScheduleAdBreaks")
            .getter(getter(ScheduleEntry::scheduleAdBreaks))
            .setter(setter(Builder::scheduleAdBreaks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleAdBreaks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScheduleAdBreak> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduleAdBreak::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULE_ENTRY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleEntryType").getter(getter(ScheduleEntry::scheduleEntryTypeAsString))
            .setter(setter(Builder::scheduleEntryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleEntryType").build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(ScheduleEntry::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(ScheduleEntry::vodSourceName)).setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROXIMATE_DURATION_SECONDS_FIELD, APPROXIMATE_START_TIME_FIELD, ARN_FIELD, CHANNEL_NAME_FIELD,
            LIVE_SOURCE_NAME_FIELD, PROGRAM_NAME_FIELD, SCHEDULE_AD_BREAKS_FIELD, SCHEDULE_ENTRY_TYPE_FIELD,
            SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long approximateDurationSeconds;

    private final Instant approximateStartTime;

    private final String arn;

    private final String channelName;

    private final String liveSourceName;

    private final String programName;

    private final List<ScheduleAdBreak> scheduleAdBreaks;

    private final String scheduleEntryType;

    private final String sourceLocationName;

    private final String vodSourceName;

    private ScheduleEntry(BuilderImpl builder) {
        this.approximateDurationSeconds = builder.approximateDurationSeconds;
        this.approximateStartTime = builder.approximateStartTime;
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.liveSourceName = builder.liveSourceName;
        this.programName = builder.programName;
        this.scheduleAdBreaks = builder.scheduleAdBreaks;
        this.scheduleEntryType = builder.scheduleEntryType;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    /**
     * <p>
     * The approximate duration of this program, in seconds.
     * </p>
     * 
     * @return The approximate duration of this program, in seconds.
     */
    public final Long approximateDurationSeconds() {
        return approximateDurationSeconds;
    }

    /**
     * <p>
     * The approximate time that the program will start playing.
     * </p>
     * 
     * @return The approximate time that the program will start playing.
     */
    public final Instant approximateStartTime() {
        return approximateStartTime;
    }

    /**
     * <p>
     * The ARN of the program.
     * </p>
     * 
     * @return The ARN of the program.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the channel that uses this schedule.
     * </p>
     * 
     * @return The name of the channel that uses this schedule.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The name of the live source used for the program.
     * </p>
     * 
     * @return The name of the live source used for the program.
     */
    public final String liveSourceName() {
        return liveSourceName;
    }

    /**
     * <p>
     * The name of the program.
     * </p>
     * 
     * @return The name of the program.
     */
    public final String programName() {
        return programName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScheduleAdBreaks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScheduleAdBreaks() {
        return scheduleAdBreaks != null && !(scheduleAdBreaks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The schedule's ad break properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScheduleAdBreaks} method.
     * </p>
     * 
     * @return The schedule's ad break properties.
     */
    public final List<ScheduleAdBreak> scheduleAdBreaks() {
        return scheduleAdBreaks;
    }

    /**
     * <p>
     * The type of schedule entry.
     * </p>
     * <p>
     * Valid values: PROGRAM or FILLER_SLATE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleEntryType}
     * will return {@link ScheduleEntryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scheduleEntryTypeAsString}.
     * </p>
     * 
     * @return The type of schedule entry.</p>
     *         <p>
     *         Valid values: PROGRAM or FILLER_SLATE.
     * @see ScheduleEntryType
     */
    public final ScheduleEntryType scheduleEntryType() {
        return ScheduleEntryType.fromValue(scheduleEntryType);
    }

    /**
     * <p>
     * The type of schedule entry.
     * </p>
     * <p>
     * Valid values: PROGRAM or FILLER_SLATE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleEntryType}
     * will return {@link ScheduleEntryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scheduleEntryTypeAsString}.
     * </p>
     * 
     * @return The type of schedule entry.</p>
     *         <p>
     *         Valid values: PROGRAM or FILLER_SLATE.
     * @see ScheduleEntryType
     */
    public final String scheduleEntryTypeAsString() {
        return scheduleEntryType;
    }

    /**
     * <p>
     * The name of the source location.
     * </p>
     * 
     * @return The name of the source location.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * <p>
     * The name of the VOD source.
     * </p>
     * 
     * @return The name of the VOD source.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approximateDurationSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(approximateStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        hashCode = 31 * hashCode + Objects.hashCode(hasScheduleAdBreaks() ? scheduleAdBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduleEntryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduleEntry)) {
            return false;
        }
        ScheduleEntry other = (ScheduleEntry) obj;
        return Objects.equals(approximateDurationSeconds(), other.approximateDurationSeconds())
                && Objects.equals(approximateStartTime(), other.approximateStartTime()) && Objects.equals(arn(), other.arn())
                && Objects.equals(channelName(), other.channelName()) && Objects.equals(liveSourceName(), other.liveSourceName())
                && Objects.equals(programName(), other.programName()) && hasScheduleAdBreaks() == other.hasScheduleAdBreaks()
                && Objects.equals(scheduleAdBreaks(), other.scheduleAdBreaks())
                && Objects.equals(scheduleEntryTypeAsString(), other.scheduleEntryTypeAsString())
                && Objects.equals(sourceLocationName(), other.sourceLocationName())
                && Objects.equals(vodSourceName(), other.vodSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduleEntry").add("ApproximateDurationSeconds", approximateDurationSeconds())
                .add("ApproximateStartTime", approximateStartTime()).add("Arn", arn()).add("ChannelName", channelName())
                .add("LiveSourceName", liveSourceName()).add("ProgramName", programName())
                .add("ScheduleAdBreaks", hasScheduleAdBreaks() ? scheduleAdBreaks() : null)
                .add("ScheduleEntryType", scheduleEntryTypeAsString()).add("SourceLocationName", sourceLocationName())
                .add("VodSourceName", vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApproximateDurationSeconds":
            return Optional.ofNullable(clazz.cast(approximateDurationSeconds()));
        case "ApproximateStartTime":
            return Optional.ofNullable(clazz.cast(approximateStartTime()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "LiveSourceName":
            return Optional.ofNullable(clazz.cast(liveSourceName()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        case "ScheduleAdBreaks":
            return Optional.ofNullable(clazz.cast(scheduleAdBreaks()));
        case "ScheduleEntryType":
            return Optional.ofNullable(clazz.cast(scheduleEntryTypeAsString()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduleEntry, T> g) {
        return obj -> g.apply((ScheduleEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduleEntry> {
        /**
         * <p>
         * The approximate duration of this program, in seconds.
         * </p>
         * 
         * @param approximateDurationSeconds
         *        The approximate duration of this program, in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateDurationSeconds(Long approximateDurationSeconds);

        /**
         * <p>
         * The approximate time that the program will start playing.
         * </p>
         * 
         * @param approximateStartTime
         *        The approximate time that the program will start playing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateStartTime(Instant approximateStartTime);

        /**
         * <p>
         * The ARN of the program.
         * </p>
         * 
         * @param arn
         *        The ARN of the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the channel that uses this schedule.
         * </p>
         * 
         * @param channelName
         *        The name of the channel that uses this schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The name of the live source used for the program.
         * </p>
         * 
         * @param liveSourceName
         *        The name of the live source used for the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveSourceName(String liveSourceName);

        /**
         * <p>
         * The name of the program.
         * </p>
         * 
         * @param programName
         *        The name of the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        /**
         * <p>
         * The schedule's ad break properties.
         * </p>
         * 
         * @param scheduleAdBreaks
         *        The schedule's ad break properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleAdBreaks(Collection<ScheduleAdBreak> scheduleAdBreaks);

        /**
         * <p>
         * The schedule's ad break properties.
         * </p>
         * 
         * @param scheduleAdBreaks
         *        The schedule's ad break properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleAdBreaks(ScheduleAdBreak... scheduleAdBreaks);

        /**
         * <p>
         * The schedule's ad break properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak.Builder#build()} is called
         * immediately and its result is passed to {@link #scheduleAdBreaks(List<ScheduleAdBreak>)}.
         * 
         * @param scheduleAdBreaks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.ScheduleAdBreak.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleAdBreaks(java.util.Collection<ScheduleAdBreak>)
         */
        Builder scheduleAdBreaks(Consumer<ScheduleAdBreak.Builder>... scheduleAdBreaks);

        /**
         * <p>
         * The type of schedule entry.
         * </p>
         * <p>
         * Valid values: PROGRAM or FILLER_SLATE.
         * </p>
         * 
         * @param scheduleEntryType
         *        The type of schedule entry.</p>
         *        <p>
         *        Valid values: PROGRAM or FILLER_SLATE.
         * @see ScheduleEntryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleEntryType
         */
        Builder scheduleEntryType(String scheduleEntryType);

        /**
         * <p>
         * The type of schedule entry.
         * </p>
         * <p>
         * Valid values: PROGRAM or FILLER_SLATE.
         * </p>
         * 
         * @param scheduleEntryType
         *        The type of schedule entry.</p>
         *        <p>
         *        Valid values: PROGRAM or FILLER_SLATE.
         * @see ScheduleEntryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleEntryType
         */
        Builder scheduleEntryType(ScheduleEntryType scheduleEntryType);

        /**
         * <p>
         * The name of the source location.
         * </p>
         * 
         * @param sourceLocationName
         *        The name of the source location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The name of the VOD source.
         * </p>
         * 
         * @param vodSourceName
         *        The name of the VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);
    }

    static final class BuilderImpl implements Builder {
        private Long approximateDurationSeconds;

        private Instant approximateStartTime;

        private String arn;

        private String channelName;

        private String liveSourceName;

        private String programName;

        private List<ScheduleAdBreak> scheduleAdBreaks = DefaultSdkAutoConstructList.getInstance();

        private String scheduleEntryType;

        private String sourceLocationName;

        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduleEntry model) {
            approximateDurationSeconds(model.approximateDurationSeconds);
            approximateStartTime(model.approximateStartTime);
            arn(model.arn);
            channelName(model.channelName);
            liveSourceName(model.liveSourceName);
            programName(model.programName);
            scheduleAdBreaks(model.scheduleAdBreaks);
            scheduleEntryType(model.scheduleEntryType);
            sourceLocationName(model.sourceLocationName);
            vodSourceName(model.vodSourceName);
        }

        public final Long getApproximateDurationSeconds() {
            return approximateDurationSeconds;
        }

        public final void setApproximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
        }

        @Override
        public final Builder approximateDurationSeconds(Long approximateDurationSeconds) {
            this.approximateDurationSeconds = approximateDurationSeconds;
            return this;
        }

        public final Instant getApproximateStartTime() {
            return approximateStartTime;
        }

        public final void setApproximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
        }

        @Override
        public final Builder approximateStartTime(Instant approximateStartTime) {
            this.approximateStartTime = approximateStartTime;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getLiveSourceName() {
            return liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final String getProgramName() {
            return programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final List<ScheduleAdBreak.Builder> getScheduleAdBreaks() {
            List<ScheduleAdBreak.Builder> result = ___listOfScheduleAdBreakCopier.copyToBuilder(this.scheduleAdBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScheduleAdBreaks(Collection<ScheduleAdBreak.BuilderImpl> scheduleAdBreaks) {
            this.scheduleAdBreaks = ___listOfScheduleAdBreakCopier.copyFromBuilder(scheduleAdBreaks);
        }

        @Override
        public final Builder scheduleAdBreaks(Collection<ScheduleAdBreak> scheduleAdBreaks) {
            this.scheduleAdBreaks = ___listOfScheduleAdBreakCopier.copy(scheduleAdBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleAdBreaks(ScheduleAdBreak... scheduleAdBreaks) {
            scheduleAdBreaks(Arrays.asList(scheduleAdBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scheduleAdBreaks(Consumer<ScheduleAdBreak.Builder>... scheduleAdBreaks) {
            scheduleAdBreaks(Stream.of(scheduleAdBreaks).map(c -> ScheduleAdBreak.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getScheduleEntryType() {
            return scheduleEntryType;
        }

        public final void setScheduleEntryType(String scheduleEntryType) {
            this.scheduleEntryType = scheduleEntryType;
        }

        @Override
        public final Builder scheduleEntryType(String scheduleEntryType) {
            this.scheduleEntryType = scheduleEntryType;
            return this;
        }

        @Override
        public final Builder scheduleEntryType(ScheduleEntryType scheduleEntryType) {
            this.scheduleEntryType(scheduleEntryType == null ? null : scheduleEntryType.toString());
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        @Override
        public ScheduleEntry build() {
            return new ScheduleEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
