/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for manifest processing rules. Manifest processing rules enable customization of the personalized
 * manifests created by MediaTailor.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManifestProcessingRules implements SdkPojo, Serializable,
        ToCopyableBuilder<ManifestProcessingRules.Builder, ManifestProcessingRules> {
    private static final SdkField<AdMarkerPassthrough> AD_MARKER_PASSTHROUGH_FIELD = SdkField
            .<AdMarkerPassthrough> builder(MarshallingType.SDK_POJO).memberName("AdMarkerPassthrough")
            .getter(getter(ManifestProcessingRules::adMarkerPassthrough)).setter(setter(Builder::adMarkerPassthrough))
            .constructor(AdMarkerPassthrough::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdMarkerPassthrough").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKER_PASSTHROUGH_FIELD));

    private static final long serialVersionUID = 1L;

    private final AdMarkerPassthrough adMarkerPassthrough;

    private ManifestProcessingRules(BuilderImpl builder) {
        this.adMarkerPassthrough = builder.adMarkerPassthrough;
    }

    /**
     * <p>
     * For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and EXT-X-SPLICEPOINT-SCTE35
     * ad markers from the origin manifest to the MediaTailor personalized manifest.
     * </p>
     * <p>
     * No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are filled
     * for that ad break, MediaTailor will not set the value to 0.
     * </p>
     * 
     * @return For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and
     *         EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized
     *         manifest.</p>
     *         <p>
     *         No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are
     *         filled for that ad break, MediaTailor will not set the value to 0.
     */
    public final AdMarkerPassthrough adMarkerPassthrough() {
        return adMarkerPassthrough;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adMarkerPassthrough());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManifestProcessingRules)) {
            return false;
        }
        ManifestProcessingRules other = (ManifestProcessingRules) obj;
        return Objects.equals(adMarkerPassthrough(), other.adMarkerPassthrough());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManifestProcessingRules").add("AdMarkerPassthrough", adMarkerPassthrough()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkerPassthrough":
            return Optional.ofNullable(clazz.cast(adMarkerPassthrough()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ManifestProcessingRules, T> g) {
        return obj -> g.apply((ManifestProcessingRules) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManifestProcessingRules> {
        /**
         * <p>
         * For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and
         * EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest.
         * </p>
         * <p>
         * No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are
         * filled for that ad break, MediaTailor will not set the value to 0.
         * </p>
         * 
         * @param adMarkerPassthrough
         *        For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and
         *        EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized
         *        manifest.</p>
         *        <p>
         *        No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads
         *        are filled for that ad break, MediaTailor will not set the value to 0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkerPassthrough(AdMarkerPassthrough adMarkerPassthrough);

        /**
         * <p>
         * For HLS, when set to true, MediaTailor passes through EXT-X-CUE-IN, EXT-X-CUE-OUT, and
         * EXT-X-SPLICEPOINT-SCTE35 ad markers from the origin manifest to the MediaTailor personalized manifest.
         * </p>
         * <p>
         * No logic is applied to these ad markers. For example, if EXT-X-CUE-OUT has a value of 60, but no ads are
         * filled for that ad break, MediaTailor will not set the value to 0.
         * </p>
         * This is a convenience method that creates an instance of the {@link AdMarkerPassthrough.Builder} avoiding the
         * need to create one manually via {@link AdMarkerPassthrough#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AdMarkerPassthrough.Builder#build()} is called immediately and
         * its result is passed to {@link #adMarkerPassthrough(AdMarkerPassthrough)}.
         * 
         * @param adMarkerPassthrough
         *        a consumer that will call methods on {@link AdMarkerPassthrough.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adMarkerPassthrough(AdMarkerPassthrough)
         */
        default Builder adMarkerPassthrough(Consumer<AdMarkerPassthrough.Builder> adMarkerPassthrough) {
            return adMarkerPassthrough(AdMarkerPassthrough.builder().applyMutation(adMarkerPassthrough).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AdMarkerPassthrough adMarkerPassthrough;

        private BuilderImpl() {
        }

        private BuilderImpl(ManifestProcessingRules model) {
            adMarkerPassthrough(model.adMarkerPassthrough);
        }

        public final AdMarkerPassthrough.Builder getAdMarkerPassthrough() {
            return adMarkerPassthrough != null ? adMarkerPassthrough.toBuilder() : null;
        }

        public final void setAdMarkerPassthrough(AdMarkerPassthrough.BuilderImpl adMarkerPassthrough) {
            this.adMarkerPassthrough = adMarkerPassthrough != null ? adMarkerPassthrough.build() : null;
        }

        @Override
        public final Builder adMarkerPassthrough(AdMarkerPassthrough adMarkerPassthrough) {
            this.adMarkerPassthrough = adMarkerPassthrough;
            return this;
        }

        @Override
        public ManifestProcessingRules build() {
            return new ManifestProcessingRules(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
