/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLiveSourceRequest extends MediaTailorRequest implements
        ToCopyableBuilder<UpdateLiveSourceRequest.Builder, UpdateLiveSourceRequest> {
    private static final SdkField<List<HttpPackageConfiguration>> HTTP_PACKAGE_CONFIGURATIONS_FIELD = SdkField
            .<List<HttpPackageConfiguration>> builder(MarshallingType.LIST)
            .memberName("HttpPackageConfigurations")
            .getter(getter(UpdateLiveSourceRequest::httpPackageConfigurations))
            .setter(setter(Builder::httpPackageConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPackageConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpPackageConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpPackageConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LiveSourceName").getter(getter(UpdateLiveSourceRequest::liveSourceName))
            .setter(setter(Builder::liveSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("liveSourceName").build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(UpdateLiveSourceRequest::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceLocationName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            HTTP_PACKAGE_CONFIGURATIONS_FIELD, LIVE_SOURCE_NAME_FIELD, SOURCE_LOCATION_NAME_FIELD));

    private final List<HttpPackageConfiguration> httpPackageConfigurations;

    private final String liveSourceName;

    private final String sourceLocationName;

    private UpdateLiveSourceRequest(BuilderImpl builder) {
        super(builder);
        this.httpPackageConfigurations = builder.httpPackageConfigurations;
        this.liveSourceName = builder.liveSourceName;
        this.sourceLocationName = builder.sourceLocationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the HttpPackageConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHttpPackageConfigurations() {
        return httpPackageConfigurations != null && !(httpPackageConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of HTTP package configurations for the live source on this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHttpPackageConfigurations} method.
     * </p>
     * 
     * @return A list of HTTP package configurations for the live source on this account.
     */
    public final List<HttpPackageConfiguration> httpPackageConfigurations() {
        return httpPackageConfigurations;
    }

    /**
     * <p>
     * The identifier for the live source you are working on.
     * </p>
     * 
     * @return The identifier for the live source you are working on.
     */
    public final String liveSourceName() {
        return liveSourceName;
    }

    /**
     * <p>
     * The identifier for the source location you are working on.
     * </p>
     * 
     * @return The identifier for the source location you are working on.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHttpPackageConfigurations() ? httpPackageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLiveSourceRequest)) {
            return false;
        }
        UpdateLiveSourceRequest other = (UpdateLiveSourceRequest) obj;
        return hasHttpPackageConfigurations() == other.hasHttpPackageConfigurations()
                && Objects.equals(httpPackageConfigurations(), other.httpPackageConfigurations())
                && Objects.equals(liveSourceName(), other.liveSourceName())
                && Objects.equals(sourceLocationName(), other.sourceLocationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateLiveSourceRequest")
                .add("HttpPackageConfigurations", hasHttpPackageConfigurations() ? httpPackageConfigurations() : null)
                .add("LiveSourceName", liveSourceName()).add("SourceLocationName", sourceLocationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpPackageConfigurations":
            return Optional.ofNullable(clazz.cast(httpPackageConfigurations()));
        case "LiveSourceName":
            return Optional.ofNullable(clazz.cast(liveSourceName()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLiveSourceRequest, T> g) {
        return obj -> g.apply((UpdateLiveSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLiveSourceRequest> {
        /**
         * <p>
         * A list of HTTP package configurations for the live source on this account.
         * </p>
         * 
         * @param httpPackageConfigurations
         *        A list of HTTP package configurations for the live source on this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations);

        /**
         * <p>
         * A list of HTTP package configurations for the live source on this account.
         * </p>
         * 
         * @param httpPackageConfigurations
         *        A list of HTTP package configurations for the live source on this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPackageConfigurations(HttpPackageConfiguration... httpPackageConfigurations);

        /**
         * <p>
         * A list of HTTP package configurations for the live source on this account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #httpPackageConfigurations(List<HttpPackageConfiguration>)}.
         * 
         * @param httpPackageConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpPackageConfigurations(java.util.Collection<HttpPackageConfiguration>)
         */
        Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder>... httpPackageConfigurations);

        /**
         * <p>
         * The identifier for the live source you are working on.
         * </p>
         * 
         * @param liveSourceName
         *        The identifier for the live source you are working on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveSourceName(String liveSourceName);

        /**
         * <p>
         * The identifier for the source location you are working on.
         * </p>
         * 
         * @param sourceLocationName
         *        The identifier for the source location you are working on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private List<HttpPackageConfiguration> httpPackageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String liveSourceName;

        private String sourceLocationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLiveSourceRequest model) {
            super(model);
            httpPackageConfigurations(model.httpPackageConfigurations);
            liveSourceName(model.liveSourceName);
            sourceLocationName(model.sourceLocationName);
        }

        public final List<HttpPackageConfiguration.Builder> getHttpPackageConfigurations() {
            List<HttpPackageConfiguration.Builder> result = HttpPackageConfigurationsCopier
                    .copyToBuilder(this.httpPackageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHttpPackageConfigurations(Collection<HttpPackageConfiguration.BuilderImpl> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copyFromBuilder(httpPackageConfigurations);
        }

        @Override
        public final Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copy(httpPackageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(HttpPackageConfiguration... httpPackageConfigurations) {
            httpPackageConfigurations(Arrays.asList(httpPackageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder>... httpPackageConfigurations) {
            httpPackageConfigurations(Stream.of(httpPackageConfigurations)
                    .map(c -> HttpPackageConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getLiveSourceName() {
            return liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLiveSourceRequest build() {
            return new UpdateLiveSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
