/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for using a content delivery network (CDN), like Amazon CloudFront, for content and ad segment
 * management.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CdnConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CdnConfiguration.Builder, CdnConfiguration> {
    private static final SdkField<String> AD_SEGMENT_URL_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdSegmentUrlPrefix").getter(getter(CdnConfiguration::adSegmentUrlPrefix))
            .setter(setter(Builder::adSegmentUrlPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdSegmentUrlPrefix").build())
            .build();

    private static final SdkField<String> CONTENT_SEGMENT_URL_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContentSegmentUrlPrefix").getter(getter(CdnConfiguration::contentSegmentUrlPrefix))
            .setter(setter(Builder::contentSegmentUrlPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentSegmentUrlPrefix").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_SEGMENT_URL_PREFIX_FIELD,
            CONTENT_SEGMENT_URL_PREFIX_FIELD));

    private static final long serialVersionUID = 1L;

    private final String adSegmentUrlPrefix;

    private final String contentSegmentUrlPrefix;

    private CdnConfiguration(BuilderImpl builder) {
        this.adSegmentUrlPrefix = builder.adSegmentUrlPrefix;
        this.contentSegmentUrlPrefix = builder.contentSegmentUrlPrefix;
    }

    /**
     * <p>
     * A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses
     * Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create a
     * rule in your CDN for the origin ads.mediatailor.&amp;lt;region&gt;.amazonaws.com. Then specify the rule's name in
     * this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the source for
     * ad segments.
     * </p>
     * 
     * @return A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor
     *         uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate
     *         CDN, create a rule in your CDN for the origin ads.mediatailor.&amp;lt;region&gt;.amazonaws.com. Then
     *         specify the rule's name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it
     *         reports your CDN as the source for ad segments.
     */
    public final String adSegmentUrlPrefix() {
        return adSegmentUrlPrefix;
    }

    /**
     * <p>
     * A content delivery network (CDN) to cache content segments, so that content requests don’t always have to go to
     * the origin server. First, create a rule in your CDN for the content segment origin server. Then specify the
     * rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your
     * CDN as the source for content segments.
     * </p>
     * 
     * @return A content delivery network (CDN) to cache content segments, so that content requests don’t always have to
     *         go to the origin server. First, create a rule in your CDN for the content segment origin server. Then
     *         specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a
     *         manifest, it reports your CDN as the source for content segments.
     */
    public final String contentSegmentUrlPrefix() {
        return contentSegmentUrlPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(adSegmentUrlPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(contentSegmentUrlPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CdnConfiguration)) {
            return false;
        }
        CdnConfiguration other = (CdnConfiguration) obj;
        return Objects.equals(adSegmentUrlPrefix(), other.adSegmentUrlPrefix())
                && Objects.equals(contentSegmentUrlPrefix(), other.contentSegmentUrlPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CdnConfiguration").add("AdSegmentUrlPrefix", adSegmentUrlPrefix())
                .add("ContentSegmentUrlPrefix", contentSegmentUrlPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdSegmentUrlPrefix":
            return Optional.ofNullable(clazz.cast(adSegmentUrlPrefix()));
        case "ContentSegmentUrlPrefix":
            return Optional.ofNullable(clazz.cast(contentSegmentUrlPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CdnConfiguration, T> g) {
        return obj -> g.apply((CdnConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CdnConfiguration> {
        /**
         * <p>
         * A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental MediaTailor uses
         * Amazon CloudFront with default cache settings as its CDN for ad segments. To set up an alternate CDN, create
         * a rule in your CDN for the origin ads.mediatailor.&amp;lt;region&gt;.amazonaws.com. Then specify the rule's
         * name in this AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the
         * source for ad segments.
         * </p>
         * 
         * @param adSegmentUrlPrefix
         *        A non-default content delivery network (CDN) to serve ad segments. By default, AWS Elemental
         *        MediaTailor uses Amazon CloudFront with default cache settings as its CDN for ad segments. To set up
         *        an alternate CDN, create a rule in your CDN for the origin
         *        ads.mediatailor.&amp;lt;region&gt;.amazonaws.com. Then specify the rule's name in this
         *        AdSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports your CDN as the
         *        source for ad segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adSegmentUrlPrefix(String adSegmentUrlPrefix);

        /**
         * <p>
         * A content delivery network (CDN) to cache content segments, so that content requests don’t always have to go
         * to the origin server. First, create a rule in your CDN for the content segment origin server. Then specify
         * the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a manifest, it reports
         * your CDN as the source for content segments.
         * </p>
         * 
         * @param contentSegmentUrlPrefix
         *        A content delivery network (CDN) to cache content segments, so that content requests don’t always have
         *        to go to the origin server. First, create a rule in your CDN for the content segment origin server.
         *        Then specify the rule's name in this ContentSegmentUrlPrefix. When AWS Elemental MediaTailor serves a
         *        manifest, it reports your CDN as the source for content segments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentSegmentUrlPrefix(String contentSegmentUrlPrefix);
    }

    static final class BuilderImpl implements Builder {
        private String adSegmentUrlPrefix;

        private String contentSegmentUrlPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(CdnConfiguration model) {
            adSegmentUrlPrefix(model.adSegmentUrlPrefix);
            contentSegmentUrlPrefix(model.contentSegmentUrlPrefix);
        }

        public final String getAdSegmentUrlPrefix() {
            return adSegmentUrlPrefix;
        }

        public final void setAdSegmentUrlPrefix(String adSegmentUrlPrefix) {
            this.adSegmentUrlPrefix = adSegmentUrlPrefix;
        }

        @Override
        @Transient
        public final Builder adSegmentUrlPrefix(String adSegmentUrlPrefix) {
            this.adSegmentUrlPrefix = adSegmentUrlPrefix;
            return this;
        }

        public final String getContentSegmentUrlPrefix() {
            return contentSegmentUrlPrefix;
        }

        public final void setContentSegmentUrlPrefix(String contentSegmentUrlPrefix) {
            this.contentSegmentUrlPrefix = contentSegmentUrlPrefix;
        }

        @Override
        @Transient
        public final Builder contentSegmentUrlPrefix(String contentSegmentUrlPrefix) {
            this.contentSegmentUrlPrefix = contentSegmentUrlPrefix;
            return this;
        }

        @Override
        public CdnConfiguration build() {
            return new CdnConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
