/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPrefetchSchedulesRequest extends MediaTailorRequest implements
        ToCopyableBuilder<ListPrefetchSchedulesRequest.Builder, ListPrefetchSchedulesRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListPrefetchSchedulesRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPrefetchSchedulesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackConfigurationName").getter(getter(ListPrefetchSchedulesRequest::playbackConfigurationName))
            .setter(setter(Builder::playbackConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PlaybackConfigurationName").build())
            .build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(ListPrefetchSchedulesRequest::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, PLAYBACK_CONFIGURATION_NAME_FIELD, STREAM_ID_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String playbackConfigurationName;

    private final String streamId;

    private ListPrefetchSchedulesRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.playbackConfigurationName = builder.playbackConfigurationName;
        this.streamId = builder.streamId;
    }

    /**
     * <p>
     * The maximum number of prefetch schedules that you want MediaTailor to return in response to the current request.
     * If the playback configuration has more than MaxResults prefetch schedules, use the value of NextToken in the
     * response to get the next page of results.
     * </p>
     * 
     * @return The maximum number of prefetch schedules that you want MediaTailor to return in response to the current
     *         request. If the playback configuration has more than MaxResults prefetch schedules, use the value of
     *         NextToken in the response to get the next page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * (Optional) If the playback configuration has more than MaxResults prefetch schedules, use NextToken to get the
     * second and subsequent pages of results.
     * </p>
     * <p>
     * For the first ListPrefetchSchedulesRequest request, omit this value.
     * </p>
     * <p>
     * For the second and subsequent requests, get the value of NextToken from the previous response and specify that
     * value for NextToken in the request.
     * </p>
     * <p>
     * If the previous response didn't include a NextToken element, there are no more prefetch schedules to get.
     * </p>
     * 
     * @return (Optional) If the playback configuration has more than MaxResults prefetch schedules, use NextToken to
     *         get the second and subsequent pages of results.</p>
     *         <p>
     *         For the first ListPrefetchSchedulesRequest request, omit this value.
     *         </p>
     *         <p>
     *         For the second and subsequent requests, get the value of NextToken from the previous response and specify
     *         that value for NextToken in the request.
     *         </p>
     *         <p>
     *         If the previous response didn't include a NextToken element, there are no more prefetch schedules to get.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The name of the playback configuration.
     * </p>
     * 
     * @return The name of the playback configuration.
     */
    public final String playbackConfigurationName() {
        return playbackConfigurationName;
    }

    /**
     * <p>
     * An optional filtering parameter whereby MediaTailor filters the prefetch schedules to include only specific
     * streams.
     * </p>
     * 
     * @return An optional filtering parameter whereby MediaTailor filters the prefetch schedules to include only
     *         specific streams.
     */
    public final String streamId() {
        return streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrefetchSchedulesRequest)) {
            return false;
        }
        ListPrefetchSchedulesRequest other = (ListPrefetchSchedulesRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(playbackConfigurationName(), other.playbackConfigurationName())
                && Objects.equals(streamId(), other.streamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPrefetchSchedulesRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("PlaybackConfigurationName", playbackConfigurationName()).add("StreamId", streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PlaybackConfigurationName":
            return Optional.ofNullable(clazz.cast(playbackConfigurationName()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPrefetchSchedulesRequest, T> g) {
        return obj -> g.apply((ListPrefetchSchedulesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListPrefetchSchedulesRequest> {
        /**
         * <p>
         * The maximum number of prefetch schedules that you want MediaTailor to return in response to the current
         * request. If the playback configuration has more than MaxResults prefetch schedules, use the value of
         * NextToken in the response to get the next page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of prefetch schedules that you want MediaTailor to return in response to the
         *        current request. If the playback configuration has more than MaxResults prefetch schedules, use the
         *        value of NextToken in the response to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * (Optional) If the playback configuration has more than MaxResults prefetch schedules, use NextToken to get
         * the second and subsequent pages of results.
         * </p>
         * <p>
         * For the first ListPrefetchSchedulesRequest request, omit this value.
         * </p>
         * <p>
         * For the second and subsequent requests, get the value of NextToken from the previous response and specify
         * that value for NextToken in the request.
         * </p>
         * <p>
         * If the previous response didn't include a NextToken element, there are no more prefetch schedules to get.
         * </p>
         * 
         * @param nextToken
         *        (Optional) If the playback configuration has more than MaxResults prefetch schedules, use NextToken to
         *        get the second and subsequent pages of results.</p>
         *        <p>
         *        For the first ListPrefetchSchedulesRequest request, omit this value.
         *        </p>
         *        <p>
         *        For the second and subsequent requests, get the value of NextToken from the previous response and
         *        specify that value for NextToken in the request.
         *        </p>
         *        <p>
         *        If the previous response didn't include a NextToken element, there are no more prefetch schedules to
         *        get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The name of the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationName
         *        The name of the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationName(String playbackConfigurationName);

        /**
         * <p>
         * An optional filtering parameter whereby MediaTailor filters the prefetch schedules to include only specific
         * streams.
         * </p>
         * 
         * @param streamId
         *        An optional filtering parameter whereby MediaTailor filters the prefetch schedules to include only
         *        specific streams.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String playbackConfigurationName;

        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrefetchSchedulesRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            playbackConfigurationName(model.playbackConfigurationName);
            streamId(model.streamId);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        @Transient
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        @Transient
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPrefetchSchedulesRequest build() {
            return new ListPrefetchSchedulesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
