/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPrefetchScheduleRequest extends MediaTailorRequest implements
        ToCopyableBuilder<GetPrefetchScheduleRequest.Builder, GetPrefetchScheduleRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetPrefetchScheduleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Name").build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackConfigurationName").getter(getter(GetPrefetchScheduleRequest::playbackConfigurationName))
            .setter(setter(Builder::playbackConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("PlaybackConfigurationName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PLAYBACK_CONFIGURATION_NAME_FIELD));

    private final String name;

    private final String playbackConfigurationName;

    private GetPrefetchScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.playbackConfigurationName = builder.playbackConfigurationName;
    }

    /**
     * <p>
     * The identifier for the playback configuration.
     * </p>
     * 
     * @return The identifier for the playback configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of the playback configuration.
     * </p>
     * 
     * @return The name of the playback configuration.
     */
    public final String playbackConfigurationName() {
        return playbackConfigurationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPrefetchScheduleRequest)) {
            return false;
        }
        GetPrefetchScheduleRequest other = (GetPrefetchScheduleRequest) obj;
        return Objects.equals(name(), other.name())
                && Objects.equals(playbackConfigurationName(), other.playbackConfigurationName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPrefetchScheduleRequest").add("Name", name())
                .add("PlaybackConfigurationName", playbackConfigurationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PlaybackConfigurationName":
            return Optional.ofNullable(clazz.cast(playbackConfigurationName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPrefetchScheduleRequest, T> g) {
        return obj -> g.apply((GetPrefetchScheduleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetPrefetchScheduleRequest> {
        /**
         * <p>
         * The identifier for the playback configuration.
         * </p>
         * 
         * @param name
         *        The identifier for the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationName
         *        The name of the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationName(String playbackConfigurationName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private String name;

        private String playbackConfigurationName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPrefetchScheduleRequest model) {
            super(model);
            name(model.name);
            playbackConfigurationName(model.playbackConfigurationName);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        @Transient
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetPrefetchScheduleRequest build() {
            return new GetPrefetchScheduleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
