/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The HTTP package configuration properties for the requested VOD source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HttpPackageConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<HttpPackageConfiguration.Builder, HttpPackageConfiguration> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(HttpPackageConfiguration::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> SOURCE_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceGroup").getter(getter(HttpPackageConfiguration::sourceGroup)).setter(setter(Builder::sourceGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceGroup").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(HttpPackageConfiguration::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD,
            SOURCE_GROUP_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final String sourceGroup;

    private final String type;

    private HttpPackageConfiguration(BuilderImpl builder) {
        this.path = builder.path;
        this.sourceGroup = builder.sourceGroup;
        this.type = builder.type;
    }

    /**
     * <p>
     * The relative path to the URL for this VOD source. This is combined with
     * SourceLocation::HttpConfiguration::BaseUrl to form a valid URL.
     * </p>
     * 
     * @return The relative path to the URL for this VOD source. This is combined with
     *         SourceLocation::HttpConfiguration::BaseUrl to form a valid URL.
     */
    public final String path() {
        return path;
    }

    /**
     * <p>
     * The name of the source group. This has to match one of the Channel::Outputs::SourceGroup.
     * </p>
     * 
     * @return The name of the source group. This has to match one of the Channel::Outputs::SourceGroup.
     */
    public final String sourceGroup() {
        return sourceGroup;
    }

    /**
     * <p>
     * The streaming protocol for this package configuration. Supported values are HLS and DASH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The streaming protocol for this package configuration. Supported values are HLS and DASH.
     * @see Type
     */
    public final Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The streaming protocol for this package configuration. Supported values are HLS and DASH.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The streaming protocol for this package configuration. Supported values are HLS and DASH.
     * @see Type
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(sourceGroup());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpPackageConfiguration)) {
            return false;
        }
        HttpPackageConfiguration other = (HttpPackageConfiguration) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(sourceGroup(), other.sourceGroup())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HttpPackageConfiguration").add("Path", path()).add("SourceGroup", sourceGroup())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "SourceGroup":
            return Optional.ofNullable(clazz.cast(sourceGroup()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HttpPackageConfiguration, T> g) {
        return obj -> g.apply((HttpPackageConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HttpPackageConfiguration> {
        /**
         * <p>
         * The relative path to the URL for this VOD source. This is combined with
         * SourceLocation::HttpConfiguration::BaseUrl to form a valid URL.
         * </p>
         * 
         * @param path
         *        The relative path to the URL for this VOD source. This is combined with
         *        SourceLocation::HttpConfiguration::BaseUrl to form a valid URL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The name of the source group. This has to match one of the Channel::Outputs::SourceGroup.
         * </p>
         * 
         * @param sourceGroup
         *        The name of the source group. This has to match one of the Channel::Outputs::SourceGroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceGroup(String sourceGroup);

        /**
         * <p>
         * The streaming protocol for this package configuration. Supported values are HLS and DASH.
         * </p>
         * 
         * @param type
         *        The streaming protocol for this package configuration. Supported values are HLS and DASH.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The streaming protocol for this package configuration. Supported values are HLS and DASH.
         * </p>
         * 
         * @param type
         *        The streaming protocol for this package configuration. Supported values are HLS and DASH.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private String sourceGroup;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(HttpPackageConfiguration model) {
            path(model.path);
            sourceGroup(model.sourceGroup);
            type(model.type);
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getSourceGroup() {
            return sourceGroup;
        }

        public final void setSourceGroup(String sourceGroup) {
            this.sourceGroup = sourceGroup;
        }

        @Override
        @Transient
        public final Builder sourceGroup(String sourceGroup) {
            this.sourceGroup = sourceGroup;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public HttpPackageConfiguration build() {
            return new HttpPackageConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
