/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ___listOfAlertCopier {
    static List<Alert> copy(Collection<? extends Alert> __listOfAlertParam) {
        List<Alert> list;
        if (__listOfAlertParam == null || __listOfAlertParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Alert> modifiableList = new ArrayList<>();
            __listOfAlertParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Alert> copyFromBuilder(Collection<? extends Alert.Builder> __listOfAlertParam) {
        List<Alert> list;
        if (__listOfAlertParam == null || __listOfAlertParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Alert> modifiableList = new ArrayList<>();
            __listOfAlertParam.forEach(entry -> {
                Alert member = entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Alert.Builder> copyToBuilder(Collection<? extends Alert> __listOfAlertParam) {
        List<Alert.Builder> list;
        if (__listOfAlertParam == null || __listOfAlertParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Alert.Builder> modifiableList = new ArrayList<>();
            __listOfAlertParam.forEach(entry -> {
                Alert.Builder member = entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
