/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * HLS playlist configuration parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsPlaylistSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsPlaylistSettings.Builder, HlsPlaylistSettings> {
    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManifestWindowSeconds").getter(getter(HlsPlaylistSettings::manifestWindowSeconds))
            .setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(MANIFEST_WINDOW_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer manifestWindowSeconds;

    private HlsPlaylistSettings(BuilderImpl builder) {
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
    }

    /**
     * <p>
     * The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
     * <code>3600</code> seconds.
     * </p>
     * 
     * @return The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
     *         <code>3600</code> seconds.
     */
    public final Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsPlaylistSettings)) {
            return false;
        }
        HlsPlaylistSettings other = (HlsPlaylistSettings) obj;
        return Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsPlaylistSettings").add("ManifestWindowSeconds", manifestWindowSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsPlaylistSettings, T> g) {
        return obj -> g.apply((HlsPlaylistSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsPlaylistSettings> {
        /**
         * <p>
         * The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
         * <code>3600</code> seconds.
         * </p>
         * 
         * @param manifestWindowSeconds
         *        The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum
         *        value: <code>3600</code> seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer manifestWindowSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsPlaylistSettings model) {
            manifestWindowSeconds(model.manifestWindowSeconds);
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        @Override
        public HlsPlaylistSettings build() {
            return new HlsPlaylistSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
