/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * HLS playlist configuration parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HlsPlaylistSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<HlsPlaylistSettings.Builder, HlsPlaylistSettings> {
    private static final SdkField<List<String>> AD_MARKUP_TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdMarkupType")
            .getter(getter(HlsPlaylistSettings::adMarkupTypeAsStrings))
            .setter(setter(Builder::adMarkupTypeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdMarkupType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MANIFEST_WINDOW_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ManifestWindowSeconds").getter(getter(HlsPlaylistSettings::manifestWindowSeconds))
            .setter(setter(Builder::manifestWindowSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestWindowSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_MARKUP_TYPE_FIELD,
            MANIFEST_WINDOW_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> adMarkupType;

    private final Integer manifestWindowSeconds;

    private HlsPlaylistSettings(BuilderImpl builder) {
        this.adMarkupType = builder.adMarkupType;
        this.manifestWindowSeconds = builder.manifestWindowSeconds;
    }

    /**
     * <p>
     * Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
     * <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
     * <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdMarkupType} method.
     * </p>
     * 
     * @return Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
     *         <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
     *         <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
     */
    public final List<AdMarkupType> adMarkupType() {
        return _adMarkupTypesCopier.copyStringToEnum(adMarkupType);
    }

    /**
     * For responses, this returns true if the service returned a value for the AdMarkupType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAdMarkupType() {
        return adMarkupType != null && !(adMarkupType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
     * <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
     * <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdMarkupType} method.
     * </p>
     * 
     * @return Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
     *         <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
     *         <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
     */
    public final List<String> adMarkupTypeAsStrings() {
        return adMarkupType;
    }

    /**
     * <p>
     * The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
     * <code>3600</code> seconds.
     * </p>
     * 
     * @return The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
     *         <code>3600</code> seconds.
     */
    public final Integer manifestWindowSeconds() {
        return manifestWindowSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdMarkupType() ? adMarkupTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(manifestWindowSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsPlaylistSettings)) {
            return false;
        }
        HlsPlaylistSettings other = (HlsPlaylistSettings) obj;
        return hasAdMarkupType() == other.hasAdMarkupType()
                && Objects.equals(adMarkupTypeAsStrings(), other.adMarkupTypeAsStrings())
                && Objects.equals(manifestWindowSeconds(), other.manifestWindowSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HlsPlaylistSettings").add("AdMarkupType", hasAdMarkupType() ? adMarkupTypeAsStrings() : null)
                .add("ManifestWindowSeconds", manifestWindowSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdMarkupType":
            return Optional.ofNullable(clazz.cast(adMarkupTypeAsStrings()));
        case "ManifestWindowSeconds":
            return Optional.ofNullable(clazz.cast(manifestWindowSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsPlaylistSettings, T> g) {
        return obj -> g.apply((HlsPlaylistSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HlsPlaylistSettings> {
        /**
         * <p>
         * Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
         * <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
         * <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * </p>
         * 
         * @param adMarkupType
         *        Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
         *        <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
         *        <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkupTypeWithStrings(Collection<String> adMarkupType);

        /**
         * <p>
         * Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
         * <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
         * <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * </p>
         * 
         * @param adMarkupType
         *        Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
         *        <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
         *        <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkupTypeWithStrings(String... adMarkupType);

        /**
         * <p>
         * Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
         * <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
         * <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * </p>
         * 
         * @param adMarkupType
         *        Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
         *        <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
         *        <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkupType(Collection<AdMarkupType> adMarkupType);

        /**
         * <p>
         * Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
         * <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
         * <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * </p>
         * 
         * @param adMarkupType
         *        Determines the type of SCTE 35 tags to use in ad markup. Specify <code>DATERANGE</code> to use
         *        <code>DATERANGE</code> tags (for live or VOD content). Specify <code>SCTE35_ENHANCED</code> to use
         *        <code>EXT-X-CUE-OUT</code> and <code>EXT-X-CUE-IN</code> tags (for VOD content only).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adMarkupType(AdMarkupType... adMarkupType);

        /**
         * <p>
         * The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum value:
         * <code>3600</code> seconds.
         * </p>
         * 
         * @param manifestWindowSeconds
         *        The total duration (in seconds) of each manifest. Minimum value: <code>30</code> seconds. Maximum
         *        value: <code>3600</code> seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestWindowSeconds(Integer manifestWindowSeconds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> adMarkupType = DefaultSdkAutoConstructList.getInstance();

        private Integer manifestWindowSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsPlaylistSettings model) {
            adMarkupTypeWithStrings(model.adMarkupType);
            manifestWindowSeconds(model.manifestWindowSeconds);
        }

        public final Collection<String> getAdMarkupType() {
            if (adMarkupType instanceof SdkAutoConstructList) {
                return null;
            }
            return adMarkupType;
        }

        public final void setAdMarkupType(Collection<String> adMarkupType) {
            this.adMarkupType = _adMarkupTypesCopier.copy(adMarkupType);
        }

        @Override
        public final Builder adMarkupTypeWithStrings(Collection<String> adMarkupType) {
            this.adMarkupType = _adMarkupTypesCopier.copy(adMarkupType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkupTypeWithStrings(String... adMarkupType) {
            adMarkupTypeWithStrings(Arrays.asList(adMarkupType));
            return this;
        }

        @Override
        public final Builder adMarkupType(Collection<AdMarkupType> adMarkupType) {
            this.adMarkupType = _adMarkupTypesCopier.copyEnumToString(adMarkupType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adMarkupType(AdMarkupType... adMarkupType) {
            adMarkupType(Arrays.asList(adMarkupType));
            return this;
        }

        public final Integer getManifestWindowSeconds() {
            return manifestWindowSeconds;
        }

        public final void setManifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
        }

        @Override
        public final Builder manifestWindowSeconds(Integer manifestWindowSeconds) {
            this.manifestWindowSeconds = manifestWindowSeconds;
            return this;
        }

        @Override
        public HlsPlaylistSettings build() {
            return new HlsPlaylistSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
