/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorAsyncClient;
import software.amazon.awssdk.services.mediatailor.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesRequest;
import software.amazon.awssdk.services.mediatailor.model.ListLiveSourcesResponse;
import software.amazon.awssdk.services.mediatailor.model.LiveSource;

public class ListLiveSourcesPublisher
implements SdkPublisher<ListLiveSourcesResponse> {
    private final MediaTailorAsyncClient client;
    private final ListLiveSourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLiveSourcesPublisher(MediaTailorAsyncClient client, ListLiveSourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLiveSourcesPublisher(MediaTailorAsyncClient client, ListLiveSourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLiveSourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLiveSourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LiveSource> items() {
        Function<ListLiveSourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLiveSourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLiveSourcesResponseFetcher
    implements AsyncPageFetcher<ListLiveSourcesResponse> {
        private ListLiveSourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListLiveSourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLiveSourcesResponse> nextPage(ListLiveSourcesResponse previousPage) {
            if (previousPage == null) {
                return ListLiveSourcesPublisher.this.client.listLiveSources(ListLiveSourcesPublisher.this.firstRequest);
            }
            return ListLiveSourcesPublisher.this.client.listLiveSources((ListLiveSourcesRequest)((Object)ListLiveSourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

