/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePrefetchScheduleResponse extends MediaTailorResponse implements
        ToCopyableBuilder<CreatePrefetchScheduleResponse.Builder, CreatePrefetchScheduleResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(CreatePrefetchScheduleResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<PrefetchConsumption> CONSUMPTION_FIELD = SdkField
            .<PrefetchConsumption> builder(MarshallingType.SDK_POJO).memberName("Consumption")
            .getter(getter(CreatePrefetchScheduleResponse::consumption)).setter(setter(Builder::consumption))
            .constructor(PrefetchConsumption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Consumption").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreatePrefetchScheduleResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackConfigurationName").getter(getter(CreatePrefetchScheduleResponse::playbackConfigurationName))
            .setter(setter(Builder::playbackConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationName").build())
            .build();

    private static final SdkField<PrefetchRetrieval> RETRIEVAL_FIELD = SdkField
            .<PrefetchRetrieval> builder(MarshallingType.SDK_POJO).memberName("Retrieval")
            .getter(getter(CreatePrefetchScheduleResponse::retrieval)).setter(setter(Builder::retrieval))
            .constructor(PrefetchRetrieval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retrieval").build()).build();

    private static final SdkField<String> STREAM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamId").getter(getter(CreatePrefetchScheduleResponse::streamId)).setter(setter(Builder::streamId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONSUMPTION_FIELD,
            NAME_FIELD, PLAYBACK_CONFIGURATION_NAME_FIELD, RETRIEVAL_FIELD, STREAM_ID_FIELD));

    private final String arn;

    private final PrefetchConsumption consumption;

    private final String name;

    private final String playbackConfigurationName;

    private final PrefetchRetrieval retrieval;

    private final String streamId;

    private CreatePrefetchScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.consumption = builder.consumption;
        this.name = builder.name;
        this.playbackConfigurationName = builder.playbackConfigurationName;
        this.retrieval = builder.retrieval;
        this.streamId = builder.streamId;
    }

    /**
     * <p>
     * The ARN to assign to the prefetch schedule.
     * </p>
     * 
     * @return The ARN to assign to the prefetch schedule.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The configuration settings for MediaTailor's <i>consumption</i> of the prefetched ads from the ad decision
     * server. Each consumption configuration contains an end time and an optional start time that define the
     * <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days after the end time.
     * </p>
     * 
     * @return The configuration settings for MediaTailor's <i>consumption</i> of the prefetched ads from the ad
     *         decision server. Each consumption configuration contains an end time and an optional start time that
     *         define the <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days
     *         after the end time.
     */
    public final PrefetchConsumption consumption() {
        return consumption;
    }

    /**
     * <p>
     * The name to assign to the prefetch schedule.
     * </p>
     * 
     * @return The name to assign to the prefetch schedule.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name to assign to the playback configuration.
     * </p>
     * 
     * @return The name to assign to the playback configuration.
     */
    public final String playbackConfigurationName() {
        return playbackConfigurationName;
    }

    /**
     * <p>
     * The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of
     * prefetched ads will be retrieved and subsequently consumed for each ad break.
     * </p>
     * 
     * @return The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of
     *         prefetched ads will be retrieved and subsequently consumed for each ad break.
     */
    public final PrefetchRetrieval retrieval() {
        return retrieval;
    }

    /**
     * <p>
     * An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the same
     * playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the prefetch schedules
     * with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns all of the prefetch schedules
     * for the playback configuration, regardless of <code>StreamId</code>.
     * </p>
     * 
     * @return An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the
     *         same playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the
     *         prefetch schedules with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns
     *         all of the prefetch schedules for the playback configuration, regardless of <code>StreamId</code>.
     */
    public final String streamId() {
        return streamId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(consumption());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(retrieval());
        hashCode = 31 * hashCode + Objects.hashCode(streamId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrefetchScheduleResponse)) {
            return false;
        }
        CreatePrefetchScheduleResponse other = (CreatePrefetchScheduleResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(consumption(), other.consumption())
                && Objects.equals(name(), other.name())
                && Objects.equals(playbackConfigurationName(), other.playbackConfigurationName())
                && Objects.equals(retrieval(), other.retrieval()) && Objects.equals(streamId(), other.streamId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePrefetchScheduleResponse").add("Arn", arn()).add("Consumption", consumption())
                .add("Name", name()).add("PlaybackConfigurationName", playbackConfigurationName()).add("Retrieval", retrieval())
                .add("StreamId", streamId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Consumption":
            return Optional.ofNullable(clazz.cast(consumption()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PlaybackConfigurationName":
            return Optional.ofNullable(clazz.cast(playbackConfigurationName()));
        case "Retrieval":
            return Optional.ofNullable(clazz.cast(retrieval()));
        case "StreamId":
            return Optional.ofNullable(clazz.cast(streamId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePrefetchScheduleResponse, T> g) {
        return obj -> g.apply((CreatePrefetchScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreatePrefetchScheduleResponse> {
        /**
         * <p>
         * The ARN to assign to the prefetch schedule.
         * </p>
         * 
         * @param arn
         *        The ARN to assign to the prefetch schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The configuration settings for MediaTailor's <i>consumption</i> of the prefetched ads from the ad decision
         * server. Each consumption configuration contains an end time and an optional start time that define the
         * <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days after the end
         * time.
         * </p>
         * 
         * @param consumption
         *        The configuration settings for MediaTailor's <i>consumption</i> of the prefetched ads from the ad
         *        decision server. Each consumption configuration contains an end time and an optional start time that
         *        define the <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven
         *        days after the end time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumption(PrefetchConsumption consumption);

        /**
         * <p>
         * The configuration settings for MediaTailor's <i>consumption</i> of the prefetched ads from the ad decision
         * server. Each consumption configuration contains an end time and an optional start time that define the
         * <i>consumption window</i>. Prefetch schedules automatically expire no earlier than seven days after the end
         * time.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrefetchConsumption.Builder} avoiding the
         * need to create one manually via {@link PrefetchConsumption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrefetchConsumption.Builder#build()} is called immediately and
         * its result is passed to {@link #consumption(PrefetchConsumption)}.
         * 
         * @param consumption
         *        a consumer that will call methods on {@link PrefetchConsumption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #consumption(PrefetchConsumption)
         */
        default Builder consumption(Consumer<PrefetchConsumption.Builder> consumption) {
            return consumption(PrefetchConsumption.builder().applyMutation(consumption).build());
        }

        /**
         * <p>
         * The name to assign to the prefetch schedule.
         * </p>
         * 
         * @param name
         *        The name to assign to the prefetch schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name to assign to the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationName
         *        The name to assign to the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationName(String playbackConfigurationName);

        /**
         * <p>
         * The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of
         * prefetched ads will be retrieved and subsequently consumed for each ad break.
         * </p>
         * 
         * @param retrieval
         *        The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set
         *        of prefetched ads will be retrieved and subsequently consumed for each ad break.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieval(PrefetchRetrieval retrieval);

        /**
         * <p>
         * The configuration settings for retrieval of prefetched ads from the ad decision server. Only one set of
         * prefetched ads will be retrieved and subsequently consumed for each ad break.
         * </p>
         * This is a convenience method that creates an instance of the {@link PrefetchRetrieval.Builder} avoiding the
         * need to create one manually via {@link PrefetchRetrieval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PrefetchRetrieval.Builder#build()} is called immediately and its
         * result is passed to {@link #retrieval(PrefetchRetrieval)}.
         * 
         * @param retrieval
         *        a consumer that will call methods on {@link PrefetchRetrieval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrieval(PrefetchRetrieval)
         */
        default Builder retrieval(Consumer<PrefetchRetrieval.Builder> retrieval) {
            return retrieval(PrefetchRetrieval.builder().applyMutation(retrieval).build());
        }

        /**
         * <p>
         * An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the same
         * playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the prefetch
         * schedules with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns all of the
         * prefetch schedules for the playback configuration, regardless of <code>StreamId</code>.
         * </p>
         * 
         * @param streamId
         *        An optional stream identifier that MediaTailor uses to prefetch ads for multiple streams that use the
         *        same playback configuration. If <code>StreamId</code> is specified, MediaTailor returns all of the
         *        prefetch schedules with an exact match on <code>StreamId</code>. If not specified, MediaTailor returns
         *        all of the prefetch schedules for the playback configuration, regardless of <code>StreamId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamId(String streamId);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private String arn;

        private PrefetchConsumption consumption;

        private String name;

        private String playbackConfigurationName;

        private PrefetchRetrieval retrieval;

        private String streamId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrefetchScheduleResponse model) {
            super(model);
            arn(model.arn);
            consumption(model.consumption);
            name(model.name);
            playbackConfigurationName(model.playbackConfigurationName);
            retrieval(model.retrieval);
            streamId(model.streamId);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final PrefetchConsumption.Builder getConsumption() {
            return consumption != null ? consumption.toBuilder() : null;
        }

        public final void setConsumption(PrefetchConsumption.BuilderImpl consumption) {
            this.consumption = consumption != null ? consumption.build() : null;
        }

        @Override
        public final Builder consumption(PrefetchConsumption consumption) {
            this.consumption = consumption;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        public final PrefetchRetrieval.Builder getRetrieval() {
            return retrieval != null ? retrieval.toBuilder() : null;
        }

        public final void setRetrieval(PrefetchRetrieval.BuilderImpl retrieval) {
            this.retrieval = retrieval != null ? retrieval.build() : null;
        }

        @Override
        public final Builder retrieval(PrefetchRetrieval retrieval) {
            this.retrieval = retrieval;
            return this;
        }

        public final String getStreamId() {
            return streamId;
        }

        public final void setStreamId(String streamId) {
            this.streamId = streamId;
        }

        @Override
        public final Builder streamId(String streamId) {
            this.streamId = streamId;
            return this;
        }

        @Override
        public CreatePrefetchScheduleResponse build() {
            return new CreatePrefetchScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
