/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A playlist of media (VOD and/or live) to be played instead of the default media on a particular program.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AlternateMedia implements SdkPojo, Serializable, ToCopyableBuilder<AlternateMedia.Builder, AlternateMedia> {
    private static final SdkField<List<AdBreak>> AD_BREAKS_FIELD = SdkField
            .<List<AdBreak>> builder(MarshallingType.LIST)
            .memberName("AdBreaks")
            .getter(getter(AlternateMedia::adBreaks))
            .setter(setter(Builder::adBreaks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreaks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdBreak> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdBreak::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ClipRange> CLIP_RANGE_FIELD = SdkField.<ClipRange> builder(MarshallingType.SDK_POJO)
            .memberName("ClipRange").getter(getter(AlternateMedia::clipRange)).setter(setter(Builder::clipRange))
            .constructor(ClipRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClipRange").build()).build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(AlternateMedia::durationMillis)).setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LiveSourceName").getter(getter(AlternateMedia::liveSourceName)).setter(setter(Builder::liveSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSourceName").build()).build();

    private static final SdkField<Long> SCHEDULED_START_TIME_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScheduledStartTimeMillis").getter(getter(AlternateMedia::scheduledStartTimeMillis))
            .setter(setter(Builder::scheduledStartTimeMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTimeMillis").build())
            .build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(AlternateMedia::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(AlternateMedia::vodSourceName)).setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAKS_FIELD,
            CLIP_RANGE_FIELD, DURATION_MILLIS_FIELD, LIVE_SOURCE_NAME_FIELD, SCHEDULED_START_TIME_MILLIS_FIELD,
            SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AdBreak> adBreaks;

    private final ClipRange clipRange;

    private final Long durationMillis;

    private final String liveSourceName;

    private final Long scheduledStartTimeMillis;

    private final String sourceLocationName;

    private final String vodSourceName;

    private AlternateMedia(BuilderImpl builder) {
        this.adBreaks = builder.adBreaks;
        this.clipRange = builder.clipRange;
        this.durationMillis = builder.durationMillis;
        this.liveSourceName = builder.liveSourceName;
        this.scheduledStartTimeMillis = builder.scheduledStartTimeMillis;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdBreaks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdBreaks() {
        return adBreaks != null && !(adBreaks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Ad break configuration parameters defined in AlternateMedia.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdBreaks} method.
     * </p>
     * 
     * @return Ad break configuration parameters defined in AlternateMedia.
     */
    public final List<AdBreak> adBreaks() {
        return adBreaks;
    }

    /**
     * Returns the value of the ClipRange property for this object.
     * 
     * @return The value of the ClipRange property for this object.
     */
    public final ClipRange clipRange() {
        return clipRange;
    }

    /**
     * <p>
     * The duration of the alternateMedia in milliseconds.
     * </p>
     * 
     * @return The duration of the alternateMedia in milliseconds.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    /**
     * <p>
     * The name of the live source for alternateMedia.
     * </p>
     * 
     * @return The name of the live source for alternateMedia.
     */
    public final String liveSourceName() {
        return liveSourceName;
    }

    /**
     * <p>
     * The date and time that the alternateMedia is scheduled to start, in epoch milliseconds.
     * </p>
     * 
     * @return The date and time that the alternateMedia is scheduled to start, in epoch milliseconds.
     */
    public final Long scheduledStartTimeMillis() {
        return scheduledStartTimeMillis;
    }

    /**
     * <p>
     * The name of the source location for alternateMedia.
     * </p>
     * 
     * @return The name of the source location for alternateMedia.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * <p>
     * The name of the VOD source for alternateMedia.
     * </p>
     * 
     * @return The name of the VOD source for alternateMedia.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAdBreaks() ? adBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clipRange());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStartTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlternateMedia)) {
            return false;
        }
        AlternateMedia other = (AlternateMedia) obj;
        return hasAdBreaks() == other.hasAdBreaks() && Objects.equals(adBreaks(), other.adBreaks())
                && Objects.equals(clipRange(), other.clipRange()) && Objects.equals(durationMillis(), other.durationMillis())
                && Objects.equals(liveSourceName(), other.liveSourceName())
                && Objects.equals(scheduledStartTimeMillis(), other.scheduledStartTimeMillis())
                && Objects.equals(sourceLocationName(), other.sourceLocationName())
                && Objects.equals(vodSourceName(), other.vodSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AlternateMedia").add("AdBreaks", hasAdBreaks() ? adBreaks() : null)
                .add("ClipRange", clipRange()).add("DurationMillis", durationMillis()).add("LiveSourceName", liveSourceName())
                .add("ScheduledStartTimeMillis", scheduledStartTimeMillis()).add("SourceLocationName", sourceLocationName())
                .add("VodSourceName", vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdBreaks":
            return Optional.ofNullable(clazz.cast(adBreaks()));
        case "ClipRange":
            return Optional.ofNullable(clazz.cast(clipRange()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "LiveSourceName":
            return Optional.ofNullable(clazz.cast(liveSourceName()));
        case "ScheduledStartTimeMillis":
            return Optional.ofNullable(clazz.cast(scheduledStartTimeMillis()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AlternateMedia, T> g) {
        return obj -> g.apply((AlternateMedia) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AlternateMedia> {
        /**
         * <p>
         * Ad break configuration parameters defined in AlternateMedia.
         * </p>
         * 
         * @param adBreaks
         *        Ad break configuration parameters defined in AlternateMedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(Collection<AdBreak> adBreaks);

        /**
         * <p>
         * Ad break configuration parameters defined in AlternateMedia.
         * </p>
         * 
         * @param adBreaks
         *        Ad break configuration parameters defined in AlternateMedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(AdBreak... adBreaks);

        /**
         * <p>
         * Ad break configuration parameters defined in AlternateMedia.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mediatailor.model.AdBreak#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder#build()} is called immediately and
         * its result is passed to {@link #adBreaks(List<AdBreak>)}.
         * 
         * @param adBreaks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adBreaks(java.util.Collection<AdBreak>)
         */
        Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks);

        /**
         * Sets the value of the ClipRange property for this object.
         *
         * @param clipRange
         *        The new value for the ClipRange property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clipRange(ClipRange clipRange);

        /**
         * Sets the value of the ClipRange property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ClipRange.Builder} avoiding the need to
         * create one manually via {@link ClipRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClipRange.Builder#build()} is called immediately and its result
         * is passed to {@link #clipRange(ClipRange)}.
         * 
         * @param clipRange
         *        a consumer that will call methods on {@link ClipRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clipRange(ClipRange)
         */
        default Builder clipRange(Consumer<ClipRange.Builder> clipRange) {
            return clipRange(ClipRange.builder().applyMutation(clipRange).build());
        }

        /**
         * <p>
         * The duration of the alternateMedia in milliseconds.
         * </p>
         * 
         * @param durationMillis
         *        The duration of the alternateMedia in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * The name of the live source for alternateMedia.
         * </p>
         * 
         * @param liveSourceName
         *        The name of the live source for alternateMedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveSourceName(String liveSourceName);

        /**
         * <p>
         * The date and time that the alternateMedia is scheduled to start, in epoch milliseconds.
         * </p>
         * 
         * @param scheduledStartTimeMillis
         *        The date and time that the alternateMedia is scheduled to start, in epoch milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStartTimeMillis(Long scheduledStartTimeMillis);

        /**
         * <p>
         * The name of the source location for alternateMedia.
         * </p>
         * 
         * @param sourceLocationName
         *        The name of the source location for alternateMedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The name of the VOD source for alternateMedia.
         * </p>
         * 
         * @param vodSourceName
         *        The name of the VOD source for alternateMedia.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);
    }

    static final class BuilderImpl implements Builder {
        private List<AdBreak> adBreaks = DefaultSdkAutoConstructList.getInstance();

        private ClipRange clipRange;

        private Long durationMillis;

        private String liveSourceName;

        private Long scheduledStartTimeMillis;

        private String sourceLocationName;

        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(AlternateMedia model) {
            adBreaks(model.adBreaks);
            clipRange(model.clipRange);
            durationMillis(model.durationMillis);
            liveSourceName(model.liveSourceName);
            scheduledStartTimeMillis(model.scheduledStartTimeMillis);
            sourceLocationName(model.sourceLocationName);
            vodSourceName(model.vodSourceName);
        }

        public final List<AdBreak.Builder> getAdBreaks() {
            List<AdBreak.Builder> result = ___listOfAdBreakCopier.copyToBuilder(this.adBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreaks(Collection<AdBreak.BuilderImpl> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copyFromBuilder(adBreaks);
        }

        @Override
        public final Builder adBreaks(Collection<AdBreak> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copy(adBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(AdBreak... adBreaks) {
            adBreaks(Arrays.asList(adBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks) {
            adBreaks(Stream.of(adBreaks).map(c -> AdBreak.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClipRange.Builder getClipRange() {
            return clipRange != null ? clipRange.toBuilder() : null;
        }

        public final void setClipRange(ClipRange.BuilderImpl clipRange) {
            this.clipRange = clipRange != null ? clipRange.build() : null;
        }

        @Override
        public final Builder clipRange(ClipRange clipRange) {
            this.clipRange = clipRange;
            return this;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final String getLiveSourceName() {
            return liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final Long getScheduledStartTimeMillis() {
            return scheduledStartTimeMillis;
        }

        public final void setScheduledStartTimeMillis(Long scheduledStartTimeMillis) {
            this.scheduledStartTimeMillis = scheduledStartTimeMillis;
        }

        @Override
        public final Builder scheduledStartTimeMillis(Long scheduledStartTimeMillis) {
            this.scheduledStartTimeMillis = scheduledStartTimeMillis;
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        @Override
        public AlternateMedia build() {
            return new AlternateMedia(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
