/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediatailor.MediaTailorClient;
import software.amazon.awssdk.services.mediatailor.internal.UserAgentUtils;
import software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsRequest;
import software.amazon.awssdk.services.mediatailor.model.ListPlaybackConfigurationsResponse;
import software.amazon.awssdk.services.mediatailor.model.PlaybackConfiguration;

public class ListPlaybackConfigurationsIterable
implements SdkIterable<ListPlaybackConfigurationsResponse> {
    private final MediaTailorClient client;
    private final ListPlaybackConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlaybackConfigurationsIterable(MediaTailorClient client, ListPlaybackConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlaybackConfigurationsResponseFetcher();
    }

    public Iterator<ListPlaybackConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PlaybackConfiguration> items() {
        Function<ListPlaybackConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlaybackConfigurationsResponseFetcher
    implements SyncPageFetcher<ListPlaybackConfigurationsResponse> {
        private ListPlaybackConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlaybackConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlaybackConfigurationsResponse nextPage(ListPlaybackConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListPlaybackConfigurationsIterable.this.client.listPlaybackConfigurations(ListPlaybackConfigurationsIterable.this.firstRequest);
            }
            return ListPlaybackConfigurationsIterable.this.client.listPlaybackConfigurations((ListPlaybackConfigurationsRequest)((Object)ListPlaybackConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

