/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The log configuration for the channel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogConfigurationForChannel implements SdkPojo, Serializable,
        ToCopyableBuilder<LogConfigurationForChannel.Builder, LogConfigurationForChannel> {
    private static final SdkField<List<String>> LOG_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogTypes")
            .getter(getter(LogConfigurationForChannel::logTypesAsStrings))
            .setter(setter(Builder::logTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> logTypes;

    private LogConfigurationForChannel(BuilderImpl builder) {
        this.logTypes = builder.logTypes;
    }

    /**
     * <p>
     * The log types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTypes} method.
     * </p>
     * 
     * @return The log types.
     */
    public final List<LogType> logTypes() {
        return LogTypesCopier.copyStringToEnum(logTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the LogTypes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLogTypes() {
        return logTypes != null && !(logTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The log types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTypes} method.
     * </p>
     * 
     * @return The log types.
     */
    public final List<String> logTypesAsStrings() {
        return logTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLogTypes() ? logTypesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfigurationForChannel)) {
            return false;
        }
        LogConfigurationForChannel other = (LogConfigurationForChannel) obj;
        return hasLogTypes() == other.hasLogTypes() && Objects.equals(logTypesAsStrings(), other.logTypesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LogConfigurationForChannel").add("LogTypes", hasLogTypes() ? logTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogTypes":
            return Optional.ofNullable(clazz.cast(logTypesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogConfigurationForChannel, T> g) {
        return obj -> g.apply((LogConfigurationForChannel) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogConfigurationForChannel> {
        /**
         * <p>
         * The log types.
         * </p>
         * 
         * @param logTypes
         *        The log types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesWithStrings(Collection<String> logTypes);

        /**
         * <p>
         * The log types.
         * </p>
         * 
         * @param logTypes
         *        The log types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesWithStrings(String... logTypes);

        /**
         * <p>
         * The log types.
         * </p>
         * 
         * @param logTypes
         *        The log types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypes(Collection<LogType> logTypes);

        /**
         * <p>
         * The log types.
         * </p>
         * 
         * @param logTypes
         *        The log types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypes(LogType... logTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> logTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LogConfigurationForChannel model) {
            logTypesWithStrings(model.logTypes);
        }

        public final Collection<String> getLogTypes() {
            if (logTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return logTypes;
        }

        public final void setLogTypes(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
        }

        @Override
        public final Builder logTypesWithStrings(Collection<String> logTypes) {
            this.logTypes = LogTypesCopier.copy(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesWithStrings(String... logTypes) {
            logTypesWithStrings(Arrays.asList(logTypes));
            return this;
        }

        @Override
        public final Builder logTypes(Collection<LogType> logTypes) {
            this.logTypes = LogTypesCopier.copyEnumToString(logTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypes(LogType... logTypes) {
            logTypes(Arrays.asList(logTypes));
            return this;
        }

        @Override
        public LogConfigurationForChannel build() {
            return new LogConfigurationForChannel(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
