/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for time-shifted viewing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeShiftConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeShiftConfiguration.Builder, TimeShiftConfiguration> {
    private static final SdkField<Integer> MAX_TIME_DELAY_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxTimeDelaySeconds").getter(getter(TimeShiftConfiguration::maxTimeDelaySeconds))
            .setter(setter(Builder::maxTimeDelaySeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxTimeDelaySeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_TIME_DELAY_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxTimeDelaySeconds;

    private TimeShiftConfiguration(BuilderImpl builder) {
        this.maxTimeDelaySeconds = builder.maxTimeDelaySeconds;
    }

    /**
     * <p>
     * The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and the
     * maximum allowed maximum time delay is 21600 seconds (6 hours).
     * </p>
     * 
     * @return The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and
     *         the maximum allowed maximum time delay is 21600 seconds (6 hours).
     */
    public final Integer maxTimeDelaySeconds() {
        return maxTimeDelaySeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxTimeDelaySeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeShiftConfiguration)) {
            return false;
        }
        TimeShiftConfiguration other = (TimeShiftConfiguration) obj;
        return Objects.equals(maxTimeDelaySeconds(), other.maxTimeDelaySeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeShiftConfiguration").add("MaxTimeDelaySeconds", maxTimeDelaySeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxTimeDelaySeconds":
            return Optional.ofNullable(clazz.cast(maxTimeDelaySeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeShiftConfiguration, T> g) {
        return obj -> g.apply((TimeShiftConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeShiftConfiguration> {
        /**
         * <p>
         * The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds, and the
         * maximum allowed maximum time delay is 21600 seconds (6 hours).
         * </p>
         * 
         * @param maxTimeDelaySeconds
         *        The maximum time delay for time-shifted viewing. The minimum allowed maximum time delay is 0 seconds,
         *        and the maximum allowed maximum time delay is 21600 seconds (6 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxTimeDelaySeconds(Integer maxTimeDelaySeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxTimeDelaySeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeShiftConfiguration model) {
            maxTimeDelaySeconds(model.maxTimeDelaySeconds);
        }

        public final Integer getMaxTimeDelaySeconds() {
            return maxTimeDelaySeconds;
        }

        public final void setMaxTimeDelaySeconds(Integer maxTimeDelaySeconds) {
            this.maxTimeDelaySeconds = maxTimeDelaySeconds;
        }

        @Override
        public final Builder maxTimeDelaySeconds(Integer maxTimeDelaySeconds) {
            this.maxTimeDelaySeconds = maxTimeDelaySeconds;
            return this;
        }

        @Override
        public TimeShiftConfiguration build() {
            return new TimeShiftConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
