/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.AdBreak;
import software.amazon.awssdk.services.mediatailor.model.AudienceMedia;
import software.amazon.awssdk.services.mediatailor.model.MediaTailorRequest;
import software.amazon.awssdk.services.mediatailor.model.UpdateProgramScheduleConfiguration;
import software.amazon.awssdk.services.mediatailor.model.___listOfAdBreakCopier;
import software.amazon.awssdk.services.mediatailor.model.___listOfAudienceMediaCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProgramRequest
extends MediaTailorRequest
implements ToCopyableBuilder<Builder, UpdateProgramRequest> {
    private static final SdkField<List<AdBreak>> AD_BREAKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AdBreaks").getter(UpdateProgramRequest.getter(UpdateProgramRequest::adBreaks)).setter(UpdateProgramRequest.setter(Builder::adBreaks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreaks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AdBreak::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AudienceMedia>> AUDIENCE_MEDIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AudienceMedia").getter(UpdateProgramRequest.getter(UpdateProgramRequest::audienceMedia)).setter(UpdateProgramRequest.setter(Builder::audienceMedia)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudienceMedia").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudienceMedia::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(UpdateProgramRequest.getter(UpdateProgramRequest::channelName)).setter(UpdateProgramRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()}).build();
    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProgramName").getter(UpdateProgramRequest.getter(UpdateProgramRequest::programName)).setter(UpdateProgramRequest.setter(Builder::programName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ProgramName").build()}).build();
    private static final SdkField<UpdateProgramScheduleConfiguration> SCHEDULE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfiguration").getter(UpdateProgramRequest.getter(UpdateProgramRequest::scheduleConfiguration)).setter(UpdateProgramRequest.setter(Builder::scheduleConfiguration)).constructor(UpdateProgramScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAKS_FIELD, AUDIENCE_MEDIA_FIELD, CHANNEL_NAME_FIELD, PROGRAM_NAME_FIELD, SCHEDULE_CONFIGURATION_FIELD));
    private final List<AdBreak> adBreaks;
    private final List<AudienceMedia> audienceMedia;
    private final String channelName;
    private final String programName;
    private final UpdateProgramScheduleConfiguration scheduleConfiguration;

    private UpdateProgramRequest(BuilderImpl builder) {
        super(builder);
        this.adBreaks = builder.adBreaks;
        this.audienceMedia = builder.audienceMedia;
        this.channelName = builder.channelName;
        this.programName = builder.programName;
        this.scheduleConfiguration = builder.scheduleConfiguration;
    }

    public final boolean hasAdBreaks() {
        return this.adBreaks != null && !(this.adBreaks instanceof SdkAutoConstructList);
    }

    public final List<AdBreak> adBreaks() {
        return this.adBreaks;
    }

    public final boolean hasAudienceMedia() {
        return this.audienceMedia != null && !(this.audienceMedia instanceof SdkAutoConstructList);
    }

    public final List<AudienceMedia> audienceMedia() {
        return this.audienceMedia;
    }

    public final String channelName() {
        return this.channelName;
    }

    public final String programName() {
        return this.programName;
    }

    public final UpdateProgramScheduleConfiguration scheduleConfiguration() {
        return this.scheduleConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdBreaks() ? this.adBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudienceMedia() ? this.audienceMedia() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.programName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProgramRequest)) {
            return false;
        }
        UpdateProgramRequest other = (UpdateProgramRequest)((Object)obj);
        return this.hasAdBreaks() == other.hasAdBreaks() && Objects.equals(this.adBreaks(), other.adBreaks()) && this.hasAudienceMedia() == other.hasAudienceMedia() && Objects.equals(this.audienceMedia(), other.audienceMedia()) && Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.programName(), other.programName()) && Objects.equals(this.scheduleConfiguration(), other.scheduleConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProgramRequest").add("AdBreaks", this.hasAdBreaks() ? this.adBreaks() : null).add("AudienceMedia", this.hasAudienceMedia() ? this.audienceMedia() : null).add("ChannelName", (Object)this.channelName()).add("ProgramName", (Object)this.programName()).add("ScheduleConfiguration", (Object)this.scheduleConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdBreaks": {
                return Optional.ofNullable(clazz.cast(this.adBreaks()));
            }
            case "AudienceMedia": {
                return Optional.ofNullable(clazz.cast(this.audienceMedia()));
            }
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ProgramName": {
                return Optional.ofNullable(clazz.cast(this.programName()));
            }
            case "ScheduleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProgramRequest, T> g) {
        return obj -> g.apply((UpdateProgramRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MediaTailorRequest.BuilderImpl
    implements Builder {
        private List<AdBreak> adBreaks = DefaultSdkAutoConstructList.getInstance();
        private List<AudienceMedia> audienceMedia = DefaultSdkAutoConstructList.getInstance();
        private String channelName;
        private String programName;
        private UpdateProgramScheduleConfiguration scheduleConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProgramRequest model) {
            super(model);
            this.adBreaks(model.adBreaks);
            this.audienceMedia(model.audienceMedia);
            this.channelName(model.channelName);
            this.programName(model.programName);
            this.scheduleConfiguration(model.scheduleConfiguration);
        }

        public final List<AdBreak.Builder> getAdBreaks() {
            List<AdBreak.Builder> result = ___listOfAdBreakCopier.copyToBuilder(this.adBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreaks(Collection<AdBreak.BuilderImpl> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copyFromBuilder(adBreaks);
        }

        @Override
        public final Builder adBreaks(Collection<AdBreak> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copy(adBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(AdBreak ... adBreaks) {
            this.adBreaks(Arrays.asList(adBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(Consumer<AdBreak.Builder> ... adBreaks) {
            this.adBreaks(Stream.of(adBreaks).map(c -> (AdBreak)((AdBreak.Builder)AdBreak.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AudienceMedia.Builder> getAudienceMedia() {
            List<AudienceMedia.Builder> result = ___listOfAudienceMediaCopier.copyToBuilder(this.audienceMedia);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceMedia(Collection<AudienceMedia.BuilderImpl> audienceMedia) {
            this.audienceMedia = ___listOfAudienceMediaCopier.copyFromBuilder(audienceMedia);
        }

        @Override
        public final Builder audienceMedia(Collection<AudienceMedia> audienceMedia) {
            this.audienceMedia = ___listOfAudienceMediaCopier.copy(audienceMedia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceMedia(AudienceMedia ... audienceMedia) {
            this.audienceMedia(Arrays.asList(audienceMedia));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceMedia(Consumer<AudienceMedia.Builder> ... audienceMedia) {
            this.audienceMedia(Stream.of(audienceMedia).map(c -> (AudienceMedia)((AudienceMedia.Builder)AudienceMedia.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getChannelName() {
            return this.channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getProgramName() {
            return this.programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final UpdateProgramScheduleConfiguration.Builder getScheduleConfiguration() {
            return this.scheduleConfiguration != null ? this.scheduleConfiguration.toBuilder() : null;
        }

        public final void setScheduleConfiguration(UpdateProgramScheduleConfiguration.BuilderImpl scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration != null ? scheduleConfiguration.build() : null;
        }

        @Override
        public final Builder scheduleConfiguration(UpdateProgramScheduleConfiguration scheduleConfiguration) {
            this.scheduleConfiguration = scheduleConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProgramRequest build() {
            return new UpdateProgramRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MediaTailorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProgramRequest> {
        public Builder adBreaks(Collection<AdBreak> var1);

        public Builder adBreaks(AdBreak ... var1);

        public Builder adBreaks(Consumer<AdBreak.Builder> ... var1);

        public Builder audienceMedia(Collection<AudienceMedia> var1);

        public Builder audienceMedia(AudienceMedia ... var1);

        public Builder audienceMedia(Consumer<AudienceMedia.Builder> ... var1);

        public Builder channelName(String var1);

        public Builder programName(String var1);

        public Builder scheduleConfiguration(UpdateProgramScheduleConfiguration var1);

        default public Builder scheduleConfiguration(Consumer<UpdateProgramScheduleConfiguration.Builder> scheduleConfiguration) {
            return this.scheduleConfiguration((UpdateProgramScheduleConfiguration)((UpdateProgramScheduleConfiguration.Builder)UpdateProgramScheduleConfiguration.builder().applyMutation(scheduleConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

