/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateChannelRequest extends MediaTailorRequest implements
        ToCopyableBuilder<UpdateChannelRequest.Builder, UpdateChannelRequest> {
    private static final SdkField<List<String>> AUDIENCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Audiences")
            .getter(getter(UpdateChannelRequest::audiences))
            .setter(setter(Builder::audiences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Audiences").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(UpdateChannelRequest::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ChannelName").build()).build();

    private static final SdkField<SlateSource> FILLER_SLATE_FIELD = SdkField.<SlateSource> builder(MarshallingType.SDK_POJO)
            .memberName("FillerSlate").getter(getter(UpdateChannelRequest::fillerSlate)).setter(setter(Builder::fillerSlate))
            .constructor(SlateSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FillerSlate").build()).build();

    private static final SdkField<List<RequestOutputItem>> OUTPUTS_FIELD = SdkField
            .<List<RequestOutputItem>> builder(MarshallingType.LIST)
            .memberName("Outputs")
            .getter(getter(UpdateChannelRequest::outputs))
            .setter(setter(Builder::outputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequestOutputItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestOutputItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimeShiftConfiguration> TIME_SHIFT_CONFIGURATION_FIELD = SdkField
            .<TimeShiftConfiguration> builder(MarshallingType.SDK_POJO).memberName("TimeShiftConfiguration")
            .getter(getter(UpdateChannelRequest::timeShiftConfiguration)).setter(setter(Builder::timeShiftConfiguration))
            .constructor(TimeShiftConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeShiftConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIENCES_FIELD,
            CHANNEL_NAME_FIELD, FILLER_SLATE_FIELD, OUTPUTS_FIELD, TIME_SHIFT_CONFIGURATION_FIELD));

    private final List<String> audiences;

    private final String channelName;

    private final SlateSource fillerSlate;

    private final List<RequestOutputItem> outputs;

    private final TimeShiftConfiguration timeShiftConfiguration;

    private UpdateChannelRequest(BuilderImpl builder) {
        super(builder);
        this.audiences = builder.audiences;
        this.channelName = builder.channelName;
        this.fillerSlate = builder.fillerSlate;
        this.outputs = builder.outputs;
        this.timeShiftConfiguration = builder.timeShiftConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Audiences property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAudiences() {
        return audiences != null && !(audiences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of audiences defined in channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudiences} method.
     * </p>
     * 
     * @return The list of audiences defined in channel.
     */
    public final List<String> audiences() {
        return audiences;
    }

    /**
     * <p>
     * The name of the channel.
     * </p>
     * 
     * @return The name of the channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel
     * uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler slate for channels
     * using the <code>LOOP</code> <code>PlaybackMode</code>.
     * </p>
     * 
     * @return The slate used to fill gaps between programs in the schedule. You must configure filler slate if your
     *         channel uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler slate
     *         for channels using the <code>LOOP</code> <code>PlaybackMode</code>.
     */
    public final SlateSource fillerSlate() {
        return fillerSlate;
    }

    /**
     * For responses, this returns true if the service returned a value for the Outputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasOutputs() {
        return outputs != null && !(outputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The channel's output properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputs} method.
     * </p>
     * 
     * @return The channel's output properties.
     */
    public final List<RequestOutputItem> outputs() {
        return outputs;
    }

    /**
     * <p>
     * The time-shifted viewing configuration you want to associate to the channel.
     * </p>
     * 
     * @return The time-shifted viewing configuration you want to associate to the channel.
     */
    public final TimeShiftConfiguration timeShiftConfiguration() {
        return timeShiftConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAudiences() ? audiences() : null);
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(fillerSlate());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputs() ? outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeShiftConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateChannelRequest)) {
            return false;
        }
        UpdateChannelRequest other = (UpdateChannelRequest) obj;
        return hasAudiences() == other.hasAudiences() && Objects.equals(audiences(), other.audiences())
                && Objects.equals(channelName(), other.channelName()) && Objects.equals(fillerSlate(), other.fillerSlate())
                && hasOutputs() == other.hasOutputs() && Objects.equals(outputs(), other.outputs())
                && Objects.equals(timeShiftConfiguration(), other.timeShiftConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateChannelRequest").add("Audiences", hasAudiences() ? audiences() : null)
                .add("ChannelName", channelName()).add("FillerSlate", fillerSlate())
                .add("Outputs", hasOutputs() ? outputs() : null).add("TimeShiftConfiguration", timeShiftConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Audiences":
            return Optional.ofNullable(clazz.cast(audiences()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "FillerSlate":
            return Optional.ofNullable(clazz.cast(fillerSlate()));
        case "Outputs":
            return Optional.ofNullable(clazz.cast(outputs()));
        case "TimeShiftConfiguration":
            return Optional.ofNullable(clazz.cast(timeShiftConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateChannelRequest, T> g) {
        return obj -> g.apply((UpdateChannelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateChannelRequest> {
        /**
         * <p>
         * The list of audiences defined in channel.
         * </p>
         * 
         * @param audiences
         *        The list of audiences defined in channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audiences(Collection<String> audiences);

        /**
         * <p>
         * The list of audiences defined in channel.
         * </p>
         * 
         * @param audiences
         *        The list of audiences defined in channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audiences(String... audiences);

        /**
         * <p>
         * The name of the channel.
         * </p>
         * 
         * @param channelName
         *        The name of the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel
         * uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler slate for channels
         * using the <code>LOOP</code> <code>PlaybackMode</code>.
         * </p>
         * 
         * @param fillerSlate
         *        The slate used to fill gaps between programs in the schedule. You must configure filler slate if your
         *        channel uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler
         *        slate for channels using the <code>LOOP</code> <code>PlaybackMode</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fillerSlate(SlateSource fillerSlate);

        /**
         * <p>
         * The slate used to fill gaps between programs in the schedule. You must configure filler slate if your channel
         * uses the <code>LINEAR</code> <code>PlaybackMode</code>. MediaTailor doesn't support filler slate for channels
         * using the <code>LOOP</code> <code>PlaybackMode</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SlateSource.Builder} avoiding the need to
         * create one manually via {@link SlateSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlateSource.Builder#build()} is called immediately and its result
         * is passed to {@link #fillerSlate(SlateSource)}.
         * 
         * @param fillerSlate
         *        a consumer that will call methods on {@link SlateSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fillerSlate(SlateSource)
         */
        default Builder fillerSlate(Consumer<SlateSource.Builder> fillerSlate) {
            return fillerSlate(SlateSource.builder().applyMutation(fillerSlate).build());
        }

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * 
         * @param outputs
         *        The channel's output properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(Collection<RequestOutputItem> outputs);

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * 
         * @param outputs
         *        The channel's output properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputs(RequestOutputItem... outputs);

        /**
         * <p>
         * The channel's output properties.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.RequestOutputItem.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.mediatailor.model.RequestOutputItem#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.RequestOutputItem.Builder#build()} is called
         * immediately and its result is passed to {@link #outputs(List<RequestOutputItem>)}.
         * 
         * @param outputs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.RequestOutputItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputs(java.util.Collection<RequestOutputItem>)
         */
        Builder outputs(Consumer<RequestOutputItem.Builder>... outputs);

        /**
         * <p>
         * The time-shifted viewing configuration you want to associate to the channel.
         * </p>
         * 
         * @param timeShiftConfiguration
         *        The time-shifted viewing configuration you want to associate to the channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeShiftConfiguration(TimeShiftConfiguration timeShiftConfiguration);

        /**
         * <p>
         * The time-shifted viewing configuration you want to associate to the channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeShiftConfiguration.Builder} avoiding
         * the need to create one manually via {@link TimeShiftConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeShiftConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #timeShiftConfiguration(TimeShiftConfiguration)}.
         * 
         * @param timeShiftConfiguration
         *        a consumer that will call methods on {@link TimeShiftConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeShiftConfiguration(TimeShiftConfiguration)
         */
        default Builder timeShiftConfiguration(Consumer<TimeShiftConfiguration.Builder> timeShiftConfiguration) {
            return timeShiftConfiguration(TimeShiftConfiguration.builder().applyMutation(timeShiftConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MediaTailorRequest.BuilderImpl implements Builder {
        private List<String> audiences = DefaultSdkAutoConstructList.getInstance();

        private String channelName;

        private SlateSource fillerSlate;

        private List<RequestOutputItem> outputs = DefaultSdkAutoConstructList.getInstance();

        private TimeShiftConfiguration timeShiftConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateChannelRequest model) {
            super(model);
            audiences(model.audiences);
            channelName(model.channelName);
            fillerSlate(model.fillerSlate);
            outputs(model.outputs);
            timeShiftConfiguration(model.timeShiftConfiguration);
        }

        public final Collection<String> getAudiences() {
            if (audiences instanceof SdkAutoConstructList) {
                return null;
            }
            return audiences;
        }

        public final void setAudiences(Collection<String> audiences) {
            this.audiences = AudiencesCopier.copy(audiences);
        }

        @Override
        public final Builder audiences(Collection<String> audiences) {
            this.audiences = AudiencesCopier.copy(audiences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audiences(String... audiences) {
            audiences(Arrays.asList(audiences));
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final SlateSource.Builder getFillerSlate() {
            return fillerSlate != null ? fillerSlate.toBuilder() : null;
        }

        public final void setFillerSlate(SlateSource.BuilderImpl fillerSlate) {
            this.fillerSlate = fillerSlate != null ? fillerSlate.build() : null;
        }

        @Override
        public final Builder fillerSlate(SlateSource fillerSlate) {
            this.fillerSlate = fillerSlate;
            return this;
        }

        public final List<RequestOutputItem.Builder> getOutputs() {
            List<RequestOutputItem.Builder> result = RequestOutputsCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<RequestOutputItem.BuilderImpl> outputs) {
            this.outputs = RequestOutputsCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<RequestOutputItem> outputs) {
            this.outputs = RequestOutputsCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(RequestOutputItem... outputs) {
            outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<RequestOutputItem.Builder>... outputs) {
            outputs(Stream.of(outputs).map(c -> RequestOutputItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final TimeShiftConfiguration.Builder getTimeShiftConfiguration() {
            return timeShiftConfiguration != null ? timeShiftConfiguration.toBuilder() : null;
        }

        public final void setTimeShiftConfiguration(TimeShiftConfiguration.BuilderImpl timeShiftConfiguration) {
            this.timeShiftConfiguration = timeShiftConfiguration != null ? timeShiftConfiguration.build() : null;
        }

        @Override
        public final Builder timeShiftConfiguration(TimeShiftConfiguration timeShiftConfiguration) {
            this.timeShiftConfiguration = timeShiftConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateChannelRequest build() {
            return new UpdateChannelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
