/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptor;
import software.amazon.awssdk.services.mediatailor.model.SegmentationDescriptorListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeSignalMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TimeSignalMessage> {
    private static final SdkField<List<SegmentationDescriptor>> SEGMENTATION_DESCRIPTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SegmentationDescriptors").getter(TimeSignalMessage.getter(TimeSignalMessage::segmentationDescriptors)).setter(TimeSignalMessage.setter(Builder::segmentationDescriptors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SegmentationDescriptors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SegmentationDescriptor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEGMENTATION_DESCRIPTORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("SegmentationDescriptors", SEGMENTATION_DESCRIPTORS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<SegmentationDescriptor> segmentationDescriptors;

    private TimeSignalMessage(BuilderImpl builder) {
        this.segmentationDescriptors = builder.segmentationDescriptors;
    }

    public final boolean hasSegmentationDescriptors() {
        return this.segmentationDescriptors != null && !(this.segmentationDescriptors instanceof SdkAutoConstructList);
    }

    public final List<SegmentationDescriptor> segmentationDescriptors() {
        return this.segmentationDescriptors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSegmentationDescriptors() ? this.segmentationDescriptors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSignalMessage)) {
            return false;
        }
        TimeSignalMessage other = (TimeSignalMessage)obj;
        return this.hasSegmentationDescriptors() == other.hasSegmentationDescriptors() && Objects.equals(this.segmentationDescriptors(), other.segmentationDescriptors());
    }

    public final String toString() {
        return ToString.builder((String)"TimeSignalMessage").add("SegmentationDescriptors", this.hasSegmentationDescriptors() ? this.segmentationDescriptors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SegmentationDescriptors": {
                return Optional.ofNullable(clazz.cast(this.segmentationDescriptors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TimeSignalMessage, T> g) {
        return obj -> g.apply((TimeSignalMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SegmentationDescriptor> segmentationDescriptors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSignalMessage model) {
            this.segmentationDescriptors(model.segmentationDescriptors);
        }

        public final List<SegmentationDescriptor.Builder> getSegmentationDescriptors() {
            List<SegmentationDescriptor.Builder> result = SegmentationDescriptorListCopier.copyToBuilder(this.segmentationDescriptors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSegmentationDescriptors(Collection<SegmentationDescriptor.BuilderImpl> segmentationDescriptors) {
            this.segmentationDescriptors = SegmentationDescriptorListCopier.copyFromBuilder(segmentationDescriptors);
        }

        @Override
        public final Builder segmentationDescriptors(Collection<SegmentationDescriptor> segmentationDescriptors) {
            this.segmentationDescriptors = SegmentationDescriptorListCopier.copy(segmentationDescriptors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentationDescriptors(SegmentationDescriptor ... segmentationDescriptors) {
            this.segmentationDescriptors(Arrays.asList(segmentationDescriptors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder segmentationDescriptors(Consumer<SegmentationDescriptor.Builder> ... segmentationDescriptors) {
            this.segmentationDescriptors(Stream.of(segmentationDescriptors).map(c -> (SegmentationDescriptor)((SegmentationDescriptor.Builder)SegmentationDescriptor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TimeSignalMessage build() {
            return new TimeSignalMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TimeSignalMessage> {
        public Builder segmentationDescriptors(Collection<SegmentationDescriptor> var1);

        public Builder segmentationDescriptors(SegmentationDescriptor ... var1);

        public Builder segmentationDescriptors(Consumer<SegmentationDescriptor.Builder> ... var1);
    }
}

