/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediatailor.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediatailor.model.DashPlaylistSettings;
import software.amazon.awssdk.services.mediatailor.model.HlsPlaylistSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResponseOutputItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResponseOutputItem> {
    private static final SdkField<DashPlaylistSettings> DASH_PLAYLIST_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DashPlaylistSettings").getter(ResponseOutputItem.getter(ResponseOutputItem::dashPlaylistSettings)).setter(ResponseOutputItem.setter(Builder::dashPlaylistSettings)).constructor(DashPlaylistSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashPlaylistSettings").build()}).build();
    private static final SdkField<HlsPlaylistSettings> HLS_PLAYLIST_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HlsPlaylistSettings").getter(ResponseOutputItem.getter(ResponseOutputItem::hlsPlaylistSettings)).setter(ResponseOutputItem.setter(Builder::hlsPlaylistSettings)).constructor(HlsPlaylistSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HlsPlaylistSettings").build()}).build();
    private static final SdkField<String> MANIFEST_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManifestName").getter(ResponseOutputItem.getter(ResponseOutputItem::manifestName)).setter(ResponseOutputItem.setter(Builder::manifestName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestName").build()}).build();
    private static final SdkField<String> PLAYBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackUrl").getter(ResponseOutputItem.getter(ResponseOutputItem::playbackUrl)).setter(ResponseOutputItem.setter(Builder::playbackUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackUrl").build()}).build();
    private static final SdkField<String> SOURCE_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceGroup").getter(ResponseOutputItem.getter(ResponseOutputItem::sourceGroup)).setter(ResponseOutputItem.setter(Builder::sourceGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceGroup").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASH_PLAYLIST_SETTINGS_FIELD, HLS_PLAYLIST_SETTINGS_FIELD, MANIFEST_NAME_FIELD, PLAYBACK_URL_FIELD, SOURCE_GROUP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DashPlaylistSettings", DASH_PLAYLIST_SETTINGS_FIELD);
            this.put("HlsPlaylistSettings", HLS_PLAYLIST_SETTINGS_FIELD);
            this.put("ManifestName", MANIFEST_NAME_FIELD);
            this.put("PlaybackUrl", PLAYBACK_URL_FIELD);
            this.put("SourceGroup", SOURCE_GROUP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final DashPlaylistSettings dashPlaylistSettings;
    private final HlsPlaylistSettings hlsPlaylistSettings;
    private final String manifestName;
    private final String playbackUrl;
    private final String sourceGroup;

    private ResponseOutputItem(BuilderImpl builder) {
        this.dashPlaylistSettings = builder.dashPlaylistSettings;
        this.hlsPlaylistSettings = builder.hlsPlaylistSettings;
        this.manifestName = builder.manifestName;
        this.playbackUrl = builder.playbackUrl;
        this.sourceGroup = builder.sourceGroup;
    }

    public final DashPlaylistSettings dashPlaylistSettings() {
        return this.dashPlaylistSettings;
    }

    public final HlsPlaylistSettings hlsPlaylistSettings() {
        return this.hlsPlaylistSettings;
    }

    public final String manifestName() {
        return this.manifestName;
    }

    public final String playbackUrl() {
        return this.playbackUrl;
    }

    public final String sourceGroup() {
        return this.sourceGroup;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashPlaylistSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsPlaylistSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestName());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceGroup());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseOutputItem)) {
            return false;
        }
        ResponseOutputItem other = (ResponseOutputItem)obj;
        return Objects.equals(this.dashPlaylistSettings(), other.dashPlaylistSettings()) && Objects.equals(this.hlsPlaylistSettings(), other.hlsPlaylistSettings()) && Objects.equals(this.manifestName(), other.manifestName()) && Objects.equals(this.playbackUrl(), other.playbackUrl()) && Objects.equals(this.sourceGroup(), other.sourceGroup());
    }

    public final String toString() {
        return ToString.builder((String)"ResponseOutputItem").add("DashPlaylistSettings", (Object)this.dashPlaylistSettings()).add("HlsPlaylistSettings", (Object)this.hlsPlaylistSettings()).add("ManifestName", (Object)this.manifestName()).add("PlaybackUrl", (Object)this.playbackUrl()).add("SourceGroup", (Object)this.sourceGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashPlaylistSettings": {
                return Optional.ofNullable(clazz.cast(this.dashPlaylistSettings()));
            }
            case "HlsPlaylistSettings": {
                return Optional.ofNullable(clazz.cast(this.hlsPlaylistSettings()));
            }
            case "ManifestName": {
                return Optional.ofNullable(clazz.cast(this.manifestName()));
            }
            case "PlaybackUrl": {
                return Optional.ofNullable(clazz.cast(this.playbackUrl()));
            }
            case "SourceGroup": {
                return Optional.ofNullable(clazz.cast(this.sourceGroup()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResponseOutputItem, T> g) {
        return obj -> g.apply((ResponseOutputItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DashPlaylistSettings dashPlaylistSettings;
        private HlsPlaylistSettings hlsPlaylistSettings;
        private String manifestName;
        private String playbackUrl;
        private String sourceGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseOutputItem model) {
            this.dashPlaylistSettings(model.dashPlaylistSettings);
            this.hlsPlaylistSettings(model.hlsPlaylistSettings);
            this.manifestName(model.manifestName);
            this.playbackUrl(model.playbackUrl);
            this.sourceGroup(model.sourceGroup);
        }

        public final DashPlaylistSettings.Builder getDashPlaylistSettings() {
            return this.dashPlaylistSettings != null ? this.dashPlaylistSettings.toBuilder() : null;
        }

        public final void setDashPlaylistSettings(DashPlaylistSettings.BuilderImpl dashPlaylistSettings) {
            this.dashPlaylistSettings = dashPlaylistSettings != null ? dashPlaylistSettings.build() : null;
        }

        @Override
        public final Builder dashPlaylistSettings(DashPlaylistSettings dashPlaylistSettings) {
            this.dashPlaylistSettings = dashPlaylistSettings;
            return this;
        }

        public final HlsPlaylistSettings.Builder getHlsPlaylistSettings() {
            return this.hlsPlaylistSettings != null ? this.hlsPlaylistSettings.toBuilder() : null;
        }

        public final void setHlsPlaylistSettings(HlsPlaylistSettings.BuilderImpl hlsPlaylistSettings) {
            this.hlsPlaylistSettings = hlsPlaylistSettings != null ? hlsPlaylistSettings.build() : null;
        }

        @Override
        public final Builder hlsPlaylistSettings(HlsPlaylistSettings hlsPlaylistSettings) {
            this.hlsPlaylistSettings = hlsPlaylistSettings;
            return this;
        }

        public final String getManifestName() {
            return this.manifestName;
        }

        public final void setManifestName(String manifestName) {
            this.manifestName = manifestName;
        }

        @Override
        public final Builder manifestName(String manifestName) {
            this.manifestName = manifestName;
            return this;
        }

        public final String getPlaybackUrl() {
            return this.playbackUrl;
        }

        public final void setPlaybackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
        }

        @Override
        public final Builder playbackUrl(String playbackUrl) {
            this.playbackUrl = playbackUrl;
            return this;
        }

        public final String getSourceGroup() {
            return this.sourceGroup;
        }

        public final void setSourceGroup(String sourceGroup) {
            this.sourceGroup = sourceGroup;
        }

        @Override
        public final Builder sourceGroup(String sourceGroup) {
            this.sourceGroup = sourceGroup;
            return this;
        }

        public ResponseOutputItem build() {
            return new ResponseOutputItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResponseOutputItem> {
        public Builder dashPlaylistSettings(DashPlaylistSettings var1);

        default public Builder dashPlaylistSettings(Consumer<DashPlaylistSettings.Builder> dashPlaylistSettings) {
            return this.dashPlaylistSettings((DashPlaylistSettings)((DashPlaylistSettings.Builder)DashPlaylistSettings.builder().applyMutation(dashPlaylistSettings)).build());
        }

        public Builder hlsPlaylistSettings(HlsPlaylistSettings var1);

        default public Builder hlsPlaylistSettings(Consumer<HlsPlaylistSettings.Builder> hlsPlaylistSettings) {
            return this.hlsPlaylistSettings((HlsPlaylistSettings)((HlsPlaylistSettings.Builder)HlsPlaylistSettings.builder().applyMutation(hlsPlaylistSettings)).build());
        }

        public Builder manifestName(String var1);

        public Builder playbackUrl(String var1);

        public Builder sourceGroup(String var1);
    }
}

