/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfigureLogsForPlaybackConfigurationResponse extends MediaTailorResponse implements
        ToCopyableBuilder<ConfigureLogsForPlaybackConfigurationResponse.Builder, ConfigureLogsForPlaybackConfigurationResponse> {
    private static final SdkField<Integer> PERCENT_ENABLED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PercentEnabled").getter(getter(ConfigureLogsForPlaybackConfigurationResponse::percentEnabled))
            .setter(setter(Builder::percentEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PercentEnabled").build()).build();

    private static final SdkField<String> PLAYBACK_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlaybackConfigurationName")
            .getter(getter(ConfigureLogsForPlaybackConfigurationResponse::playbackConfigurationName))
            .setter(setter(Builder::playbackConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackConfigurationName").build())
            .build();

    private static final SdkField<List<String>> ENABLED_LOGGING_STRATEGIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledLoggingStrategies")
            .getter(getter(ConfigureLogsForPlaybackConfigurationResponse::enabledLoggingStrategiesAsStrings))
            .setter(setter(Builder::enabledLoggingStrategiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledLoggingStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENT_ENABLED_FIELD,
            PLAYBACK_CONFIGURATION_NAME_FIELD, ENABLED_LOGGING_STRATEGIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer percentEnabled;

    private final String playbackConfigurationName;

    private final List<String> enabledLoggingStrategies;

    private ConfigureLogsForPlaybackConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.percentEnabled = builder.percentEnabled;
        this.playbackConfigurationName = builder.playbackConfigurationName;
        this.enabledLoggingStrategies = builder.enabledLoggingStrategies;
    }

    /**
     * <p>
     * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.
     * </p>
     * 
     * @return The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.
     */
    public final Integer percentEnabled() {
        return percentEnabled;
    }

    /**
     * <p>
     * The name of the playback configuration.
     * </p>
     * 
     * @return The name of the playback configuration.
     */
    public final String playbackConfigurationName() {
        return playbackConfigurationName;
    }

    /**
     * <p>
     * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates that
     * MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
     * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
     * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledLoggingStrategies} method.
     * </p>
     * 
     * @return The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
     *         indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code>
     *         indicates that MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination
     *         of choice. Supported destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data
     *         Firehose stream.
     */
    public final List<LoggingStrategy> enabledLoggingStrategies() {
        return ___listOfLoggingStrategiesCopier.copyStringToEnum(enabledLoggingStrategies);
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledLoggingStrategies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledLoggingStrategies() {
        return enabledLoggingStrategies != null && !(enabledLoggingStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates that
     * MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
     * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
     * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledLoggingStrategies} method.
     * </p>
     * 
     * @return The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
     *         indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code>
     *         indicates that MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination
     *         of choice. Supported destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data
     *         Firehose stream.
     */
    public final List<String> enabledLoggingStrategiesAsStrings() {
        return enabledLoggingStrategies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(percentEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(playbackConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledLoggingStrategies() ? enabledLoggingStrategiesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigureLogsForPlaybackConfigurationResponse)) {
            return false;
        }
        ConfigureLogsForPlaybackConfigurationResponse other = (ConfigureLogsForPlaybackConfigurationResponse) obj;
        return Objects.equals(percentEnabled(), other.percentEnabled())
                && Objects.equals(playbackConfigurationName(), other.playbackConfigurationName())
                && hasEnabledLoggingStrategies() == other.hasEnabledLoggingStrategies()
                && Objects.equals(enabledLoggingStrategiesAsStrings(), other.enabledLoggingStrategiesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfigureLogsForPlaybackConfigurationResponse").add("PercentEnabled", percentEnabled())
                .add("PlaybackConfigurationName", playbackConfigurationName())
                .add("EnabledLoggingStrategies", hasEnabledLoggingStrategies() ? enabledLoggingStrategiesAsStrings() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PercentEnabled":
            return Optional.ofNullable(clazz.cast(percentEnabled()));
        case "PlaybackConfigurationName":
            return Optional.ofNullable(clazz.cast(playbackConfigurationName()));
        case "EnabledLoggingStrategies":
            return Optional.ofNullable(clazz.cast(enabledLoggingStrategiesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PercentEnabled", PERCENT_ENABLED_FIELD);
        map.put("PlaybackConfigurationName", PLAYBACK_CONFIGURATION_NAME_FIELD);
        map.put("EnabledLoggingStrategies", ENABLED_LOGGING_STRATEGIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfigureLogsForPlaybackConfigurationResponse, T> g) {
        return obj -> g.apply((ConfigureLogsForPlaybackConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ConfigureLogsForPlaybackConfigurationResponse> {
        /**
         * <p>
         * The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.
         * </p>
         * 
         * @param percentEnabled
         *        The percentage of session logs that MediaTailor sends to your Cloudwatch Logs account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder percentEnabled(Integer percentEnabled);

        /**
         * <p>
         * The name of the playback configuration.
         * </p>
         * 
         * @param playbackConfigurationName
         *        The name of the playback configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder playbackConfigurationName(String playbackConfigurationName);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategiesWithStrings(String... enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies);

        /**
         * <p>
         * The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code> indicates
         * that MediaTailor is sending logs directly to Amazon CloudWatch Logs. <code>VENDED_LOGS</code> indicates that
         * MediaTailor is sending logs to CloudWatch, which then vends the logs to your destination of choice. Supported
         * destinations are CloudWatch Logs log group, Amazon S3 bucket, and Amazon Data Firehose stream.
         * </p>
         * 
         * @param enabledLoggingStrategies
         *        The method used for collecting logs from AWS Elemental MediaTailor. <code>LEGACY_CLOUDWATCH</code>
         *        indicates that MediaTailor is sending logs directly to Amazon CloudWatch Logs.
         *        <code>VENDED_LOGS</code> indicates that MediaTailor is sending logs to CloudWatch, which then vends
         *        the logs to your destination of choice. Supported destinations are CloudWatch Logs log group, Amazon
         *        S3 bucket, and Amazon Data Firehose stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledLoggingStrategies(LoggingStrategy... enabledLoggingStrategies);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private Integer percentEnabled;

        private String playbackConfigurationName;

        private List<String> enabledLoggingStrategies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigureLogsForPlaybackConfigurationResponse model) {
            super(model);
            percentEnabled(model.percentEnabled);
            playbackConfigurationName(model.playbackConfigurationName);
            enabledLoggingStrategiesWithStrings(model.enabledLoggingStrategies);
        }

        public final Integer getPercentEnabled() {
            return percentEnabled;
        }

        public final void setPercentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
        }

        @Override
        public final Builder percentEnabled(Integer percentEnabled) {
            this.percentEnabled = percentEnabled;
            return this;
        }

        public final String getPlaybackConfigurationName() {
            return playbackConfigurationName;
        }

        public final void setPlaybackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
        }

        @Override
        public final Builder playbackConfigurationName(String playbackConfigurationName) {
            this.playbackConfigurationName = playbackConfigurationName;
            return this;
        }

        public final Collection<String> getEnabledLoggingStrategies() {
            if (enabledLoggingStrategies instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledLoggingStrategies;
        }

        public final void setEnabledLoggingStrategies(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
        }

        @Override
        public final Builder enabledLoggingStrategiesWithStrings(Collection<String> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copy(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategiesWithStrings(String... enabledLoggingStrategies) {
            enabledLoggingStrategiesWithStrings(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public final Builder enabledLoggingStrategies(Collection<LoggingStrategy> enabledLoggingStrategies) {
            this.enabledLoggingStrategies = ___listOfLoggingStrategiesCopier.copyEnumToString(enabledLoggingStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledLoggingStrategies(LoggingStrategy... enabledLoggingStrategies) {
            enabledLoggingStrategies(Arrays.asList(enabledLoggingStrategies));
            return this;
        }

        @Override
        public ConfigureLogsForPlaybackConfigurationResponse build() {
            return new ConfigureLogsForPlaybackConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
