/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProgramResponse extends MediaTailorResponse implements
        ToCopyableBuilder<UpdateProgramResponse.Builder, UpdateProgramResponse> {
    private static final SdkField<List<AdBreak>> AD_BREAKS_FIELD = SdkField
            .<List<AdBreak>> builder(MarshallingType.LIST)
            .memberName("AdBreaks")
            .getter(getter(UpdateProgramResponse::adBreaks))
            .setter(setter(Builder::adBreaks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdBreaks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdBreak> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdBreak::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateProgramResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(UpdateProgramResponse::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(UpdateProgramResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> PROGRAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProgramName").getter(getter(UpdateProgramResponse::programName)).setter(setter(Builder::programName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgramName").build()).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(UpdateProgramResponse::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(UpdateProgramResponse::vodSourceName))
            .setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()).build();

    private static final SdkField<String> LIVE_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LiveSourceName").getter(getter(UpdateProgramResponse::liveSourceName))
            .setter(setter(Builder::liveSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiveSourceName").build()).build();

    private static final SdkField<ClipRange> CLIP_RANGE_FIELD = SdkField.<ClipRange> builder(MarshallingType.SDK_POJO)
            .memberName("ClipRange").getter(getter(UpdateProgramResponse::clipRange)).setter(setter(Builder::clipRange))
            .constructor(ClipRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClipRange").build()).build();

    private static final SdkField<Long> DURATION_MILLIS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DurationMillis").getter(getter(UpdateProgramResponse::durationMillis))
            .setter(setter(Builder::durationMillis))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DurationMillis").build()).build();

    private static final SdkField<Instant> SCHEDULED_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledStartTime")
            .getter(getter(UpdateProgramResponse::scheduledStartTime))
            .setter(setter(Builder::scheduledStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledStartTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<List<AudienceMedia>> AUDIENCE_MEDIA_FIELD = SdkField
            .<List<AudienceMedia>> builder(MarshallingType.LIST)
            .memberName("AudienceMedia")
            .getter(getter(UpdateProgramResponse::audienceMedia))
            .setter(setter(Builder::audienceMedia))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AudienceMedia").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudienceMedia> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudienceMedia::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AD_BREAKS_FIELD, ARN_FIELD,
            CHANNEL_NAME_FIELD, CREATION_TIME_FIELD, PROGRAM_NAME_FIELD, SOURCE_LOCATION_NAME_FIELD, VOD_SOURCE_NAME_FIELD,
            LIVE_SOURCE_NAME_FIELD, CLIP_RANGE_FIELD, DURATION_MILLIS_FIELD, SCHEDULED_START_TIME_FIELD, AUDIENCE_MEDIA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AdBreak> adBreaks;

    private final String arn;

    private final String channelName;

    private final Instant creationTime;

    private final String programName;

    private final String sourceLocationName;

    private final String vodSourceName;

    private final String liveSourceName;

    private final ClipRange clipRange;

    private final Long durationMillis;

    private final Instant scheduledStartTime;

    private final List<AudienceMedia> audienceMedia;

    private UpdateProgramResponse(BuilderImpl builder) {
        super(builder);
        this.adBreaks = builder.adBreaks;
        this.arn = builder.arn;
        this.channelName = builder.channelName;
        this.creationTime = builder.creationTime;
        this.programName = builder.programName;
        this.sourceLocationName = builder.sourceLocationName;
        this.vodSourceName = builder.vodSourceName;
        this.liveSourceName = builder.liveSourceName;
        this.clipRange = builder.clipRange;
        this.durationMillis = builder.durationMillis;
        this.scheduledStartTime = builder.scheduledStartTime;
        this.audienceMedia = builder.audienceMedia;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdBreaks property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdBreaks() {
        return adBreaks != null && !(adBreaks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ad break configuration settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdBreaks} method.
     * </p>
     * 
     * @return The ad break configuration settings.
     */
    public final List<AdBreak> adBreaks() {
        return adBreaks;
    }

    /**
     * <p>
     * The ARN to assign to the program.
     * </p>
     * 
     * @return The ARN to assign to the program.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name to assign to the channel for this program.
     * </p>
     * 
     * @return The name to assign to the channel for this program.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The time the program was created.
     * </p>
     * 
     * @return The time the program was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The name to assign to this program.
     * </p>
     * 
     * @return The name to assign to this program.
     */
    public final String programName() {
        return programName;
    }

    /**
     * <p>
     * The name to assign to the source location for this program.
     * </p>
     * 
     * @return The name to assign to the source location for this program.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * <p>
     * The name that's used to refer to a VOD source.
     * </p>
     * 
     * @return The name that's used to refer to a VOD source.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    /**
     * <p>
     * The name of the LiveSource for this Program.
     * </p>
     * 
     * @return The name of the LiveSource for this Program.
     */
    public final String liveSourceName() {
        return liveSourceName;
    }

    /**
     * <p>
     * The clip range configuration settings.
     * </p>
     * 
     * @return The clip range configuration settings.
     */
    public final ClipRange clipRange() {
        return clipRange;
    }

    /**
     * <p>
     * The duration of the live program in milliseconds.
     * </p>
     * 
     * @return The duration of the live program in milliseconds.
     */
    public final Long durationMillis() {
        return durationMillis;
    }

    /**
     * <p>
     * The scheduled start time for this Program.
     * </p>
     * 
     * @return The scheduled start time for this Program.
     */
    public final Instant scheduledStartTime() {
        return scheduledStartTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the AudienceMedia property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAudienceMedia() {
        return audienceMedia != null && !(audienceMedia instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of AudienceMedia defined in program.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudienceMedia} method.
     * </p>
     * 
     * @return The list of AudienceMedia defined in program.
     */
    public final List<AudienceMedia> audienceMedia() {
        return audienceMedia;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdBreaks() ? adBreaks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(programName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(liveSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(clipRange());
        hashCode = 31 * hashCode + Objects.hashCode(durationMillis());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasAudienceMedia() ? audienceMedia() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProgramResponse)) {
            return false;
        }
        UpdateProgramResponse other = (UpdateProgramResponse) obj;
        return hasAdBreaks() == other.hasAdBreaks() && Objects.equals(adBreaks(), other.adBreaks())
                && Objects.equals(arn(), other.arn()) && Objects.equals(channelName(), other.channelName())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(programName(), other.programName())
                && Objects.equals(sourceLocationName(), other.sourceLocationName())
                && Objects.equals(vodSourceName(), other.vodSourceName())
                && Objects.equals(liveSourceName(), other.liveSourceName()) && Objects.equals(clipRange(), other.clipRange())
                && Objects.equals(durationMillis(), other.durationMillis())
                && Objects.equals(scheduledStartTime(), other.scheduledStartTime())
                && hasAudienceMedia() == other.hasAudienceMedia() && Objects.equals(audienceMedia(), other.audienceMedia());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProgramResponse").add("AdBreaks", hasAdBreaks() ? adBreaks() : null).add("Arn", arn())
                .add("ChannelName", channelName()).add("CreationTime", creationTime()).add("ProgramName", programName())
                .add("SourceLocationName", sourceLocationName()).add("VodSourceName", vodSourceName())
                .add("LiveSourceName", liveSourceName()).add("ClipRange", clipRange()).add("DurationMillis", durationMillis())
                .add("ScheduledStartTime", scheduledStartTime())
                .add("AudienceMedia", hasAudienceMedia() ? audienceMedia() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AdBreaks":
            return Optional.ofNullable(clazz.cast(adBreaks()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "ProgramName":
            return Optional.ofNullable(clazz.cast(programName()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        case "LiveSourceName":
            return Optional.ofNullable(clazz.cast(liveSourceName()));
        case "ClipRange":
            return Optional.ofNullable(clazz.cast(clipRange()));
        case "DurationMillis":
            return Optional.ofNullable(clazz.cast(durationMillis()));
        case "ScheduledStartTime":
            return Optional.ofNullable(clazz.cast(scheduledStartTime()));
        case "AudienceMedia":
            return Optional.ofNullable(clazz.cast(audienceMedia()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AdBreaks", AD_BREAKS_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ChannelName", CHANNEL_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("ProgramName", PROGRAM_NAME_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        map.put("VodSourceName", VOD_SOURCE_NAME_FIELD);
        map.put("LiveSourceName", LIVE_SOURCE_NAME_FIELD);
        map.put("ClipRange", CLIP_RANGE_FIELD);
        map.put("DurationMillis", DURATION_MILLIS_FIELD);
        map.put("ScheduledStartTime", SCHEDULED_START_TIME_FIELD);
        map.put("AudienceMedia", AUDIENCE_MEDIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProgramResponse, T> g) {
        return obj -> g.apply((UpdateProgramResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProgramResponse> {
        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * 
         * @param adBreaks
         *        The ad break configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(Collection<AdBreak> adBreaks);

        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * 
         * @param adBreaks
         *        The ad break configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adBreaks(AdBreak... adBreaks);

        /**
         * <p>
         * The ad break configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.mediatailor.model.AdBreak#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder#build()} is called immediately and
         * its result is passed to {@link #adBreaks(List<AdBreak>)}.
         * 
         * @param adBreaks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AdBreak.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #adBreaks(java.util.Collection<AdBreak>)
         */
        Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks);

        /**
         * <p>
         * The ARN to assign to the program.
         * </p>
         * 
         * @param arn
         *        The ARN to assign to the program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name to assign to the channel for this program.
         * </p>
         * 
         * @param channelName
         *        The name to assign to the channel for this program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The time the program was created.
         * </p>
         * 
         * @param creationTime
         *        The time the program was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The name to assign to this program.
         * </p>
         * 
         * @param programName
         *        The name to assign to this program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder programName(String programName);

        /**
         * <p>
         * The name to assign to the source location for this program.
         * </p>
         * 
         * @param sourceLocationName
         *        The name to assign to the source location for this program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The name that's used to refer to a VOD source.
         * </p>
         * 
         * @param vodSourceName
         *        The name that's used to refer to a VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);

        /**
         * <p>
         * The name of the LiveSource for this Program.
         * </p>
         * 
         * @param liveSourceName
         *        The name of the LiveSource for this Program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder liveSourceName(String liveSourceName);

        /**
         * <p>
         * The clip range configuration settings.
         * </p>
         * 
         * @param clipRange
         *        The clip range configuration settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clipRange(ClipRange clipRange);

        /**
         * <p>
         * The clip range configuration settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClipRange.Builder} avoiding the need to
         * create one manually via {@link ClipRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClipRange.Builder#build()} is called immediately and its result
         * is passed to {@link #clipRange(ClipRange)}.
         * 
         * @param clipRange
         *        a consumer that will call methods on {@link ClipRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clipRange(ClipRange)
         */
        default Builder clipRange(Consumer<ClipRange.Builder> clipRange) {
            return clipRange(ClipRange.builder().applyMutation(clipRange).build());
        }

        /**
         * <p>
         * The duration of the live program in milliseconds.
         * </p>
         * 
         * @param durationMillis
         *        The duration of the live program in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder durationMillis(Long durationMillis);

        /**
         * <p>
         * The scheduled start time for this Program.
         * </p>
         * 
         * @param scheduledStartTime
         *        The scheduled start time for this Program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledStartTime(Instant scheduledStartTime);

        /**
         * <p>
         * The list of AudienceMedia defined in program.
         * </p>
         * 
         * @param audienceMedia
         *        The list of AudienceMedia defined in program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceMedia(Collection<AudienceMedia> audienceMedia);

        /**
         * <p>
         * The list of AudienceMedia defined in program.
         * </p>
         * 
         * @param audienceMedia
         *        The list of AudienceMedia defined in program.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audienceMedia(AudienceMedia... audienceMedia);

        /**
         * <p>
         * The list of AudienceMedia defined in program.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.AudienceMedia.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.mediatailor.model.AudienceMedia#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.AudienceMedia.Builder#build()} is called immediately
         * and its result is passed to {@link #audienceMedia(List<AudienceMedia>)}.
         * 
         * @param audienceMedia
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.AudienceMedia.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audienceMedia(java.util.Collection<AudienceMedia>)
         */
        Builder audienceMedia(Consumer<AudienceMedia.Builder>... audienceMedia);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private List<AdBreak> adBreaks = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private String channelName;

        private Instant creationTime;

        private String programName;

        private String sourceLocationName;

        private String vodSourceName;

        private String liveSourceName;

        private ClipRange clipRange;

        private Long durationMillis;

        private Instant scheduledStartTime;

        private List<AudienceMedia> audienceMedia = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProgramResponse model) {
            super(model);
            adBreaks(model.adBreaks);
            arn(model.arn);
            channelName(model.channelName);
            creationTime(model.creationTime);
            programName(model.programName);
            sourceLocationName(model.sourceLocationName);
            vodSourceName(model.vodSourceName);
            liveSourceName(model.liveSourceName);
            clipRange(model.clipRange);
            durationMillis(model.durationMillis);
            scheduledStartTime(model.scheduledStartTime);
            audienceMedia(model.audienceMedia);
        }

        public final List<AdBreak.Builder> getAdBreaks() {
            List<AdBreak.Builder> result = ___listOfAdBreakCopier.copyToBuilder(this.adBreaks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdBreaks(Collection<AdBreak.BuilderImpl> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copyFromBuilder(adBreaks);
        }

        @Override
        public final Builder adBreaks(Collection<AdBreak> adBreaks) {
            this.adBreaks = ___listOfAdBreakCopier.copy(adBreaks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(AdBreak... adBreaks) {
            adBreaks(Arrays.asList(adBreaks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adBreaks(Consumer<AdBreak.Builder>... adBreaks) {
            adBreaks(Stream.of(adBreaks).map(c -> AdBreak.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getProgramName() {
            return programName;
        }

        public final void setProgramName(String programName) {
            this.programName = programName;
        }

        @Override
        public final Builder programName(String programName) {
            this.programName = programName;
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        public final String getLiveSourceName() {
            return liveSourceName;
        }

        public final void setLiveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
        }

        @Override
        public final Builder liveSourceName(String liveSourceName) {
            this.liveSourceName = liveSourceName;
            return this;
        }

        public final ClipRange.Builder getClipRange() {
            return clipRange != null ? clipRange.toBuilder() : null;
        }

        public final void setClipRange(ClipRange.BuilderImpl clipRange) {
            this.clipRange = clipRange != null ? clipRange.build() : null;
        }

        @Override
        public final Builder clipRange(ClipRange clipRange) {
            this.clipRange = clipRange;
            return this;
        }

        public final Long getDurationMillis() {
            return durationMillis;
        }

        public final void setDurationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
        }

        @Override
        public final Builder durationMillis(Long durationMillis) {
            this.durationMillis = durationMillis;
            return this;
        }

        public final Instant getScheduledStartTime() {
            return scheduledStartTime;
        }

        public final void setScheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
        }

        @Override
        public final Builder scheduledStartTime(Instant scheduledStartTime) {
            this.scheduledStartTime = scheduledStartTime;
            return this;
        }

        public final List<AudienceMedia.Builder> getAudienceMedia() {
            List<AudienceMedia.Builder> result = ___listOfAudienceMediaCopier.copyToBuilder(this.audienceMedia);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudienceMedia(Collection<AudienceMedia.BuilderImpl> audienceMedia) {
            this.audienceMedia = ___listOfAudienceMediaCopier.copyFromBuilder(audienceMedia);
        }

        @Override
        public final Builder audienceMedia(Collection<AudienceMedia> audienceMedia) {
            this.audienceMedia = ___listOfAudienceMediaCopier.copy(audienceMedia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceMedia(AudienceMedia... audienceMedia) {
            audienceMedia(Arrays.asList(audienceMedia));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audienceMedia(Consumer<AudienceMedia.Builder>... audienceMedia) {
            audienceMedia(Stream.of(audienceMedia).map(c -> AudienceMedia.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public UpdateProgramResponse build() {
            return new UpdateProgramResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
