/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediatailor.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVodSourceResponse extends MediaTailorResponse implements
        ToCopyableBuilder<UpdateVodSourceResponse.Builder, UpdateVodSourceResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateVodSourceResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime")
            .getter(getter(UpdateVodSourceResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<List<HttpPackageConfiguration>> HTTP_PACKAGE_CONFIGURATIONS_FIELD = SdkField
            .<List<HttpPackageConfiguration>> builder(MarshallingType.LIST)
            .memberName("HttpPackageConfigurations")
            .getter(getter(UpdateVodSourceResponse::httpPackageConfigurations))
            .setter(setter(Builder::httpPackageConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPackageConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<HttpPackageConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(HttpPackageConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime")
            .getter(getter(UpdateVodSourceResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.UNIX_TIMESTAMP)).build();

    private static final SdkField<String> SOURCE_LOCATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceLocationName").getter(getter(UpdateVodSourceResponse::sourceLocationName))
            .setter(setter(Builder::sourceLocationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLocationName").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(UpdateVodSourceResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> VOD_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VodSourceName").getter(getter(UpdateVodSourceResponse::vodSourceName))
            .setter(setter(Builder::vodSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VodSourceName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CREATION_TIME_FIELD, HTTP_PACKAGE_CONFIGURATIONS_FIELD, LAST_MODIFIED_TIME_FIELD, SOURCE_LOCATION_NAME_FIELD,
            TAGS_FIELD, VOD_SOURCE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final Instant creationTime;

    private final List<HttpPackageConfiguration> httpPackageConfigurations;

    private final Instant lastModifiedTime;

    private final String sourceLocationName;

    private final Map<String, String> tags;

    private final String vodSourceName;

    private UpdateVodSourceResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.creationTime = builder.creationTime;
        this.httpPackageConfigurations = builder.httpPackageConfigurations;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.sourceLocationName = builder.sourceLocationName;
        this.tags = builder.tags;
        this.vodSourceName = builder.vodSourceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) associated with the VOD source.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) associated with the VOD source.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The timestamp that indicates when the VOD source was created.
     * </p>
     * 
     * @return The timestamp that indicates when the VOD source was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the HttpPackageConfigurations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHttpPackageConfigurations() {
        return httpPackageConfigurations != null && !(httpPackageConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of HTTP package configurations for the VOD source on this account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHttpPackageConfigurations} method.
     * </p>
     * 
     * @return A list of HTTP package configurations for the VOD source on this account.
     */
    public final List<HttpPackageConfiguration> httpPackageConfigurations() {
        return httpPackageConfigurations;
    }

    /**
     * <p>
     * The timestamp that indicates when the VOD source was last modified.
     * </p>
     * 
     * @return The timestamp that indicates when the VOD source was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The name of the source location associated with the VOD source.
     * </p>
     * 
     * @return The name of the source location associated with the VOD source.
     */
    public final String sourceLocationName() {
        return sourceLocationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources to
     * help with organization, access control, and cost tracking. For more information, see <a
     * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     * Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon
     *         resources to help with organization, access control, and cost tracking. For more information, see <a
     *         href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
     *         Resources</a>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The name of the VOD source.
     * </p>
     * 
     * @return The name of the VOD source.
     */
    public final String vodSourceName() {
        return vodSourceName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasHttpPackageConfigurations() ? httpPackageConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vodSourceName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVodSourceResponse)) {
            return false;
        }
        UpdateVodSourceResponse other = (UpdateVodSourceResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(creationTime(), other.creationTime())
                && hasHttpPackageConfigurations() == other.hasHttpPackageConfigurations()
                && Objects.equals(httpPackageConfigurations(), other.httpPackageConfigurations())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(sourceLocationName(), other.sourceLocationName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(vodSourceName(), other.vodSourceName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVodSourceResponse").add("Arn", arn()).add("CreationTime", creationTime())
                .add("HttpPackageConfigurations", hasHttpPackageConfigurations() ? httpPackageConfigurations() : null)
                .add("LastModifiedTime", lastModifiedTime()).add("SourceLocationName", sourceLocationName())
                .add("Tags", hasTags() ? tags() : null).add("VodSourceName", vodSourceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "HttpPackageConfigurations":
            return Optional.ofNullable(clazz.cast(httpPackageConfigurations()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "SourceLocationName":
            return Optional.ofNullable(clazz.cast(sourceLocationName()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VodSourceName":
            return Optional.ofNullable(clazz.cast(vodSourceName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("HttpPackageConfigurations", HTTP_PACKAGE_CONFIGURATIONS_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("SourceLocationName", SOURCE_LOCATION_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("VodSourceName", VOD_SOURCE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVodSourceResponse, T> g) {
        return obj -> g.apply((UpdateVodSourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaTailorResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVodSourceResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) associated with the VOD source.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) associated with the VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The timestamp that indicates when the VOD source was created.
         * </p>
         * 
         * @param creationTime
         *        The timestamp that indicates when the VOD source was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A list of HTTP package configurations for the VOD source on this account.
         * </p>
         * 
         * @param httpPackageConfigurations
         *        A list of HTTP package configurations for the VOD source on this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations);

        /**
         * <p>
         * A list of HTTP package configurations for the VOD source on this account.
         * </p>
         * 
         * @param httpPackageConfigurations
         *        A list of HTTP package configurations for the VOD source on this account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPackageConfigurations(HttpPackageConfiguration... httpPackageConfigurations);

        /**
         * <p>
         * A list of HTTP package configurations for the VOD source on this account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #httpPackageConfigurations(List<HttpPackageConfiguration>)}.
         * 
         * @param httpPackageConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.mediatailor.model.HttpPackageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #httpPackageConfigurations(java.util.Collection<HttpPackageConfiguration>)
         */
        Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder>... httpPackageConfigurations);

        /**
         * <p>
         * The timestamp that indicates when the VOD source was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The timestamp that indicates when the VOD source was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The name of the source location associated with the VOD source.
         * </p>
         * 
         * @param sourceLocationName
         *        The name of the source location associated with the VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocationName(String sourceLocationName);

        /**
         * <p>
         * The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon resources
         * to help with organization, access control, and cost tracking. For more information, see <a
         * href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental MediaTailor
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        The tags to assign to the VOD source. Tags are key-value pairs that you can associate with Amazon
         *        resources to help with organization, access control, and cost tracking. For more information, see <a
         *        href="https://docs.aws.amazon.com/mediatailor/latest/ug/tagging.html">Tagging AWS Elemental
         *        MediaTailor Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The name of the VOD source.
         * </p>
         * 
         * @param vodSourceName
         *        The name of the VOD source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vodSourceName(String vodSourceName);
    }

    static final class BuilderImpl extends MediaTailorResponse.BuilderImpl implements Builder {
        private String arn;

        private Instant creationTime;

        private List<HttpPackageConfiguration> httpPackageConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Instant lastModifiedTime;

        private String sourceLocationName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String vodSourceName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVodSourceResponse model) {
            super(model);
            arn(model.arn);
            creationTime(model.creationTime);
            httpPackageConfigurations(model.httpPackageConfigurations);
            lastModifiedTime(model.lastModifiedTime);
            sourceLocationName(model.sourceLocationName);
            tags(model.tags);
            vodSourceName(model.vodSourceName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final List<HttpPackageConfiguration.Builder> getHttpPackageConfigurations() {
            List<HttpPackageConfiguration.Builder> result = HttpPackageConfigurationsCopier
                    .copyToBuilder(this.httpPackageConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHttpPackageConfigurations(Collection<HttpPackageConfiguration.BuilderImpl> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copyFromBuilder(httpPackageConfigurations);
        }

        @Override
        public final Builder httpPackageConfigurations(Collection<HttpPackageConfiguration> httpPackageConfigurations) {
            this.httpPackageConfigurations = HttpPackageConfigurationsCopier.copy(httpPackageConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(HttpPackageConfiguration... httpPackageConfigurations) {
            httpPackageConfigurations(Arrays.asList(httpPackageConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder httpPackageConfigurations(Consumer<HttpPackageConfiguration.Builder>... httpPackageConfigurations) {
            httpPackageConfigurations(Stream.of(httpPackageConfigurations)
                    .map(c -> HttpPackageConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getSourceLocationName() {
            return sourceLocationName;
        }

        public final void setSourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
        }

        @Override
        public final Builder sourceLocationName(String sourceLocationName) {
            this.sourceLocationName = sourceLocationName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getVodSourceName() {
            return vodSourceName;
        }

        public final void setVodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
        }

        @Override
        public final Builder vodSourceName(String vodSourceName) {
            this.vodSourceName = vodSourceName;
            return this;
        }

        @Override
        public UpdateVodSourceResponse build() {
            return new UpdateVodSourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
